package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link ServerMessage}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ServerMessageFieldAttributes extends AbstractBeanAttributesDefinition{

    /** answer (Database column: ANSWER - Answer received) */
    static public AttributeDefinition answer =
        new AttributeDefinition("answer")
                .setDescription("Answer received")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER_MESSAGE")
                .setDatabaseId("ANSWER")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(String.class);

    /** elapsedTime (Database column: ELAPSED_TIME - Time elapsed to get an answer) */
    static public AttributeDefinition elapsedTime =
        new AttributeDefinition("elapsedTime")
                .setDescription("Time elapsed to get an answer")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER_MESSAGE")
                .setDatabaseId("ELAPSED_TIME")
                .setMandatory(false)
                .setMaxSize(22)
                .setType(Long.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER_MESSAGE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** message (Database column: MESSAGE - Message sent) */
    static public AttributeDefinition message =
        new AttributeDefinition("message")
                .setDescription("Message sent")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER_MESSAGE")
                .setDatabaseId("MESSAGE")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** processed (Database column: PROCESSED - If the message was processed by the receiver) */
    static public AttributeDefinition processed =
        new AttributeDefinition("processed")
                .setDescription("If the message was processed by the receiver")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER_MESSAGE")
                .setDatabaseId("PROCESSED")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** serverByServerReceiverId (Database column: SERVER_RECEIVER_ID - The receiver server ID) */
    static public AttributeDefinition serverByServerReceiverId =
        new AttributeDefinition("serverByServerReceiverId")
                .setDescription("The receiver server ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER_MESSAGE")
                .setDatabaseId("SERVER_RECEIVER_ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Server.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Server.class);

    /** serverByServerSenderId (Database column: SERVER_SENDER_ID - The sender server ID) */
    static public AttributeDefinition serverByServerSenderId =
        new AttributeDefinition("serverByServerSenderId")
                .setDescription("The sender server ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER_MESSAGE")
                .setDatabaseId("SERVER_SENDER_ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Server.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Server.class);

    /** success (Database column: SUCCESS - If the message was successfully executed) */
    static public AttributeDefinition success =
        new AttributeDefinition("success")
                .setDescription("If the message was successfully executed")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER_MESSAGE")
                .setDatabaseId("SUCCESS")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** when (Database column: WHEN - Message time stamp) */
    static public AttributeDefinition when =
        new AttributeDefinition("when")
                .setDescription("Message time stamp")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER_MESSAGE")
                .setDatabaseId("WHEN")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(answer.getName(),answer);
        map.put(elapsedTime.getName(),elapsedTime);
        map.put(id.getName(),id);
        map.put(message.getName(),message);
        map.put(processed.getName(),processed);
        map.put(serverByServerReceiverId.getName(),serverByServerReceiverId);
        map.put(serverByServerSenderId.getName(),serverByServerSenderId);
        map.put(success.getName(),success);
        map.put(when.getName(),when);

        return map;
    }
}