package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link UserDataRequestComment}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class UserDataRequestCommentFieldAttributes extends AbstractBeanAttributesDefinition{

    /** commentBody (Database column: COMMENT_BODY - The comment) */
    static public AttributeDefinition commentBody =
        new AttributeDefinition("commentBody")
                .setDescription("The comment")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_REQUEST_COMMENT")
                .setDatabaseId("COMMENT_BODY")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** commentDate (Database column: COMMENT_DATE - The comment date) */
    static public AttributeDefinition commentDate =
        new AttributeDefinition("commentDate")
                .setDescription("The comment date")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_REQUEST_COMMENT")
                .setDatabaseId("COMMENT_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_REQUEST_COMMENT")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** userDataRequest (Database column: REQUEST_ID - The request ID) */
    static public AttributeDefinition userDataRequest =
        new AttributeDefinition("userDataRequest")
                .setDescription("The request ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_REQUEST_COMMENT")
                .setDatabaseId("REQUEST_ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.UserDataRequest.class);

    /** userId (Database column: USER_ID - The user ID) */
    static public AttributeDefinition userId =
        new AttributeDefinition("userId")
                .setDescription("The user ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_REQUEST_COMMENT")
                .setDatabaseId("USER_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(commentBody.getName(),commentBody);
        map.put(commentDate.getName(),commentDate);
        map.put(id.getName(),id);
        map.put(userDataRequest.getName(),userDataRequest);
        map.put(userId.getName(),userId);

        return map;
    }
}