package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * UserPreferences
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class UserPreferences extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<UserPreferences> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** UserPreferences attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** configId column */
        public static final String CONFIGID ="configId";
        /** userId column */
        public static final String USERID ="userId";
        /** attributeKey column */
        public static final String ATTRIBUTEKEY ="attributeKey";
        /** attributeValue column */
        public static final String ATTRIBUTEVALUE ="attributeValue";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("configId");
            list.add("userId");
            list.add("attributeKey");
            list.add("attributeValue");

            return list;
        }
    }

    /** Field attributes */
    public static UserPreferencesFieldAttributes FieldAttributes=new UserPreferencesFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public UserPreferencesFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the CONFIGID path.
         *
         * @return the path
         */
        public String CONFIGID()
        {
            return buildPath(Fields.CONFIGID);
        }
        /**
         * the USERID path.
         *
         * @return the path
         */
        public String USERID()
        {
            return buildPath(Fields.USERID);
        }
        /**
         * the ATTRIBUTEKEY path.
         *
         * @return the path
         */
        public String ATTRIBUTEKEY()
        {
            return buildPath(Fields.ATTRIBUTEKEY);
        }
        /**
         * the ATTRIBUTEVALUE path.
         *
         * @return the path
         */
        public String ATTRIBUTEVALUE()
        {
            return buildPath(Fields.ATTRIBUTEVALUE);
        }
    }

    /** The dummy obj. */
    private static UserPreferences dummyObj=new UserPreferences();

    /**
     * Get UserPreferences Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<UserPreferences> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<UserPreferences> getDataSetInstance()
    {
        return new HibernateDataSet<UserPreferences>(UserPreferences.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            UserPreferences.getPKFieldListAsString(), UserPreferences.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("configId".equalsIgnoreCase(attributeName))
            return configId;
        if("userId".equalsIgnoreCase(attributeName))
            return userId;
        if("attributeKey".equalsIgnoreCase(attributeName))
            return attributeKey;
        if("attributeValue".equalsIgnoreCase(attributeName))
            return attributeValue;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("configId".equalsIgnoreCase(attributeName))
            configId =(String)attributeValue;
        if("userId".equalsIgnoreCase(attributeName))
            userId =(String)attributeValue;
        if("attributeKey".equalsIgnoreCase(attributeName))
            attributeKey =(String)attributeValue;
        if("attributeValue".equalsIgnoreCase(attributeName))
            attributeValue =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** configId private attribute */
    private String configId;

    /** userId private attribute */
    private String userId;

    /** attributeKey private attribute */
    private String attributeKey;

    /** attributeValue private attribute */
    private String attributeValue;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public UserPreferences() {
    }

	/** 
	 * minimal constructor
	 *
     * @param configId the configId
     * @param userId the userId
     * @param attributeKey the attributeKey
    }
	 */
    public UserPreferences(String configId, String userId, String attributeKey) {
        this.configId = configId;
        this.userId = userId;
        this.attributeKey = attributeKey;
    }

    /**
     * full constructor
	 *
     * @param configId the configId
     * @param userId the userId
     * @param attributeKey the attributeKey
     * @param attributeValue the attributeValue
     */
    public UserPreferences(String configId, String userId, String attributeKey, String attributeValue) {
        this.configId = configId;
        this.userId = userId;
        this.attributeKey = attributeKey;
        this.attributeValue = attributeValue;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return UserPreferences modified instance
     */
    public UserPreferences setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * configId getter method
     *
     * @return configId method
     */
    public String getConfigId() {
        return this.configId;
    }
    
    /**       
     * configId setter method
     *
     * @param configId the configId
     *
     * @return UserPreferences modified instance
     */
    public UserPreferences setConfigId(String configId) {
        this.configId = configId;
        
        return this;
    }
    /**       
     * userId getter method
     *
     * @return userId method
     */
    public String getUserId() {
        return this.userId;
    }
    
    /**       
     * userId setter method
     *
     * @param userId the userId
     *
     * @return UserPreferences modified instance
     */
    public UserPreferences setUserId(String userId) {
        this.userId = userId;
        
        return this;
    }
    /**       
     * attributeKey getter method
     *
     * @return attributeKey method
     */
    public String getAttributeKey() {
        return this.attributeKey;
    }
    
    /**       
     * attributeKey setter method
     *
     * @param attributeKey the attributeKey
     *
     * @return UserPreferences modified instance
     */
    public UserPreferences setAttributeKey(String attributeKey) {
        this.attributeKey = attributeKey;
        
        return this;
    }
    /**       
     * attributeValue getter method
     *
     * @return attributeValue method
     */
    public String getAttributeValue() {
        return this.attributeValue;
    }
    
    /**       
     * attributeValue setter method
     *
     * @param attributeValue the attributeValue
     *
     * @return UserPreferences modified instance
     */
    public UserPreferences setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
        
        return this;
    }


    /**
     * Creates a String representation of the UserPreferences object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("configId").append("='").append(getConfigId()).append("' ");			
        buffer.append("userId").append("='").append(getUserId()).append("' ");			
        buffer.append("attributeKey").append("='").append(getAttributeKey()).append("' ");			
        buffer.append("attributeValue").append("='").append(getAttributeValue()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the UserPreferences object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(UserPreferences other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("configId".equalsIgnoreCase(attributeName))
        	this.configId = attributeValue;

        if ("userId".equalsIgnoreCase(attributeName))
        	this.userId = attributeValue;

        if ("attributeKey".equalsIgnoreCase(attributeName))
        	this.attributeKey = attributeValue;

        if ("attributeValue".equalsIgnoreCase(attributeName))
        	this.attributeValue = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static UserPreferences getProxy(Session session, Long id)
    {
        return(UserPreferences)session.load(UserPreferences.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static UserPreferences getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        UserPreferences result = (UserPreferences)session.load(UserPreferences.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static UserPreferences getInstanceForSession(Session session, Long id)
    {
        return(UserPreferences)session.get(UserPreferences.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static UserPreferences getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        UserPreferences result = (UserPreferences)session.get(UserPreferences.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
