package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link UserPreferences}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class UserPreferencesFieldAttributes extends AbstractBeanAttributesDefinition{

    /** attributeKey (Database column: ATTRIBUTE_KEY - User Attribute Key) */
    static public AttributeDefinition attributeKey =
        new AttributeDefinition("attributeKey")
                .setDescription("User Attribute Key")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_PREFERENCES")
                .setDatabaseId("ATTRIBUTE_KEY")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /** attributeValue (Database column: ATTRIBUTE_VALUE - User Attribute Value) */
    static public AttributeDefinition attributeValue =
        new AttributeDefinition("attributeValue")
                .setDescription("User Attribute Value")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_PREFERENCES")
                .setDatabaseId("ATTRIBUTE_VALUE")
                .setMandatory(false)
                .setMaxSize(2000)
                .setType(String.class);

    /** configId (Database column: CONFIG_ID - Configuration ID (each application can have a diferent set of consents)) */
    static public AttributeDefinition configId =
        new AttributeDefinition("configId")
                .setDescription("Configuration ID (each application can have a diferent set of consents)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_PREFERENCES")
                .setDatabaseId("CONFIG_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_PREFERENCES")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** userId (Database column: USER_ID - User ID) */
    static public AttributeDefinition userId =
        new AttributeDefinition("userId")
                .setDescription("User ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_PREFERENCES")
                .setDatabaseId("USER_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(attributeKey.getName(),attributeKey);
        map.put(attributeValue.getName(),attributeValue);
        map.put(configId.getName(),configId);
        map.put(id.getName(),id);
        map.put(userId.getName(),userId);

        return map;
    }
}