package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link WorkflowActionListItem}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class WorkflowActionListItemFieldAttributes extends AbstractBeanAttributesDefinition{

    /** actionItemBusinessId (Database column: ACTION_ITEM_BUSINESS_ID) */
    static public AttributeDefinition actionItemBusinessId =
        new AttributeDefinition("actionItemBusinessId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_ACTION_LIST_ITEM")
                .setDatabaseId("ACTION_ITEM_BUSINESS_ID")
                .setMandatory(false)
                .setMaxSize(500)
                .setType(String.class);

    /** workflowActionList (Database column: ACTION_LIST_ID) */
    static public AttributeDefinition workflowActionList =
        new AttributeDefinition("workflowActionList")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_ACTION_LIST_ITEM")
                .setDatabaseId("ACTION_LIST_ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.WorkflowActionList.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.WorkflowActionList.class);

    /** actionType (Database column: ACTION_TYPE) */
    static public AttributeDefinition actionType =
        new AttributeDefinition("actionType")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_ACTION_LIST_ITEM")
                .setDatabaseId("ACTION_TYPE")
                .setMandatory(false)
                .setMaxSize(100)
                .setType(String.class);

    /** businessFlowActionId (Database column: BUSINESS_FLOW_ACTION_ID) */
    static public AttributeDefinition businessFlowActionId =
        new AttributeDefinition("businessFlowActionId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_ACTION_LIST_ITEM")
                .setDatabaseId("BUSINESS_FLOW_ACTION_ID")
                .setMandatory(false)
                .setMaxSize(1000)
                .setType(String.class);

    /** businessRuleExecutionId (Database column: BUSINESS_RULE_EXECUTION_ID) */
    static public AttributeDefinition businessRuleExecutionId =
        new AttributeDefinition("businessRuleExecutionId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_ACTION_LIST_ITEM")
                .setDatabaseId("BUSINESS_RULE_EXECUTION_ID")
                .setMandatory(false)
                .setMaxSize(1000)
                .setType(String.class);

    /** executionOrder (Database column: EXECUTION_ORDER) */
    static public AttributeDefinition executionOrder =
        new AttributeDefinition("executionOrder")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_ACTION_LIST_ITEM")
                .setDatabaseId("EXECUTION_ORDER")
                .setMandatory(true)
                .setMaxSize(22)
                .setType(Long.class);

    /** failActionListOnError (Database column: FAIL_ACTION_LIST_ON_ERROR) */
    static public AttributeDefinition failActionListOnError =
        new AttributeDefinition("failActionListOnError")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_ACTION_LIST_ITEM")
                .setDatabaseId("FAIL_ACTION_LIST_ON_ERROR")
                .setMandatory(false)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setDefaultValue("1")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_ACTION_LIST_ITEM")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setType(Long.class);

    /** workflowState (Database column: NEW_STATE_ID) */
    static public AttributeDefinition workflowState =
        new AttributeDefinition("workflowState")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_ACTION_LIST_ITEM")
                .setDatabaseId("NEW_STATE_ID")
                .setMandatory(false)
                .setMaxSize(22)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.WorkflowState.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.WorkflowState.class);

    /** parameters (Database column: PARAMETERS) */
    static public AttributeDefinition parameters =
        new AttributeDefinition("parameters")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_ACTION_LIST_ITEM")
                .setDatabaseId("PARAMETERS")
                .setMandatory(false)
                .setMaxSize(1000)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(actionItemBusinessId.getName(),actionItemBusinessId);
        map.put(workflowActionList.getName(),workflowActionList);
        map.put(actionType.getName(),actionType);
        map.put(businessFlowActionId.getName(),businessFlowActionId);
        map.put(businessRuleExecutionId.getName(),businessRuleExecutionId);
        map.put(executionOrder.getName(),executionOrder);
        map.put(failActionListOnError.getName(),failActionListOnError);
        map.put(id.getName(),id);
        map.put(workflowState.getName(),workflowState);
        map.put(parameters.getName(),parameters);

        return map;
    }
}