package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link Workflow}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class WorkflowFieldAttributes extends AbstractBeanAttributesDefinition{

    /** applicationId (Database column: APPLICATION_ID) */
    static public AttributeDefinition applicationId =
        new AttributeDefinition("applicationId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW")
                .setDatabaseId("APPLICATION_ID")
                .setMandatory(true)
                .setMaxSize(50)
                .setType(String.class);

    /** businessClassId (Database column: BUSINESS_CLASS_ID) */
    static public AttributeDefinition businessClassId =
        new AttributeDefinition("businessClassId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW")
                .setDatabaseId("BUSINESS_CLASS_ID")
                .setMandatory(false)
                .setMaxSize(500)
                .setType(String.class);

    /** businessVersion (Database column: BUSINESS_VERSION) */
    static public AttributeDefinition businessVersion =
        new AttributeDefinition("businessVersion")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW")
                .setDatabaseId("BUSINESS_VERSION")
                .setMandatory(false)
                .setMaxSize(5)
                .setType(Long.class);

    /** description (Database column: DESCRIPTION) */
    static public AttributeDefinition description =
        new AttributeDefinition("description")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW")
                .setDatabaseId("DESCRIPTION")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(String.class);

    /** fileBundle (Database column: FILE_BUNDLE_ID) */
    static public AttributeDefinition fileBundle =
        new AttributeDefinition("fileBundle")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW")
                .setDatabaseId("FILE_BUNDLE_ID")
                .setMandatory(false)
                .setMaxSize(22)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.FileBundle.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.FileBundle.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setType(Long.class);

    /** isActive (Database column: IS_ACTIVE) */
    static public AttributeDefinition isActive =
        new AttributeDefinition("isActive")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW")
                .setDatabaseId("IS_ACTIVE")
                .setMandatory(false)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setDefaultValue("0")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** isCustomized (Database column: IS_CUSTOMIZED) */
    static public AttributeDefinition isCustomized =
        new AttributeDefinition("isCustomized")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW")
                .setDatabaseId("IS_CUSTOMIZED")
                .setMandatory(false)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setDefaultValue("0")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** name (Database column: NAME) */
    static public AttributeDefinition name =
        new AttributeDefinition("name")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW")
                .setDatabaseId("NAME")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** version (Database column: VERSION) */
    static public AttributeDefinition version =
        new AttributeDefinition("version")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW")
                .setDatabaseId("VERSION")
                .setMandatory(false)
                .setMaxSize(5)
                .setType(Long.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return "name";
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(applicationId.getName(),applicationId);
        map.put(businessClassId.getName(),businessClassId);
        map.put(businessVersion.getName(),businessVersion);
        map.put(description.getName(),description);
        map.put(fileBundle.getName(),fileBundle);
        map.put(id.getName(),id);
        map.put(isActive.getName(),isActive);
        map.put(isCustomized.getName(),isCustomized);
        map.put(name.getName(),name);
        map.put(version.getName(),version);

        return map;
    }
}