package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * WorkflowFileAcl
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class WorkflowFileAcl extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<WorkflowFileAcl> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** WorkflowFileAcl attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** userId column */
        public static final String USERID ="userId";
        /** canUpload column */
        public static final String CANUPLOAD ="canUpload";
        /** canValidate column */
        public static final String CANVALIDATE ="canValidate";
        /** canInvalidate column */
        public static final String CANINVALIDATE ="canInvalidate";
        /** canViewValid column */
        public static final String CANVIEWVALID ="canViewValid";
        /** canViewNotValid column */
        public static final String CANVIEWNOTVALID ="canViewNotValid";
        /** canViewPrivate column */
        public static final String CANVIEWPRIVATE ="canViewPrivate";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("userId");
            list.add("canUpload");
            list.add("canValidate");
            list.add("canInvalidate");
            list.add("canViewValid");
            list.add("canViewNotValid");
            list.add("canViewPrivate");

            return list;
        }
    }

    /** Field attributes */
    public static WorkflowFileAclFieldAttributes FieldAttributes=new WorkflowFileAclFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public WorkflowFileAclFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * workflowUserProfile relation.
         *
         * @return the workflowUserProfile bean relations attributes.
         */
        public WorkflowUserProfile.Relations workflowUserProfile()
        {
            WorkflowUserProfile c = new WorkflowUserProfile();
            return c.new Relations(this.buildPath("workflowUserProfile"));
        }

        /**
         * workflowState relation.
         *
         * @return the workflowState bean relations attributes.
         */
        public WorkflowState.Relations workflowState()
        {
            WorkflowState c = new WorkflowState();
            return c.new Relations(this.buildPath("workflowState"));
        }

        /**
         * fileBundleFile relation.
         *
         * @return the fileBundleFile bean relations attributes.
         */
        public FileBundleFile.Relations fileBundleFile()
        {
            FileBundleFile c = new FileBundleFile();
            return c.new Relations(this.buildPath("fileBundleFile"));
        }

        /**
         * workflow relation.
         *
         * @return the workflow bean relations attributes.
         */
        public Workflow.Relations workflow()
        {
            Workflow c = new Workflow();
            return c.new Relations(this.buildPath("workflow"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the USERID path.
         *
         * @return the path
         */
        public String USERID()
        {
            return buildPath(Fields.USERID);
        }
        /**
         * the CANUPLOAD path.
         *
         * @return the path
         */
        public String CANUPLOAD()
        {
            return buildPath(Fields.CANUPLOAD);
        }
        /**
         * the CANVALIDATE path.
         *
         * @return the path
         */
        public String CANVALIDATE()
        {
            return buildPath(Fields.CANVALIDATE);
        }
        /**
         * the CANINVALIDATE path.
         *
         * @return the path
         */
        public String CANINVALIDATE()
        {
            return buildPath(Fields.CANINVALIDATE);
        }
        /**
         * the CANVIEWVALID path.
         *
         * @return the path
         */
        public String CANVIEWVALID()
        {
            return buildPath(Fields.CANVIEWVALID);
        }
        /**
         * the CANVIEWNOTVALID path.
         *
         * @return the path
         */
        public String CANVIEWNOTVALID()
        {
            return buildPath(Fields.CANVIEWNOTVALID);
        }
        /**
         * the CANVIEWPRIVATE path.
         *
         * @return the path
         */
        public String CANVIEWPRIVATE()
        {
            return buildPath(Fields.CANVIEWPRIVATE);
        }
    }

    /** The dummy obj. */
    private static WorkflowFileAcl dummyObj=new WorkflowFileAcl();

    /**
     * Get WorkflowFileAcl Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<WorkflowFileAcl> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<WorkflowFileAcl> getDataSetInstance()
    {
        return new HibernateDataSet<WorkflowFileAcl>(WorkflowFileAcl.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            WorkflowFileAcl.getPKFieldListAsString(), WorkflowFileAcl.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("workflowUserProfile".equalsIgnoreCase(attributeName))
            return workflowUserProfile;
        if("workflowState".equalsIgnoreCase(attributeName))
            return workflowState;
        if("fileBundleFile".equalsIgnoreCase(attributeName))
            return fileBundleFile;
        if("workflow".equalsIgnoreCase(attributeName))
            return workflow;
        if("userId".equalsIgnoreCase(attributeName))
            return userId;
        if("canUpload".equalsIgnoreCase(attributeName))
            return canUpload;
        if("canValidate".equalsIgnoreCase(attributeName))
            return canValidate;
        if("canInvalidate".equalsIgnoreCase(attributeName))
            return canInvalidate;
        if("canViewValid".equalsIgnoreCase(attributeName))
            return canViewValid;
        if("canViewNotValid".equalsIgnoreCase(attributeName))
            return canViewNotValid;
        if("canViewPrivate".equalsIgnoreCase(attributeName))
            return canViewPrivate;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("workflowUserProfile".equalsIgnoreCase(attributeName))
            workflowUserProfile =(WorkflowUserProfile)attributeValue;
        if("workflowState".equalsIgnoreCase(attributeName))
            workflowState =(WorkflowState)attributeValue;
        if("fileBundleFile".equalsIgnoreCase(attributeName))
            fileBundleFile =(FileBundleFile)attributeValue;
        if("workflow".equalsIgnoreCase(attributeName))
            workflow =(Workflow)attributeValue;
        if("userId".equalsIgnoreCase(attributeName))
            userId =(String)attributeValue;
        if("canUpload".equalsIgnoreCase(attributeName))
            canUpload =(Boolean)attributeValue;
        if("canValidate".equalsIgnoreCase(attributeName))
            canValidate =(Boolean)attributeValue;
        if("canInvalidate".equalsIgnoreCase(attributeName))
            canInvalidate =(Boolean)attributeValue;
        if("canViewValid".equalsIgnoreCase(attributeName))
            canViewValid =(Boolean)attributeValue;
        if("canViewNotValid".equalsIgnoreCase(attributeName))
            canViewNotValid =(Boolean)attributeValue;
        if("canViewPrivate".equalsIgnoreCase(attributeName))
            canViewPrivate =(Boolean)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** workflowUserProfile private attribute */
    private WorkflowUserProfile workflowUserProfile;

    /** workflowState private attribute */
    private WorkflowState workflowState;

    /** fileBundleFile private attribute */
    private FileBundleFile fileBundleFile;

    /** workflow private attribute */
    private Workflow workflow;

    /** userId private attribute */
    private String userId;

    /** canUpload private attribute */
    private boolean canUpload;

    /** canValidate private attribute */
    private boolean canValidate;

    /** canInvalidate private attribute */
    private boolean canInvalidate;

    /** canViewValid private attribute */
    private boolean canViewValid;

    /** canViewNotValid private attribute */
    private boolean canViewNotValid;

    /** canViewPrivate private attribute */
    private boolean canViewPrivate;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public WorkflowFileAcl() {
    }

	/** 
	 * minimal constructor
	 *
     * @param fileBundleFile the fileBundleFile
     * @param workflow the workflow
     * @param canUpload the canUpload
     * @param canValidate the canValidate
     * @param canInvalidate the canInvalidate
     * @param canViewValid the canViewValid
     * @param canViewNotValid the canViewNotValid
     * @param canViewPrivate the canViewPrivate
    }
	 */
    public WorkflowFileAcl(FileBundleFile fileBundleFile, Workflow workflow, boolean canUpload, boolean canValidate, boolean canInvalidate, boolean canViewValid, boolean canViewNotValid, boolean canViewPrivate) {
        this.fileBundleFile = fileBundleFile;
        this.workflow = workflow;
        this.canUpload = canUpload;
        this.canValidate = canValidate;
        this.canInvalidate = canInvalidate;
        this.canViewValid = canViewValid;
        this.canViewNotValid = canViewNotValid;
        this.canViewPrivate = canViewPrivate;
    }

    /**
     * full constructor
	 *
     * @param workflowUserProfile the workflowUserProfile
     * @param workflowState the workflowState
     * @param fileBundleFile the fileBundleFile
     * @param workflow the workflow
     * @param userId the userId
     * @param canUpload the canUpload
     * @param canValidate the canValidate
     * @param canInvalidate the canInvalidate
     * @param canViewValid the canViewValid
     * @param canViewNotValid the canViewNotValid
     * @param canViewPrivate the canViewPrivate
     */
    public WorkflowFileAcl(WorkflowUserProfile workflowUserProfile, WorkflowState workflowState, FileBundleFile fileBundleFile, Workflow workflow, String userId, boolean canUpload, boolean canValidate, boolean canInvalidate, boolean canViewValid, boolean canViewNotValid, boolean canViewPrivate) {
        this.workflowUserProfile = workflowUserProfile;
        this.workflowState = workflowState;
        this.fileBundleFile = fileBundleFile;
        this.workflow = workflow;
        this.userId = userId;
        this.canUpload = canUpload;
        this.canValidate = canValidate;
        this.canInvalidate = canInvalidate;
        this.canViewValid = canViewValid;
        this.canViewNotValid = canViewNotValid;
        this.canViewPrivate = canViewPrivate;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * workflowUserProfile getter method
     *
     * @return workflowUserProfile method
     */
    public WorkflowUserProfile getWorkflowUserProfile() {
        return this.workflowUserProfile;
    }
    
    /**       
     * workflowUserProfile setter method
     *
     * @param workflowUserProfile the workflowUserProfile
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setWorkflowUserProfile(WorkflowUserProfile workflowUserProfile) {
        this.workflowUserProfile = workflowUserProfile;
        
        return this;
    }
    /**       
     * workflowState getter method
     *
     * @return workflowState method
     */
    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }
    
    /**       
     * workflowState setter method
     *
     * @param workflowState the workflowState
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setWorkflowState(WorkflowState workflowState) {
        this.workflowState = workflowState;
        
        return this;
    }
    /**       
     * fileBundleFile getter method
     *
     * @return fileBundleFile method
     */
    public FileBundleFile getFileBundleFile() {
        return this.fileBundleFile;
    }
    
    /**       
     * fileBundleFile setter method
     *
     * @param fileBundleFile the fileBundleFile
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setFileBundleFile(FileBundleFile fileBundleFile) {
        this.fileBundleFile = fileBundleFile;
        
        return this;
    }
    /**       
     * workflow getter method
     *
     * @return workflow method
     */
    public Workflow getWorkflow() {
        return this.workflow;
    }
    
    /**       
     * workflow setter method
     *
     * @param workflow the workflow
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setWorkflow(Workflow workflow) {
        this.workflow = workflow;
        
        return this;
    }
    /**       
     * userId getter method
     *
     * @return userId method
     */
    public String getUserId() {
        return this.userId;
    }
    
    /**       
     * userId setter method
     *
     * @param userId the userId
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setUserId(String userId) {
        this.userId = userId;
        
        return this;
    }
    /**       
     * canUpload getter method
     *
     * @return canUpload method
     */
    public boolean isCanUpload() {
        return this.canUpload;
    }
    
    /**       
     * canUpload setter method
     *
     * @param canUpload the canUpload
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setCanUpload(boolean canUpload) {
        this.canUpload = canUpload;
        
        return this;
    }
    /**       
     * canValidate getter method
     *
     * @return canValidate method
     */
    public boolean isCanValidate() {
        return this.canValidate;
    }
    
    /**       
     * canValidate setter method
     *
     * @param canValidate the canValidate
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setCanValidate(boolean canValidate) {
        this.canValidate = canValidate;
        
        return this;
    }
    /**       
     * canInvalidate getter method
     *
     * @return canInvalidate method
     */
    public boolean isCanInvalidate() {
        return this.canInvalidate;
    }
    
    /**       
     * canInvalidate setter method
     *
     * @param canInvalidate the canInvalidate
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setCanInvalidate(boolean canInvalidate) {
        this.canInvalidate = canInvalidate;
        
        return this;
    }
    /**       
     * canViewValid getter method
     *
     * @return canViewValid method
     */
    public boolean isCanViewValid() {
        return this.canViewValid;
    }
    
    /**       
     * canViewValid setter method
     *
     * @param canViewValid the canViewValid
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setCanViewValid(boolean canViewValid) {
        this.canViewValid = canViewValid;
        
        return this;
    }
    /**       
     * canViewNotValid getter method
     *
     * @return canViewNotValid method
     */
    public boolean isCanViewNotValid() {
        return this.canViewNotValid;
    }
    
    /**       
     * canViewNotValid setter method
     *
     * @param canViewNotValid the canViewNotValid
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setCanViewNotValid(boolean canViewNotValid) {
        this.canViewNotValid = canViewNotValid;
        
        return this;
    }
    /**       
     * canViewPrivate getter method
     *
     * @return canViewPrivate method
     */
    public boolean isCanViewPrivate() {
        return this.canViewPrivate;
    }
    
    /**       
     * canViewPrivate setter method
     *
     * @param canViewPrivate the canViewPrivate
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setCanViewPrivate(boolean canViewPrivate) {
        this.canViewPrivate = canViewPrivate;
        
        return this;
    }

    /**
     * workflowUserProfile id getter method
     *
     * @return workflowUserProfile id method
     */
    public Long getWorkflowUserProfileId() {
        if (this.workflowUserProfile == null)
            return null;
        else
            return this.workflowUserProfile.getId();
    }

    /**
     * WorkflowUserProfile proxy setter method from id.
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setWorkflowUserProfileProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflowUserProfile = null;
        else
            this.workflowUserProfile = WorkflowUserProfile.getProxy(id);

        return this;
    }

    /**
     * WorkflowUserProfile instance setter method from id.
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setWorkflowUserProfileInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflowUserProfile = null;
        else
            this.workflowUserProfile = WorkflowUserProfile.getInstance(id);

        return this;
    }
    /**
     * workflowState id getter method
     *
     * @return workflowState id method
     */
    public Long getWorkflowStateId() {
        if (this.workflowState == null)
            return null;
        else
            return this.workflowState.getId();
    }

    /**
     * WorkflowState proxy setter method from id.
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setWorkflowStateProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflowState = null;
        else
            this.workflowState = WorkflowState.getProxy(id);

        return this;
    }

    /**
     * WorkflowState instance setter method from id.
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setWorkflowStateInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflowState = null;
        else
            this.workflowState = WorkflowState.getInstance(id);

        return this;
    }
    /**
     * fileBundleFile id getter method
     *
     * @return fileBundleFile id method
     */
    public Long getFileBundleFileId() {
        if (this.fileBundleFile == null)
            return null;
        else
            return this.fileBundleFile.getId();
    }

    /**
     * FileBundleFile proxy setter method from id.
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setFileBundleFileProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.fileBundleFile = null;
        else
            this.fileBundleFile = FileBundleFile.getProxy(id);

        return this;
    }

    /**
     * FileBundleFile instance setter method from id.
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setFileBundleFileInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.fileBundleFile = null;
        else
            this.fileBundleFile = FileBundleFile.getInstance(id);

        return this;
    }
    /**
     * workflow id getter method
     *
     * @return workflow id method
     */
    public Long getWorkflowId() {
        if (this.workflow == null)
            return null;
        else
            return this.workflow.getId();
    }

    /**
     * Workflow proxy setter method from id.
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setWorkflowProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflow = null;
        else
            this.workflow = Workflow.getProxy(id);

        return this;
    }

    /**
     * Workflow instance setter method from id.
     *
     * @return WorkflowFileAcl modified instance
     */
    public WorkflowFileAcl setWorkflowInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflow = null;
        else
            this.workflow = Workflow.getInstance(id);

        return this;
    }

    /**
     * Creates a String representation of the WorkflowFileAcl object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("userId").append("='").append(getUserId()).append("' ");			
        buffer.append("canUpload").append("='").append(isCanUpload()).append("' ");			
        buffer.append("canValidate").append("='").append(isCanValidate()).append("' ");			
        buffer.append("canInvalidate").append("='").append(isCanInvalidate()).append("' ");			
        buffer.append("canViewValid").append("='").append(isCanViewValid()).append("' ");			
        buffer.append("canViewNotValid").append("='").append(isCanViewNotValid()).append("' ");			
        buffer.append("canViewPrivate").append("='").append(isCanViewPrivate()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the WorkflowFileAcl object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(WorkflowFileAcl other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("userId".equalsIgnoreCase(attributeName))
        	this.userId = attributeValue;

        if ("canUpload".equalsIgnoreCase(attributeName))
            this.canUpload = Boolean.valueOf(attributeValue);

        if ("canValidate".equalsIgnoreCase(attributeName))
            this.canValidate = Boolean.valueOf(attributeValue);

        if ("canInvalidate".equalsIgnoreCase(attributeName))
            this.canInvalidate = Boolean.valueOf(attributeValue);

        if ("canViewValid".equalsIgnoreCase(attributeName))
            this.canViewValid = Boolean.valueOf(attributeValue);

        if ("canViewNotValid".equalsIgnoreCase(attributeName))
            this.canViewNotValid = Boolean.valueOf(attributeValue);

        if ("canViewPrivate".equalsIgnoreCase(attributeName))
            this.canViewPrivate = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static WorkflowFileAcl getProxy(Session session, Long id)
    {
        return(WorkflowFileAcl)session.load(WorkflowFileAcl.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static WorkflowFileAcl getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowFileAcl result = (WorkflowFileAcl)session.load(WorkflowFileAcl.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static WorkflowFileAcl getInstanceForSession(Session session, Long id)
    {
        return(WorkflowFileAcl)session.get(WorkflowFileAcl.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static WorkflowFileAcl getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowFileAcl result = (WorkflowFileAcl)session.get(WorkflowFileAcl.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
