package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link WorkflowInstance}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class WorkflowInstanceFieldAttributes extends AbstractBeanAttributesDefinition{

    /** businessId (Database column: BUSINESS_ID) */
    static public AttributeDefinition businessId =
        new AttributeDefinition("businessId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_INSTANCE")
                .setDatabaseId("BUSINESS_ID")
                .setMandatory(true)
                .setMaxSize(1000)
                .setType(String.class);

    /** conversation (Database column: CONVERSATION_ID) */
    static public AttributeDefinition conversation =
        new AttributeDefinition("conversation")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_INSTANCE")
                .setDatabaseId("CONVERSATION_ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Conversation.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("description")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Conversation.class);

    /** creatorUserId (Database column: CREATOR_USER_ID) */
    static public AttributeDefinition creatorUserId =
        new AttributeDefinition("creatorUserId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_INSTANCE")
                .setDatabaseId("CREATOR_USER_ID")
                .setMandatory(false)
                .setMaxSize(1000)
                .setType(String.class);

    /** currentOwnerUserId (Database column: CURRENT_OWNER_USER_ID) */
    static public AttributeDefinition currentOwnerUserId =
        new AttributeDefinition("currentOwnerUserId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_INSTANCE")
                .setDatabaseId("CURRENT_OWNER_USER_ID")
                .setMandatory(false)
                .setMaxSize(1000)
                .setType(String.class);

    /** fileBundleInstance (Database column: FILE_BUNDLE_INSTANCE_ID) */
    static public AttributeDefinition fileBundleInstance =
        new AttributeDefinition("fileBundleInstance")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_INSTANCE")
                .setDatabaseId("FILE_BUNDLE_INSTANCE_ID")
                .setMandatory(false)
                .setMaxSize(22)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.FileBundleInstance.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("businessProcessInstanceId")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.FileBundleInstance.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_INSTANCE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setType(Long.class);

    /** workflowState (Database column: STATE_ID) */
    static public AttributeDefinition workflowState =
        new AttributeDefinition("workflowState")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_INSTANCE")
                .setDatabaseId("STATE_ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.WorkflowState.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.WorkflowState.class);

    /** workflow (Database column: WORKFLOW_ID) */
    static public AttributeDefinition workflow =
        new AttributeDefinition("workflow")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_INSTANCE")
                .setDatabaseId("WORKFLOW_ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Workflow.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Workflow.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(businessId.getName(),businessId);
        map.put(conversation.getName(),conversation);
        map.put(creatorUserId.getName(),creatorUserId);
        map.put(currentOwnerUserId.getName(),currentOwnerUserId);
        map.put(fileBundleInstance.getName(),fileBundleInstance);
        map.put(id.getName(),id);
        map.put(workflowState.getName(),workflowState);
        map.put(workflow.getName(),workflow);

        return map;
    }
}