package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * WorkflowState
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class WorkflowState extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<WorkflowState> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** WorkflowState attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** name column */
        public static final String NAME ="name";
        /** keyword column */
        public static final String KEYWORD ="keyword";
        /** iconImagePath column */
        public static final String ICONIMAGEPATH ="iconImagePath";
        /** description column */
        public static final String DESCRIPTION ="description";
        /** stateBusinessId column */
        public static final String STATEBUSINESSID ="stateBusinessId";
        /** isInitial column */
        public static final String ISINITIAL ="isInitial";
        /** isFinal column */
        public static final String ISFINAL ="isFinal";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");
            list.add("keyword");
            list.add("iconImagePath");
            list.add("description");
            list.add("stateBusinessId");
            list.add("isInitial");
            list.add("isFinal");

            return list;
        }
    }

    /** Field attributes */
    public static WorkflowStateFieldAttributes FieldAttributes=new WorkflowStateFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public WorkflowStateFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * workflowActionListByOnEnterActionListId relation.
         *
         * @return the workflowActionListByOnEnterActionListId bean relations attributes.
         */
        public WorkflowActionList.Relations workflowActionListByOnEnterActionListId()
        {
            WorkflowActionList c = new WorkflowActionList();
            return c.new Relations(this.buildPath("workflowActionListByOnEnterActionListId"));
        }

        /**
         * workflowActionListByOnExitActionListId relation.
         *
         * @return the workflowActionListByOnExitActionListId bean relations attributes.
         */
        public WorkflowActionList.Relations workflowActionListByOnExitActionListId()
        {
            WorkflowActionList c = new WorkflowActionList();
            return c.new Relations(this.buildPath("workflowActionListByOnExitActionListId"));
        }

        /**
         * workflow relation.
         *
         * @return the workflow bean relations attributes.
         */
        public Workflow.Relations workflow()
        {
            Workflow c = new Workflow();
            return c.new Relations(this.buildPath("workflow"));
        }

        /**
         * workflowCustomFormConfigs relation.
         *
         * @return the workflowCustomFormConfigs bean relations attributes.
         */
        public WorkflowCustomFormConfig.Relations workflowCustomFormConfigs()
        {
            WorkflowCustomFormConfig c = new WorkflowCustomFormConfig();
            return c.new Relations(this.buildPath("workflowCustomFormConfigs"));
        }

        /**
         * workflowStateActions relation.
         *
         * @return the workflowStateActions bean relations attributes.
         */
        public WorkflowStateAction.Relations workflowStateActions()
        {
            WorkflowStateAction c = new WorkflowStateAction();
            return c.new Relations(this.buildPath("workflowStateActions"));
        }

        /**
         * workflowInstances relation.
         *
         * @return the workflowInstances bean relations attributes.
         */
        public WorkflowInstance.Relations workflowInstances()
        {
            WorkflowInstance c = new WorkflowInstance();
            return c.new Relations(this.buildPath("workflowInstances"));
        }

        /**
         * workflowActionListItems relation.
         *
         * @return the workflowActionListItems bean relations attributes.
         */
        public WorkflowActionListItem.Relations workflowActionListItems()
        {
            WorkflowActionListItem c = new WorkflowActionListItem();
            return c.new Relations(this.buildPath("workflowActionListItems"));
        }

        /**
         * workflowFileAcls relation.
         *
         * @return the workflowFileAcls bean relations attributes.
         */
        public WorkflowFileAcl.Relations workflowFileAcls()
        {
            WorkflowFileAcl c = new WorkflowFileAcl();
            return c.new Relations(this.buildPath("workflowFileAcls"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
        /**
         * the KEYWORD path.
         *
         * @return the path
         */
        public String KEYWORD()
        {
            return buildPath(Fields.KEYWORD);
        }
        /**
         * the ICONIMAGEPATH path.
         *
         * @return the path
         */
        public String ICONIMAGEPATH()
        {
            return buildPath(Fields.ICONIMAGEPATH);
        }
        /**
         * the DESCRIPTION path.
         *
         * @return the path
         */
        public String DESCRIPTION()
        {
            return buildPath(Fields.DESCRIPTION);
        }
        /**
         * the STATEBUSINESSID path.
         *
         * @return the path
         */
        public String STATEBUSINESSID()
        {
            return buildPath(Fields.STATEBUSINESSID);
        }
        /**
         * the ISINITIAL path.
         *
         * @return the path
         */
        public String ISINITIAL()
        {
            return buildPath(Fields.ISINITIAL);
        }
        /**
         * the ISFINAL path.
         *
         * @return the path
         */
        public String ISFINAL()
        {
            return buildPath(Fields.ISFINAL);
        }
    }

    /** The dummy obj. */
    private static WorkflowState dummyObj=new WorkflowState();

    /**
     * Get WorkflowState Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<WorkflowState> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<WorkflowState> getDataSetInstance()
    {
        return new HibernateDataSet<WorkflowState>(WorkflowState.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            WorkflowState.getPKFieldListAsString(), WorkflowState.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("workflowActionListByOnEnterActionListId".equalsIgnoreCase(attributeName))
            return workflowActionListByOnEnterActionListId;
        if("workflowActionListByOnExitActionListId".equalsIgnoreCase(attributeName))
            return workflowActionListByOnExitActionListId;
        if("workflow".equalsIgnoreCase(attributeName))
            return workflow;
        if("name".equalsIgnoreCase(attributeName))
            return name;
        if("keyword".equalsIgnoreCase(attributeName))
            return keyword;
        if("iconImagePath".equalsIgnoreCase(attributeName))
            return iconImagePath;
        if("description".equalsIgnoreCase(attributeName))
            return description;
        if("stateBusinessId".equalsIgnoreCase(attributeName))
            return stateBusinessId;
        if("isInitial".equalsIgnoreCase(attributeName))
            return isInitial;
        if("isFinal".equalsIgnoreCase(attributeName))
            return isFinal;
        if("workflowCustomFormConfigs".equalsIgnoreCase(attributeName))
            return workflowCustomFormConfigs;
        if("workflowStateActions".equalsIgnoreCase(attributeName))
            return workflowStateActions;
        if("workflowInstances".equalsIgnoreCase(attributeName))
            return workflowInstances;
        if("workflowActionListItems".equalsIgnoreCase(attributeName))
            return workflowActionListItems;
        if("workflowFileAcls".equalsIgnoreCase(attributeName))
            return workflowFileAcls;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("workflowActionListByOnEnterActionListId".equalsIgnoreCase(attributeName))
            workflowActionListByOnEnterActionListId =(WorkflowActionList)attributeValue;
        if("workflowActionListByOnExitActionListId".equalsIgnoreCase(attributeName))
            workflowActionListByOnExitActionListId =(WorkflowActionList)attributeValue;
        if("workflow".equalsIgnoreCase(attributeName))
            workflow =(Workflow)attributeValue;
        if("name".equalsIgnoreCase(attributeName))
            name =(String)attributeValue;
        if("keyword".equalsIgnoreCase(attributeName))
            keyword =(String)attributeValue;
        if("iconImagePath".equalsIgnoreCase(attributeName))
            iconImagePath =(String)attributeValue;
        if("description".equalsIgnoreCase(attributeName))
            description =(String)attributeValue;
        if("stateBusinessId".equalsIgnoreCase(attributeName))
            stateBusinessId =(String)attributeValue;
        if("isInitial".equalsIgnoreCase(attributeName))
            isInitial =(Boolean)attributeValue;
        if("isFinal".equalsIgnoreCase(attributeName))
            isFinal =(Boolean)attributeValue;
        if("workflowCustomFormConfigs".equalsIgnoreCase(attributeName))
            workflowCustomFormConfigs =(Set<WorkflowCustomFormConfig>)attributeValue;
        if("workflowStateActions".equalsIgnoreCase(attributeName))
            workflowStateActions =(Set<WorkflowStateAction>)attributeValue;
        if("workflowInstances".equalsIgnoreCase(attributeName))
            workflowInstances =(Set<WorkflowInstance>)attributeValue;
        if("workflowActionListItems".equalsIgnoreCase(attributeName))
            workflowActionListItems =(Set<WorkflowActionListItem>)attributeValue;
        if("workflowFileAcls".equalsIgnoreCase(attributeName))
            workflowFileAcls =(Set<WorkflowFileAcl>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** workflowActionListByOnEnterActionListId private attribute */
    private WorkflowActionList workflowActionListByOnEnterActionListId;

    /** workflowActionListByOnExitActionListId private attribute */
    private WorkflowActionList workflowActionListByOnExitActionListId;

    /** workflow private attribute */
    private Workflow workflow;

    /** name private attribute */
    private String name;

    /** keyword private attribute */
    private String keyword;

    /** iconImagePath private attribute */
    private String iconImagePath;

    /** description private attribute */
    private String description;

    /** stateBusinessId private attribute */
    private String stateBusinessId;

    /** isInitial private attribute */
    private boolean isInitial;

    /** isFinal private attribute */
    private boolean isFinal;

    /** workflowCustomFormConfigs private attribute */
    private Set<WorkflowCustomFormConfig> workflowCustomFormConfigs = new HashSet<WorkflowCustomFormConfig>(0);

    /** workflowStateActions private attribute */
    private Set<WorkflowStateAction> workflowStateActions = new HashSet<WorkflowStateAction>(0);

    /** workflowInstances private attribute */
    private Set<WorkflowInstance> workflowInstances = new HashSet<WorkflowInstance>(0);

    /** workflowActionListItems private attribute */
    private Set<WorkflowActionListItem> workflowActionListItems = new HashSet<WorkflowActionListItem>(0);

    /** workflowFileAcls private attribute */
    private Set<WorkflowFileAcl> workflowFileAcls = new HashSet<WorkflowFileAcl>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public WorkflowState() {
    }

	/** 
	 * minimal constructor
	 *
     * @param workflow the workflow
     * @param name the name
     * @param keyword the keyword
     * @param isInitial the isInitial
    }
	 */
    public WorkflowState(Workflow workflow, String name, String keyword, boolean isInitial) {
        this.workflow = workflow;
        this.name = name;
        this.keyword = keyword;
        this.isInitial = isInitial;
    }

    /**
     * full constructor
	 *
     * @param workflowActionListByOnEnterActionListId the workflowActionListByOnEnterActionListId
     * @param workflowActionListByOnExitActionListId the workflowActionListByOnExitActionListId
     * @param workflow the workflow
     * @param name the name
     * @param keyword the keyword
     * @param iconImagePath the iconImagePath
     * @param description the description
     * @param stateBusinessId the stateBusinessId
     * @param isInitial the isInitial
     * @param isFinal the isFinal
     * @param workflowCustomFormConfigs the workflowCustomFormConfigs
     * @param workflowStateActions the workflowStateActions
     * @param workflowInstances the workflowInstances
     * @param workflowActionListItems the workflowActionListItems
     * @param workflowFileAcls the workflowFileAcls
     */
    public WorkflowState(WorkflowActionList workflowActionListByOnEnterActionListId, WorkflowActionList workflowActionListByOnExitActionListId, Workflow workflow, String name, String keyword, String iconImagePath, String description, String stateBusinessId, boolean isInitial, boolean isFinal, Set<WorkflowCustomFormConfig> workflowCustomFormConfigs, Set<WorkflowStateAction> workflowStateActions, Set<WorkflowInstance> workflowInstances, Set<WorkflowActionListItem> workflowActionListItems, Set<WorkflowFileAcl> workflowFileAcls) {
        this.workflowActionListByOnEnterActionListId = workflowActionListByOnEnterActionListId;
        this.workflowActionListByOnExitActionListId = workflowActionListByOnExitActionListId;
        this.workflow = workflow;
        this.name = name;
        this.keyword = keyword;
        this.iconImagePath = iconImagePath;
        this.description = description;
        this.stateBusinessId = stateBusinessId;
        this.isInitial = isInitial;
        this.isFinal = isFinal;
        this.workflowCustomFormConfigs = workflowCustomFormConfigs;
        this.workflowStateActions = workflowStateActions;
        this.workflowInstances = workflowInstances;
        this.workflowActionListItems = workflowActionListItems;
        this.workflowFileAcls = workflowFileAcls;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * workflowActionListByOnEnterActionListId getter method
     *
     * @return workflowActionListByOnEnterActionListId method
     */
    public WorkflowActionList getWorkflowActionListByOnEnterActionListId() {
        return this.workflowActionListByOnEnterActionListId;
    }
    
    /**       
     * workflowActionListByOnEnterActionListId setter method
     *
     * @param workflowActionListByOnEnterActionListId the workflowActionListByOnEnterActionListId
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setWorkflowActionListByOnEnterActionListId(WorkflowActionList workflowActionListByOnEnterActionListId) {
        this.workflowActionListByOnEnterActionListId = workflowActionListByOnEnterActionListId;
        
        return this;
    }
    /**       
     * workflowActionListByOnExitActionListId getter method
     *
     * @return workflowActionListByOnExitActionListId method
     */
    public WorkflowActionList getWorkflowActionListByOnExitActionListId() {
        return this.workflowActionListByOnExitActionListId;
    }
    
    /**       
     * workflowActionListByOnExitActionListId setter method
     *
     * @param workflowActionListByOnExitActionListId the workflowActionListByOnExitActionListId
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setWorkflowActionListByOnExitActionListId(WorkflowActionList workflowActionListByOnExitActionListId) {
        this.workflowActionListByOnExitActionListId = workflowActionListByOnExitActionListId;
        
        return this;
    }
    /**       
     * workflow getter method
     *
     * @return workflow method
     */
    public Workflow getWorkflow() {
        return this.workflow;
    }
    
    /**       
     * workflow setter method
     *
     * @param workflow the workflow
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setWorkflow(Workflow workflow) {
        this.workflow = workflow;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name the name
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * keyword getter method
     *
     * @return keyword method
     */
    public String getKeyword() {
        return this.keyword;
    }
    
    /**       
     * keyword setter method
     *
     * @param keyword the keyword
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setKeyword(String keyword) {
        this.keyword = keyword;
        
        return this;
    }
    /**       
     * iconImagePath getter method
     *
     * @return iconImagePath method
     */
    public String getIconImagePath() {
        return this.iconImagePath;
    }
    
    /**       
     * iconImagePath setter method
     *
     * @param iconImagePath the iconImagePath
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setIconImagePath(String iconImagePath) {
        this.iconImagePath = iconImagePath;
        
        return this;
    }
    /**       
     * description getter method
     *
     * @return description method
     */
    public String getDescription() {
        return this.description;
    }
    
    /**       
     * description setter method
     *
     * @param description the description
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setDescription(String description) {
        this.description = description;
        
        return this;
    }
    /**       
     * stateBusinessId getter method
     *
     * @return stateBusinessId method
     */
    public String getStateBusinessId() {
        return this.stateBusinessId;
    }
    
    /**       
     * stateBusinessId setter method
     *
     * @param stateBusinessId the stateBusinessId
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setStateBusinessId(String stateBusinessId) {
        this.stateBusinessId = stateBusinessId;
        
        return this;
    }
    /**       
     * isInitial getter method
     *
     * @return isInitial method
     */
    public boolean isIsInitial() {
        return this.isInitial;
    }
    
    /**       
     * isInitial setter method
     *
     * @param isInitial the isInitial
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setIsInitial(boolean isInitial) {
        this.isInitial = isInitial;
        
        return this;
    }
    /**       
     * isFinal getter method
     *
     * @return isFinal method
     */
    public boolean isIsFinal() {
        return this.isFinal;
    }
    
    /**       
     * isFinal setter method
     *
     * @param isFinal the isFinal
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setIsFinal(boolean isFinal) {
        this.isFinal = isFinal;
        
        return this;
    }
    /**       
     * workflowCustomFormConfigs getter method
     *
     * @return workflowCustomFormConfigs method
     */
    public Set<WorkflowCustomFormConfig> getWorkflowCustomFormConfigs() {
        return this.workflowCustomFormConfigs;
    }
    
    /**       
     * workflowCustomFormConfigs setter method
     *
     * @param workflowCustomFormConfigs the workflowCustomFormConfigs
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setWorkflowCustomFormConfigs(Set<WorkflowCustomFormConfig> workflowCustomFormConfigs) {
        this.workflowCustomFormConfigs = workflowCustomFormConfigs;
        
        return this;
    }
    /**       
     * workflowStateActions getter method
     *
     * @return workflowStateActions method
     */
    public Set<WorkflowStateAction> getWorkflowStateActions() {
        return this.workflowStateActions;
    }
    
    /**       
     * workflowStateActions setter method
     *
     * @param workflowStateActions the workflowStateActions
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setWorkflowStateActions(Set<WorkflowStateAction> workflowStateActions) {
        this.workflowStateActions = workflowStateActions;
        
        return this;
    }
    /**       
     * workflowInstances getter method
     *
     * @return workflowInstances method
     */
    public Set<WorkflowInstance> getWorkflowInstances() {
        return this.workflowInstances;
    }
    
    /**       
     * workflowInstances setter method
     *
     * @param workflowInstances the workflowInstances
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setWorkflowInstances(Set<WorkflowInstance> workflowInstances) {
        this.workflowInstances = workflowInstances;
        
        return this;
    }
    /**       
     * workflowActionListItems getter method
     *
     * @return workflowActionListItems method
     */
    public Set<WorkflowActionListItem> getWorkflowActionListItems() {
        return this.workflowActionListItems;
    }
    
    /**       
     * workflowActionListItems setter method
     *
     * @param workflowActionListItems the workflowActionListItems
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setWorkflowActionListItems(Set<WorkflowActionListItem> workflowActionListItems) {
        this.workflowActionListItems = workflowActionListItems;
        
        return this;
    }
    /**       
     * workflowFileAcls getter method
     *
     * @return workflowFileAcls method
     */
    public Set<WorkflowFileAcl> getWorkflowFileAcls() {
        return this.workflowFileAcls;
    }
    
    /**       
     * workflowFileAcls setter method
     *
     * @param workflowFileAcls the workflowFileAcls
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setWorkflowFileAcls(Set<WorkflowFileAcl> workflowFileAcls) {
        this.workflowFileAcls = workflowFileAcls;
        
        return this;
    }

    /**
     * workflowActionListByOnEnterActionListId id getter method
     *
     * @return workflowActionListByOnEnterActionListId id method
     */
    public Long getWorkflowActionListByOnEnterActionListIdId() {
        if (this.workflowActionListByOnEnterActionListId == null)
            return null;
        else
            return this.workflowActionListByOnEnterActionListId.getId();
    }

    /**
     * WorkflowActionList proxy setter method from id.
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setWorkflowActionListByOnEnterActionListIdProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflowActionListByOnEnterActionListId = null;
        else
            this.workflowActionListByOnEnterActionListId = WorkflowActionList.getProxy(id);

        return this;
    }

    /**
     * WorkflowActionList instance setter method from id.
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setWorkflowActionListByOnEnterActionListIdInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflowActionListByOnEnterActionListId = null;
        else
            this.workflowActionListByOnEnterActionListId = WorkflowActionList.getInstance(id);

        return this;
    }
    /**
     * workflowActionListByOnExitActionListId id getter method
     *
     * @return workflowActionListByOnExitActionListId id method
     */
    public Long getWorkflowActionListByOnExitActionListIdId() {
        if (this.workflowActionListByOnExitActionListId == null)
            return null;
        else
            return this.workflowActionListByOnExitActionListId.getId();
    }

    /**
     * WorkflowActionList proxy setter method from id.
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setWorkflowActionListByOnExitActionListIdProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflowActionListByOnExitActionListId = null;
        else
            this.workflowActionListByOnExitActionListId = WorkflowActionList.getProxy(id);

        return this;
    }

    /**
     * WorkflowActionList instance setter method from id.
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setWorkflowActionListByOnExitActionListIdInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflowActionListByOnExitActionListId = null;
        else
            this.workflowActionListByOnExitActionListId = WorkflowActionList.getInstance(id);

        return this;
    }
    /**
     * workflow id getter method
     *
     * @return workflow id method
     */
    public Long getWorkflowId() {
        if (this.workflow == null)
            return null;
        else
            return this.workflow.getId();
    }

    /**
     * Workflow proxy setter method from id.
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setWorkflowProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflow = null;
        else
            this.workflow = Workflow.getProxy(id);

        return this;
    }

    /**
     * Workflow instance setter method from id.
     *
     * @return WorkflowState modified instance
     */
    public WorkflowState setWorkflowInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflow = null;
        else
            this.workflow = Workflow.getInstance(id);

        return this;
    }

    /**
     * Creates a String representation of the WorkflowState object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("keyword").append("='").append(getKeyword()).append("' ");			
        buffer.append("iconImagePath").append("='").append(getIconImagePath()).append("' ");			
        buffer.append("description").append("='").append(getDescription()).append("' ");			
        buffer.append("stateBusinessId").append("='").append(getStateBusinessId()).append("' ");			
        buffer.append("isInitial").append("='").append(isIsInitial()).append("' ");			
        buffer.append("isFinal").append("='").append(isIsFinal()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the WorkflowState object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(WorkflowState other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("keyword".equalsIgnoreCase(attributeName))
        	this.keyword = attributeValue;

        if ("iconImagePath".equalsIgnoreCase(attributeName))
        	this.iconImagePath = attributeValue;

        if ("description".equalsIgnoreCase(attributeName))
        	this.description = attributeValue;

        if ("stateBusinessId".equalsIgnoreCase(attributeName))
        	this.stateBusinessId = attributeValue;

        if ("isInitial".equalsIgnoreCase(attributeName))
            this.isInitial = Boolean.valueOf(attributeValue);

        if ("isFinal".equalsIgnoreCase(attributeName))
            this.isFinal = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static WorkflowState getProxy(Session session, Long id)
    {
        return(WorkflowState)session.load(WorkflowState.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static WorkflowState getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowState result = (WorkflowState)session.load(WorkflowState.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static WorkflowState getInstanceForSession(Session session, Long id)
    {
        return(WorkflowState)session.get(WorkflowState.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static WorkflowState getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowState result = (WorkflowState)session.get(WorkflowState.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
