package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * WorkflowStateAction
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class WorkflowStateAction extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<WorkflowStateAction> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** WorkflowStateAction attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** name column */
        public static final String NAME ="name";
        /** description column */
        public static final String DESCRIPTION ="description";
        /** iconImagePath column */
        public static final String ICONIMAGEPATH ="iconImagePath";
        /** actionBusinessId column */
        public static final String ACTIONBUSINESSID ="actionBusinessId";
        /** businessRuleConditionId column */
        public static final String BUSINESSRULECONDITIONID ="businessRuleConditionId";
        /** mustComment column */
        public static final String MUSTCOMMENT ="mustComment";
        /** showIfConditionFails column */
        public static final String SHOWIFCONDITIONFAILS ="showIfConditionFails";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");
            list.add("description");
            list.add("iconImagePath");
            list.add("actionBusinessId");
            list.add("businessRuleConditionId");
            list.add("mustComment");
            list.add("showIfConditionFails");

            return list;
        }
    }

    /** Field attributes */
    public static WorkflowStateActionFieldAttributes FieldAttributes=new WorkflowStateActionFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public WorkflowStateActionFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * workflowState relation.
         *
         * @return the workflowState bean relations attributes.
         */
        public WorkflowState.Relations workflowState()
        {
            WorkflowState c = new WorkflowState();
            return c.new Relations(this.buildPath("workflowState"));
        }

        /**
         * workflowActionList relation.
         *
         * @return the workflowActionList bean relations attributes.
         */
        public WorkflowActionList.Relations workflowActionList()
        {
            WorkflowActionList c = new WorkflowActionList();
            return c.new Relations(this.buildPath("workflowActionList"));
        }

        /**
         * workflowStateActionAcls relation.
         *
         * @return the workflowStateActionAcls bean relations attributes.
         */
        public WorkflowStateActionAcl.Relations workflowStateActionAcls()
        {
            WorkflowStateActionAcl c = new WorkflowStateActionAcl();
            return c.new Relations(this.buildPath("workflowStateActionAcls"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
        /**
         * the DESCRIPTION path.
         *
         * @return the path
         */
        public String DESCRIPTION()
        {
            return buildPath(Fields.DESCRIPTION);
        }
        /**
         * the ICONIMAGEPATH path.
         *
         * @return the path
         */
        public String ICONIMAGEPATH()
        {
            return buildPath(Fields.ICONIMAGEPATH);
        }
        /**
         * the ACTIONBUSINESSID path.
         *
         * @return the path
         */
        public String ACTIONBUSINESSID()
        {
            return buildPath(Fields.ACTIONBUSINESSID);
        }
        /**
         * the BUSINESSRULECONDITIONID path.
         *
         * @return the path
         */
        public String BUSINESSRULECONDITIONID()
        {
            return buildPath(Fields.BUSINESSRULECONDITIONID);
        }
        /**
         * the MUSTCOMMENT path.
         *
         * @return the path
         */
        public String MUSTCOMMENT()
        {
            return buildPath(Fields.MUSTCOMMENT);
        }
        /**
         * the SHOWIFCONDITIONFAILS path.
         *
         * @return the path
         */
        public String SHOWIFCONDITIONFAILS()
        {
            return buildPath(Fields.SHOWIFCONDITIONFAILS);
        }
    }

    /** The dummy obj. */
    private static WorkflowStateAction dummyObj=new WorkflowStateAction();

    /**
     * Get WorkflowStateAction Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<WorkflowStateAction> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<WorkflowStateAction> getDataSetInstance()
    {
        return new HibernateDataSet<WorkflowStateAction>(WorkflowStateAction.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            WorkflowStateAction.getPKFieldListAsString(), WorkflowStateAction.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("workflowState".equalsIgnoreCase(attributeName))
            return workflowState;
        if("workflowActionList".equalsIgnoreCase(attributeName))
            return workflowActionList;
        if("name".equalsIgnoreCase(attributeName))
            return name;
        if("description".equalsIgnoreCase(attributeName))
            return description;
        if("iconImagePath".equalsIgnoreCase(attributeName))
            return iconImagePath;
        if("actionBusinessId".equalsIgnoreCase(attributeName))
            return actionBusinessId;
        if("businessRuleConditionId".equalsIgnoreCase(attributeName))
            return businessRuleConditionId;
        if("mustComment".equalsIgnoreCase(attributeName))
            return mustComment;
        if("showIfConditionFails".equalsIgnoreCase(attributeName))
            return showIfConditionFails;
        if("workflowStateActionAcls".equalsIgnoreCase(attributeName))
            return workflowStateActionAcls;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("workflowState".equalsIgnoreCase(attributeName))
            workflowState =(WorkflowState)attributeValue;
        if("workflowActionList".equalsIgnoreCase(attributeName))
            workflowActionList =(WorkflowActionList)attributeValue;
        if("name".equalsIgnoreCase(attributeName))
            name =(String)attributeValue;
        if("description".equalsIgnoreCase(attributeName))
            description =(String)attributeValue;
        if("iconImagePath".equalsIgnoreCase(attributeName))
            iconImagePath =(String)attributeValue;
        if("actionBusinessId".equalsIgnoreCase(attributeName))
            actionBusinessId =(String)attributeValue;
        if("businessRuleConditionId".equalsIgnoreCase(attributeName))
            businessRuleConditionId =(String)attributeValue;
        if("mustComment".equalsIgnoreCase(attributeName))
            mustComment =(Boolean)attributeValue;
        if("showIfConditionFails".equalsIgnoreCase(attributeName))
            showIfConditionFails =(Boolean)attributeValue;
        if("workflowStateActionAcls".equalsIgnoreCase(attributeName))
            workflowStateActionAcls =(Set<WorkflowStateActionAcl>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** workflowState private attribute */
    private WorkflowState workflowState;

    /** workflowActionList private attribute */
    private WorkflowActionList workflowActionList;

    /** name private attribute */
    private String name;

    /** description private attribute */
    private String description;

    /** iconImagePath private attribute */
    private String iconImagePath;

    /** actionBusinessId private attribute */
    private String actionBusinessId;

    /** businessRuleConditionId private attribute */
    private String businessRuleConditionId;

    /** mustComment private attribute */
    private boolean mustComment;

    /** showIfConditionFails private attribute */
    private boolean showIfConditionFails;

    /** workflowStateActionAcls private attribute */
    private Set<WorkflowStateActionAcl> workflowStateActionAcls = new HashSet<WorkflowStateActionAcl>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public WorkflowStateAction() {
    }

	/** 
	 * minimal constructor
	 *
     * @param workflowState the workflowState
     * @param workflowActionList the workflowActionList
     * @param name the name
     * @param mustComment the mustComment
    }
	 */
    public WorkflowStateAction(WorkflowState workflowState, WorkflowActionList workflowActionList, String name, boolean mustComment) {
        this.workflowState = workflowState;
        this.workflowActionList = workflowActionList;
        this.name = name;
        this.mustComment = mustComment;
    }

    /**
     * full constructor
	 *
     * @param workflowState the workflowState
     * @param workflowActionList the workflowActionList
     * @param name the name
     * @param description the description
     * @param iconImagePath the iconImagePath
     * @param actionBusinessId the actionBusinessId
     * @param businessRuleConditionId the businessRuleConditionId
     * @param mustComment the mustComment
     * @param showIfConditionFails the showIfConditionFails
     * @param workflowStateActionAcls the workflowStateActionAcls
     */
    public WorkflowStateAction(WorkflowState workflowState, WorkflowActionList workflowActionList, String name, String description, String iconImagePath, String actionBusinessId, String businessRuleConditionId, boolean mustComment, boolean showIfConditionFails, Set<WorkflowStateActionAcl> workflowStateActionAcls) {
        this.workflowState = workflowState;
        this.workflowActionList = workflowActionList;
        this.name = name;
        this.description = description;
        this.iconImagePath = iconImagePath;
        this.actionBusinessId = actionBusinessId;
        this.businessRuleConditionId = businessRuleConditionId;
        this.mustComment = mustComment;
        this.showIfConditionFails = showIfConditionFails;
        this.workflowStateActionAcls = workflowStateActionAcls;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * workflowState getter method
     *
     * @return workflowState method
     */
    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }
    
    /**       
     * workflowState setter method
     *
     * @param workflowState the workflowState
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setWorkflowState(WorkflowState workflowState) {
        this.workflowState = workflowState;
        
        return this;
    }
    /**       
     * workflowActionList getter method
     *
     * @return workflowActionList method
     */
    public WorkflowActionList getWorkflowActionList() {
        return this.workflowActionList;
    }
    
    /**       
     * workflowActionList setter method
     *
     * @param workflowActionList the workflowActionList
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setWorkflowActionList(WorkflowActionList workflowActionList) {
        this.workflowActionList = workflowActionList;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name the name
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * description getter method
     *
     * @return description method
     */
    public String getDescription() {
        return this.description;
    }
    
    /**       
     * description setter method
     *
     * @param description the description
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setDescription(String description) {
        this.description = description;
        
        return this;
    }
    /**       
     * iconImagePath getter method
     *
     * @return iconImagePath method
     */
    public String getIconImagePath() {
        return this.iconImagePath;
    }
    
    /**       
     * iconImagePath setter method
     *
     * @param iconImagePath the iconImagePath
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setIconImagePath(String iconImagePath) {
        this.iconImagePath = iconImagePath;
        
        return this;
    }
    /**       
     * actionBusinessId getter method
     *
     * @return actionBusinessId method
     */
    public String getActionBusinessId() {
        return this.actionBusinessId;
    }
    
    /**       
     * actionBusinessId setter method
     *
     * @param actionBusinessId the actionBusinessId
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setActionBusinessId(String actionBusinessId) {
        this.actionBusinessId = actionBusinessId;
        
        return this;
    }
    /**       
     * businessRuleConditionId getter method
     *
     * @return businessRuleConditionId method
     */
    public String getBusinessRuleConditionId() {
        return this.businessRuleConditionId;
    }
    
    /**       
     * businessRuleConditionId setter method
     *
     * @param businessRuleConditionId the businessRuleConditionId
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setBusinessRuleConditionId(String businessRuleConditionId) {
        this.businessRuleConditionId = businessRuleConditionId;
        
        return this;
    }
    /**       
     * mustComment getter method
     *
     * @return mustComment method
     */
    public boolean isMustComment() {
        return this.mustComment;
    }
    
    /**       
     * mustComment setter method
     *
     * @param mustComment the mustComment
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setMustComment(boolean mustComment) {
        this.mustComment = mustComment;
        
        return this;
    }
    /**       
     * showIfConditionFails getter method
     *
     * @return showIfConditionFails method
     */
    public boolean isShowIfConditionFails() {
        return this.showIfConditionFails;
    }
    
    /**       
     * showIfConditionFails setter method
     *
     * @param showIfConditionFails the showIfConditionFails
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setShowIfConditionFails(boolean showIfConditionFails) {
        this.showIfConditionFails = showIfConditionFails;
        
        return this;
    }
    /**       
     * workflowStateActionAcls getter method
     *
     * @return workflowStateActionAcls method
     */
    public Set<WorkflowStateActionAcl> getWorkflowStateActionAcls() {
        return this.workflowStateActionAcls;
    }
    
    /**       
     * workflowStateActionAcls setter method
     *
     * @param workflowStateActionAcls the workflowStateActionAcls
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setWorkflowStateActionAcls(Set<WorkflowStateActionAcl> workflowStateActionAcls) {
        this.workflowStateActionAcls = workflowStateActionAcls;
        
        return this;
    }

    /**
     * workflowState id getter method
     *
     * @return workflowState id method
     */
    public Long getWorkflowStateId() {
        if (this.workflowState == null)
            return null;
        else
            return this.workflowState.getId();
    }

    /**
     * WorkflowState proxy setter method from id.
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setWorkflowStateProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflowState = null;
        else
            this.workflowState = WorkflowState.getProxy(id);

        return this;
    }

    /**
     * WorkflowState instance setter method from id.
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setWorkflowStateInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflowState = null;
        else
            this.workflowState = WorkflowState.getInstance(id);

        return this;
    }
    /**
     * workflowActionList id getter method
     *
     * @return workflowActionList id method
     */
    public Long getWorkflowActionListId() {
        if (this.workflowActionList == null)
            return null;
        else
            return this.workflowActionList.getId();
    }

    /**
     * WorkflowActionList proxy setter method from id.
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setWorkflowActionListProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflowActionList = null;
        else
            this.workflowActionList = WorkflowActionList.getProxy(id);

        return this;
    }

    /**
     * WorkflowActionList instance setter method from id.
     *
     * @return WorkflowStateAction modified instance
     */
    public WorkflowStateAction setWorkflowActionListInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflowActionList = null;
        else
            this.workflowActionList = WorkflowActionList.getInstance(id);

        return this;
    }

    /**
     * Creates a String representation of the WorkflowStateAction object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("description").append("='").append(getDescription()).append("' ");			
        buffer.append("iconImagePath").append("='").append(getIconImagePath()).append("' ");			
        buffer.append("actionBusinessId").append("='").append(getActionBusinessId()).append("' ");			
        buffer.append("businessRuleConditionId").append("='").append(getBusinessRuleConditionId()).append("' ");			
        buffer.append("mustComment").append("='").append(isMustComment()).append("' ");			
        buffer.append("showIfConditionFails").append("='").append(isShowIfConditionFails()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the WorkflowStateAction object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(WorkflowStateAction other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("description".equalsIgnoreCase(attributeName))
        	this.description = attributeValue;

        if ("iconImagePath".equalsIgnoreCase(attributeName))
        	this.iconImagePath = attributeValue;

        if ("actionBusinessId".equalsIgnoreCase(attributeName))
        	this.actionBusinessId = attributeValue;

        if ("businessRuleConditionId".equalsIgnoreCase(attributeName))
        	this.businessRuleConditionId = attributeValue;

        if ("mustComment".equalsIgnoreCase(attributeName))
            this.mustComment = Boolean.valueOf(attributeValue);

        if ("showIfConditionFails".equalsIgnoreCase(attributeName))
            this.showIfConditionFails = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static WorkflowStateAction getProxy(Session session, Long id)
    {
        return(WorkflowStateAction)session.load(WorkflowStateAction.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static WorkflowStateAction getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowStateAction result = (WorkflowStateAction)session.load(WorkflowStateAction.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static WorkflowStateAction getInstanceForSession(Session session, Long id)
    {
        return(WorkflowStateAction)session.get(WorkflowStateAction.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static WorkflowStateAction getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowStateAction result = (WorkflowStateAction)session.get(WorkflowStateAction.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
