package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link WorkflowState}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class WorkflowStateFieldAttributes extends AbstractBeanAttributesDefinition{

    /** description (Database column: DESCRIPTION) */
    static public AttributeDefinition description =
        new AttributeDefinition("description")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE")
                .setDatabaseId("DESCRIPTION")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(String.class);

    /** iconImagePath (Database column: ICON_IMAGE_PATH) */
    static public AttributeDefinition iconImagePath =
        new AttributeDefinition("iconImagePath")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE")
                .setDatabaseId("ICON_IMAGE_PATH")
                .setMandatory(false)
                .setMaxSize(1000)
                .setType(String.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setType(Long.class);

    /** isFinal (Database column: IS_FINAL) */
    static public AttributeDefinition isFinal =
        new AttributeDefinition("isFinal")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE")
                .setDatabaseId("IS_FINAL")
                .setMandatory(false)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setDefaultValue("0")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** isInitial (Database column: IS_INITIAL) */
    static public AttributeDefinition isInitial =
        new AttributeDefinition("isInitial")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE")
                .setDatabaseId("IS_INITIAL")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setDefaultValue("0")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** keyword (Database column: KEYWORD) */
    static public AttributeDefinition keyword =
        new AttributeDefinition("keyword")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE")
                .setDatabaseId("KEYWORD")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(String.class);

    /** name (Database column: NAME) */
    static public AttributeDefinition name =
        new AttributeDefinition("name")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE")
                .setDatabaseId("NAME")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /** workflowActionListByOnEnterActionListId (Database column: ON_ENTER_ACTION_LIST_ID) */
    static public AttributeDefinition workflowActionListByOnEnterActionListId =
        new AttributeDefinition("workflowActionListByOnEnterActionListId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE")
                .setDatabaseId("ON_ENTER_ACTION_LIST_ID")
                .setMandatory(false)
                .setMaxSize(22)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.WorkflowActionList.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.WorkflowActionList.class);

    /** workflowActionListByOnExitActionListId (Database column: ON_EXIT_ACTION_LIST_ID) */
    static public AttributeDefinition workflowActionListByOnExitActionListId =
        new AttributeDefinition("workflowActionListByOnExitActionListId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE")
                .setDatabaseId("ON_EXIT_ACTION_LIST_ID")
                .setMandatory(false)
                .setMaxSize(22)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.WorkflowActionList.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.WorkflowActionList.class);

    /** stateBusinessId (Database column: STATE_BUSINESS_ID) */
    static public AttributeDefinition stateBusinessId =
        new AttributeDefinition("stateBusinessId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE")
                .setDatabaseId("STATE_BUSINESS_ID")
                .setMandatory(false)
                .setMaxSize(500)
                .setType(String.class);

    /** workflow (Database column: WORKFLOW_ID) */
    static public AttributeDefinition workflow =
        new AttributeDefinition("workflow")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE")
                .setDatabaseId("WORKFLOW_ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Workflow.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Workflow.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return "name";
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(description.getName(),description);
        map.put(iconImagePath.getName(),iconImagePath);
        map.put(id.getName(),id);
        map.put(isFinal.getName(),isFinal);
        map.put(isInitial.getName(),isInitial);
        map.put(keyword.getName(),keyword);
        map.put(name.getName(),name);
        map.put(workflowActionListByOnEnterActionListId.getName(),workflowActionListByOnEnterActionListId);
        map.put(workflowActionListByOnExitActionListId.getName(),workflowActionListByOnExitActionListId);
        map.put(stateBusinessId.getName(),stateBusinessId);
        map.put(workflow.getName(),workflow);

        return map;
    }
}