package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * WorkflowUserProfile
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class WorkflowUserProfile extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<WorkflowUserProfile> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** WorkflowUserProfile attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** name column */
        public static final String NAME ="name";
        /** groupId column */
        public static final String GROUPID ="groupId";
        /** profileBusinessId column */
        public static final String PROFILEBUSINESSID ="profileBusinessId";
        /** profileBusinessIdParams column */
        public static final String PROFILEBUSINESSIDPARAMS ="profileBusinessIdParams";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");
            list.add("groupId");
            list.add("profileBusinessId");
            list.add("profileBusinessIdParams");

            return list;
        }
    }

    /** Field attributes */
    public static WorkflowUserProfileFieldAttributes FieldAttributes=new WorkflowUserProfileFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public WorkflowUserProfileFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * workflow relation.
         *
         * @return the workflow bean relations attributes.
         */
        public Workflow.Relations workflow()
        {
            Workflow c = new Workflow();
            return c.new Relations(this.buildPath("workflow"));
        }

        /**
         * workflowAliTargets relation.
         *
         * @return the workflowAliTargets bean relations attributes.
         */
        public WorkflowAliTarget.Relations workflowAliTargets()
        {
            WorkflowAliTarget c = new WorkflowAliTarget();
            return c.new Relations(this.buildPath("workflowAliTargets"));
        }

        /**
         * workflowFileAcls relation.
         *
         * @return the workflowFileAcls bean relations attributes.
         */
        public WorkflowFileAcl.Relations workflowFileAcls()
        {
            WorkflowFileAcl c = new WorkflowFileAcl();
            return c.new Relations(this.buildPath("workflowFileAcls"));
        }

        /**
         * workflowStateActionAcls relation.
         *
         * @return the workflowStateActionAcls bean relations attributes.
         */
        public WorkflowStateActionAcl.Relations workflowStateActionAcls()
        {
            WorkflowStateActionAcl c = new WorkflowStateActionAcl();
            return c.new Relations(this.buildPath("workflowStateActionAcls"));
        }

        /**
         * workflowCustomFormConfigs relation.
         *
         * @return the workflowCustomFormConfigs bean relations attributes.
         */
        public WorkflowCustomFormConfig.Relations workflowCustomFormConfigs()
        {
            WorkflowCustomFormConfig c = new WorkflowCustomFormConfig();
            return c.new Relations(this.buildPath("workflowCustomFormConfigs"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
        /**
         * the GROUPID path.
         *
         * @return the path
         */
        public String GROUPID()
        {
            return buildPath(Fields.GROUPID);
        }
        /**
         * the PROFILEBUSINESSID path.
         *
         * @return the path
         */
        public String PROFILEBUSINESSID()
        {
            return buildPath(Fields.PROFILEBUSINESSID);
        }
        /**
         * the PROFILEBUSINESSIDPARAMS path.
         *
         * @return the path
         */
        public String PROFILEBUSINESSIDPARAMS()
        {
            return buildPath(Fields.PROFILEBUSINESSIDPARAMS);
        }
    }

    /** The dummy obj. */
    private static WorkflowUserProfile dummyObj=new WorkflowUserProfile();

    /**
     * Get WorkflowUserProfile Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<WorkflowUserProfile> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<WorkflowUserProfile> getDataSetInstance()
    {
        return new HibernateDataSet<WorkflowUserProfile>(WorkflowUserProfile.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            WorkflowUserProfile.getPKFieldListAsString(), WorkflowUserProfile.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("workflow".equalsIgnoreCase(attributeName))
            return workflow;
        if("name".equalsIgnoreCase(attributeName))
            return name;
        if("groupId".equalsIgnoreCase(attributeName))
            return groupId;
        if("profileBusinessId".equalsIgnoreCase(attributeName))
            return profileBusinessId;
        if("profileBusinessIdParams".equalsIgnoreCase(attributeName))
            return profileBusinessIdParams;
        if("workflowAliTargets".equalsIgnoreCase(attributeName))
            return workflowAliTargets;
        if("workflowFileAcls".equalsIgnoreCase(attributeName))
            return workflowFileAcls;
        if("workflowStateActionAcls".equalsIgnoreCase(attributeName))
            return workflowStateActionAcls;
        if("workflowCustomFormConfigs".equalsIgnoreCase(attributeName))
            return workflowCustomFormConfigs;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("workflow".equalsIgnoreCase(attributeName))
            workflow =(Workflow)attributeValue;
        if("name".equalsIgnoreCase(attributeName))
            name =(String)attributeValue;
        if("groupId".equalsIgnoreCase(attributeName))
            groupId =(String)attributeValue;
        if("profileBusinessId".equalsIgnoreCase(attributeName))
            profileBusinessId =(String)attributeValue;
        if("profileBusinessIdParams".equalsIgnoreCase(attributeName))
            profileBusinessIdParams =(String)attributeValue;
        if("workflowAliTargets".equalsIgnoreCase(attributeName))
            workflowAliTargets =(Set<WorkflowAliTarget>)attributeValue;
        if("workflowFileAcls".equalsIgnoreCase(attributeName))
            workflowFileAcls =(Set<WorkflowFileAcl>)attributeValue;
        if("workflowStateActionAcls".equalsIgnoreCase(attributeName))
            workflowStateActionAcls =(Set<WorkflowStateActionAcl>)attributeValue;
        if("workflowCustomFormConfigs".equalsIgnoreCase(attributeName))
            workflowCustomFormConfigs =(Set<WorkflowCustomFormConfig>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** workflow private attribute */
    private Workflow workflow;

    /** name private attribute */
    private String name;

    /** groupId private attribute */
    private String groupId;

    /** profileBusinessId private attribute */
    private String profileBusinessId;

    /** profileBusinessIdParams private attribute */
    private String profileBusinessIdParams;

    /** workflowAliTargets private attribute */
    private Set<WorkflowAliTarget> workflowAliTargets = new HashSet<WorkflowAliTarget>(0);

    /** workflowFileAcls private attribute */
    private Set<WorkflowFileAcl> workflowFileAcls = new HashSet<WorkflowFileAcl>(0);

    /** workflowStateActionAcls private attribute */
    private Set<WorkflowStateActionAcl> workflowStateActionAcls = new HashSet<WorkflowStateActionAcl>(0);

    /** workflowCustomFormConfigs private attribute */
    private Set<WorkflowCustomFormConfig> workflowCustomFormConfigs = new HashSet<WorkflowCustomFormConfig>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public WorkflowUserProfile() {
    }

	/** 
	 * minimal constructor
	 *
     * @param workflow the workflow
     * @param name the name
    }
	 */
    public WorkflowUserProfile(Workflow workflow, String name) {
        this.workflow = workflow;
        this.name = name;
    }

    /**
     * full constructor
	 *
     * @param workflow the workflow
     * @param name the name
     * @param groupId the groupId
     * @param profileBusinessId the profileBusinessId
     * @param profileBusinessIdParams the profileBusinessIdParams
     * @param workflowAliTargets the workflowAliTargets
     * @param workflowFileAcls the workflowFileAcls
     * @param workflowStateActionAcls the workflowStateActionAcls
     * @param workflowCustomFormConfigs the workflowCustomFormConfigs
     */
    public WorkflowUserProfile(Workflow workflow, String name, String groupId, String profileBusinessId, String profileBusinessIdParams, Set<WorkflowAliTarget> workflowAliTargets, Set<WorkflowFileAcl> workflowFileAcls, Set<WorkflowStateActionAcl> workflowStateActionAcls, Set<WorkflowCustomFormConfig> workflowCustomFormConfigs) {
        this.workflow = workflow;
        this.name = name;
        this.groupId = groupId;
        this.profileBusinessId = profileBusinessId;
        this.profileBusinessIdParams = profileBusinessIdParams;
        this.workflowAliTargets = workflowAliTargets;
        this.workflowFileAcls = workflowFileAcls;
        this.workflowStateActionAcls = workflowStateActionAcls;
        this.workflowCustomFormConfigs = workflowCustomFormConfigs;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return WorkflowUserProfile modified instance
     */
    public WorkflowUserProfile setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * workflow getter method
     *
     * @return workflow method
     */
    public Workflow getWorkflow() {
        return this.workflow;
    }
    
    /**       
     * workflow setter method
     *
     * @param workflow the workflow
     *
     * @return WorkflowUserProfile modified instance
     */
    public WorkflowUserProfile setWorkflow(Workflow workflow) {
        this.workflow = workflow;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name the name
     *
     * @return WorkflowUserProfile modified instance
     */
    public WorkflowUserProfile setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * groupId getter method
     *
     * @return groupId method
     */
    public String getGroupId() {
        return this.groupId;
    }
    
    /**       
     * groupId setter method
     *
     * @param groupId the groupId
     *
     * @return WorkflowUserProfile modified instance
     */
    public WorkflowUserProfile setGroupId(String groupId) {
        this.groupId = groupId;
        
        return this;
    }
    /**       
     * profileBusinessId getter method
     *
     * @return profileBusinessId method
     */
    public String getProfileBusinessId() {
        return this.profileBusinessId;
    }
    
    /**       
     * profileBusinessId setter method
     *
     * @param profileBusinessId the profileBusinessId
     *
     * @return WorkflowUserProfile modified instance
     */
    public WorkflowUserProfile setProfileBusinessId(String profileBusinessId) {
        this.profileBusinessId = profileBusinessId;
        
        return this;
    }
    /**       
     * profileBusinessIdParams getter method
     *
     * @return profileBusinessIdParams method
     */
    public String getProfileBusinessIdParams() {
        return this.profileBusinessIdParams;
    }
    
    /**       
     * profileBusinessIdParams setter method
     *
     * @param profileBusinessIdParams the profileBusinessIdParams
     *
     * @return WorkflowUserProfile modified instance
     */
    public WorkflowUserProfile setProfileBusinessIdParams(String profileBusinessIdParams) {
        this.profileBusinessIdParams = profileBusinessIdParams;
        
        return this;
    }
    /**       
     * workflowAliTargets getter method
     *
     * @return workflowAliTargets method
     */
    public Set<WorkflowAliTarget> getWorkflowAliTargets() {
        return this.workflowAliTargets;
    }
    
    /**       
     * workflowAliTargets setter method
     *
     * @param workflowAliTargets the workflowAliTargets
     *
     * @return WorkflowUserProfile modified instance
     */
    public WorkflowUserProfile setWorkflowAliTargets(Set<WorkflowAliTarget> workflowAliTargets) {
        this.workflowAliTargets = workflowAliTargets;
        
        return this;
    }
    /**       
     * workflowFileAcls getter method
     *
     * @return workflowFileAcls method
     */
    public Set<WorkflowFileAcl> getWorkflowFileAcls() {
        return this.workflowFileAcls;
    }
    
    /**       
     * workflowFileAcls setter method
     *
     * @param workflowFileAcls the workflowFileAcls
     *
     * @return WorkflowUserProfile modified instance
     */
    public WorkflowUserProfile setWorkflowFileAcls(Set<WorkflowFileAcl> workflowFileAcls) {
        this.workflowFileAcls = workflowFileAcls;
        
        return this;
    }
    /**       
     * workflowStateActionAcls getter method
     *
     * @return workflowStateActionAcls method
     */
    public Set<WorkflowStateActionAcl> getWorkflowStateActionAcls() {
        return this.workflowStateActionAcls;
    }
    
    /**       
     * workflowStateActionAcls setter method
     *
     * @param workflowStateActionAcls the workflowStateActionAcls
     *
     * @return WorkflowUserProfile modified instance
     */
    public WorkflowUserProfile setWorkflowStateActionAcls(Set<WorkflowStateActionAcl> workflowStateActionAcls) {
        this.workflowStateActionAcls = workflowStateActionAcls;
        
        return this;
    }
    /**       
     * workflowCustomFormConfigs getter method
     *
     * @return workflowCustomFormConfigs method
     */
    public Set<WorkflowCustomFormConfig> getWorkflowCustomFormConfigs() {
        return this.workflowCustomFormConfigs;
    }
    
    /**       
     * workflowCustomFormConfigs setter method
     *
     * @param workflowCustomFormConfigs the workflowCustomFormConfigs
     *
     * @return WorkflowUserProfile modified instance
     */
    public WorkflowUserProfile setWorkflowCustomFormConfigs(Set<WorkflowCustomFormConfig> workflowCustomFormConfigs) {
        this.workflowCustomFormConfigs = workflowCustomFormConfigs;
        
        return this;
    }

    /**
     * workflow id getter method
     *
     * @return workflow id method
     */
    public Long getWorkflowId() {
        if (this.workflow == null)
            return null;
        else
            return this.workflow.getId();
    }

    /**
     * Workflow proxy setter method from id.
     *
     * @return WorkflowUserProfile modified instance
     */
    public WorkflowUserProfile setWorkflowProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflow = null;
        else
            this.workflow = Workflow.getProxy(id);

        return this;
    }

    /**
     * Workflow instance setter method from id.
     *
     * @return WorkflowUserProfile modified instance
     */
    public WorkflowUserProfile setWorkflowInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.workflow = null;
        else
            this.workflow = Workflow.getInstance(id);

        return this;
    }

    /**
     * Creates a String representation of the WorkflowUserProfile object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("groupId").append("='").append(getGroupId()).append("' ");			
        buffer.append("profileBusinessId").append("='").append(getProfileBusinessId()).append("' ");			
        buffer.append("profileBusinessIdParams").append("='").append(getProfileBusinessIdParams()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the WorkflowUserProfile object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(WorkflowUserProfile other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("groupId".equalsIgnoreCase(attributeName))
        	this.groupId = attributeValue;

        if ("profileBusinessId".equalsIgnoreCase(attributeName))
        	this.profileBusinessId = attributeValue;

        if ("profileBusinessIdParams".equalsIgnoreCase(attributeName))
        	this.profileBusinessIdParams = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static WorkflowUserProfile getProxy(Session session, Long id)
    {
        return(WorkflowUserProfile)session.load(WorkflowUserProfile.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static WorkflowUserProfile getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowUserProfile result = (WorkflowUserProfile)session.load(WorkflowUserProfile.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static WorkflowUserProfile getInstanceForSession(Session session, Long id)
    {
        return(WorkflowUserProfile)session.get(WorkflowUserProfile.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static WorkflowUserProfile getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowUserProfile result = (WorkflowUserProfile)session.get(WorkflowUserProfile.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
