package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link WorkflowUserProfile}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class WorkflowUserProfileFieldAttributes extends AbstractBeanAttributesDefinition{

    /** groupId (Database column: GROUP_ID) */
    static public AttributeDefinition groupId =
        new AttributeDefinition("groupId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_USER_PROFILE")
                .setDatabaseId("GROUP_ID")
                .setMandatory(false)
                .setMaxSize(500)
                .setType(String.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_USER_PROFILE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setType(Long.class);

    /** name (Database column: NAME) */
    static public AttributeDefinition name =
        new AttributeDefinition("name")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_USER_PROFILE")
                .setDatabaseId("NAME")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /** profileBusinessId (Database column: PROFILE_BUSINESS_ID) */
    static public AttributeDefinition profileBusinessId =
        new AttributeDefinition("profileBusinessId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_USER_PROFILE")
                .setDatabaseId("PROFILE_BUSINESS_ID")
                .setMandatory(false)
                .setMaxSize(200)
                .setType(String.class);

    /** profileBusinessIdParams (Database column: PROFILE_BUSINESS_ID_PARAMS) */
    static public AttributeDefinition profileBusinessIdParams =
        new AttributeDefinition("profileBusinessIdParams")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_USER_PROFILE")
                .setDatabaseId("PROFILE_BUSINESS_ID_PARAMS")
                .setMandatory(false)
                .setMaxSize(1000)
                .setType(String.class);

    /** workflow (Database column: WORKFLOW_ID) */
    static public AttributeDefinition workflow =
        new AttributeDefinition("workflow")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_USER_PROFILE")
                .setDatabaseId("WORKFLOW_ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Workflow.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Workflow.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return "name";
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(groupId.getName(),groupId);
        map.put(id.getName(),id);
        map.put(name.getName(),name);
        map.put(profileBusinessId.getName(),profileBusinessId);
        map.put(profileBusinessIdParams.getName(),profileBusinessIdParams);
        map.put(workflow.getName(),workflow);

        return map;
    }
}