package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSetLegacyNoPK;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.IErrorLoggingService;
import pt.digitalis.dif.dem.managers.impl.model.data.ErrorLog;

/**
* NOTE: This file is auto generated and will be overwrite in a future file generation.
*/
public class ErrorLoggingServiceImpl implements IErrorLoggingService {

    /**
     * Constant with the session factory ID
     */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /**
     * Obtains a new DataSet for the ErrorLog entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<ErrorLog> getErrorLogDataSet() {
        return new HibernateDataSet<ErrorLog>(ErrorLog.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                ErrorLog.getPKFieldListAsString(), ErrorLog.FieldAttributes);
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == ErrorLog.class)
            return getErrorLogDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(ErrorLog.class.getSimpleName()))
            return getErrorLogDataSet();

        return null;
    }
}