package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSetLegacyNoPK;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.IEventsService;
import pt.digitalis.dif.dem.managers.impl.model.data.Event;
import pt.digitalis.dif.dem.managers.impl.model.data.EventSubscription;
import pt.digitalis.dif.dem.managers.impl.model.data.EventLogProcess;

/**
* NOTE: This file is auto generated and will be overwrite in a future file generation.
*/
public class EventsServiceImpl implements IEventsService {

    /**
     * Constant with the session factory ID
     */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /**
     * Obtains a new DataSet for the Event entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<Event> getEventDataSet() {
        return new HibernateDataSet<Event>(Event.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                Event.getPKFieldListAsString(), Event.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the EventSubscription entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<EventSubscription> getEventSubscriptionDataSet() {
        return new HibernateDataSet<EventSubscription>(EventSubscription.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                EventSubscription.getPKFieldListAsString(), EventSubscription.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the EventLogProcess entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<EventLogProcess> getEventLogProcessDataSet() {
        return new HibernateDataSet<EventLogProcess>(EventLogProcess.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                EventLogProcess.getPKFieldListAsString(), EventLogProcess.FieldAttributes);
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == Event.class)
            return getEventDataSet();

        if (clazz == EventSubscription.class)
            return getEventSubscriptionDataSet();

        if (clazz == EventLogProcess.class)
            return getEventLogProcessDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(Event.class.getSimpleName()))
            return getEventDataSet();

        if (entityName.equalsIgnoreCase(EventSubscription.class.getSimpleName()))
            return getEventSubscriptionDataSet();

        if (entityName.equalsIgnoreCase(EventLogProcess.class.getSimpleName()))
            return getEventLogProcessDataSet();

        return null;
    }
}