package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSetLegacyNoPK;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.IIdentityService;
import pt.digitalis.dif.dem.managers.impl.model.data.Users;
import pt.digitalis.dif.dem.managers.impl.model.data.UserAttributes;
import pt.digitalis.dif.dem.managers.impl.model.data.Groups;
import pt.digitalis.dif.dem.managers.impl.model.data.UserGroups;

/**
* NOTE: This file is auto generated and will be overwrite in a future file generation.
*/
public class IdentityServiceImpl implements IIdentityService {

    /**
     * Constant with the session factory ID
     */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /**
     * Obtains a new DataSet for the Users entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<Users> getUsersDataSet() {
        return new HibernateDataSet<Users>(Users.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                Users.getPKFieldListAsString(), Users.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the UserAttributes entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<UserAttributes> getUserAttributesDataSet() {
        return new HibernateDataSet<UserAttributes>(UserAttributes.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                UserAttributes.getPKFieldListAsString(), UserAttributes.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the Groups entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<Groups> getGroupsDataSet() {
        return new HibernateDataSet<Groups>(Groups.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                Groups.getPKFieldListAsString(), Groups.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the UserGroups entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<UserGroups> getUserGroupsDataSet() {
        return new HibernateDataSet<UserGroups>(UserGroups.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                UserGroups.getPKFieldListAsString(), UserGroups.FieldAttributes);
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == Users.class)
            return getUsersDataSet();

        if (clazz == UserAttributes.class)
            return getUserAttributesDataSet();

        if (clazz == Groups.class)
            return getGroupsDataSet();

        if (clazz == UserGroups.class)
            return getUserGroupsDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(Users.class.getSimpleName()))
            return getUsersDataSet();

        if (entityName.equalsIgnoreCase(UserAttributes.class.getSimpleName()))
            return getUserAttributesDataSet();

        if (entityName.equalsIgnoreCase(Groups.class.getSimpleName()))
            return getGroupsDataSet();

        if (entityName.equalsIgnoreCase(UserGroups.class.getSimpleName()))
            return getUserGroupsDataSet();

        return null;
    }
}