package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSetLegacyNoPK;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.IRGPDService;
import pt.digitalis.dif.dem.managers.impl.model.data.DataConsent;
import pt.digitalis.dif.dem.managers.impl.model.data.DataConsentUser;
import pt.digitalis.dif.dem.managers.impl.model.data.DataConsentReview;
import pt.digitalis.dif.dem.managers.impl.model.data.DataConsentTrans;
import pt.digitalis.dif.dem.managers.impl.model.data.UserDataConsent;
import pt.digitalis.dif.dem.managers.impl.model.data.UserDataRequest;
import pt.digitalis.dif.dem.managers.impl.model.data.UserDataRequestComment;

/**
* NOTE: This file is auto generated and will be overwrite in a future file generation.
*/
public class RGPDServiceImpl implements IRGPDService {

    /**
     * Constant with the session factory ID
     */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /**
     * Obtains a new DataSet for the DataConsent entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<DataConsent> getDataConsentDataSet() {
        return new HibernateDataSet<DataConsent>(DataConsent.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                DataConsent.getPKFieldListAsString(), DataConsent.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the DataConsentUser entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<DataConsentUser> getDataConsentUserDataSet() {
        return new HibernateDataSet<DataConsentUser>(DataConsentUser.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                DataConsentUser.getPKFieldListAsString(), DataConsentUser.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the DataConsentReview entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<DataConsentReview> getDataConsentReviewDataSet() {
        return new HibernateDataSet<DataConsentReview>(DataConsentReview.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                DataConsentReview.getPKFieldListAsString(), DataConsentReview.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the DataConsentTrans entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<DataConsentTrans> getDataConsentTransDataSet() {
        return new HibernateDataSet<DataConsentTrans>(DataConsentTrans.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                DataConsentTrans.getPKFieldListAsString(), DataConsentTrans.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the UserDataConsent entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<UserDataConsent> getUserDataConsentDataSet() {
        return new HibernateDataSet<UserDataConsent>(UserDataConsent.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                UserDataConsent.getPKFieldListAsString(), UserDataConsent.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the UserDataRequest entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<UserDataRequest> getUserDataRequestDataSet() {
        return new HibernateDataSet<UserDataRequest>(UserDataRequest.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                UserDataRequest.getPKFieldListAsString(), UserDataRequest.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the UserDataRequestComment entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<UserDataRequestComment> getUserDataRequestCommentDataSet() {
        return new HibernateDataSet<UserDataRequestComment>(UserDataRequestComment.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                UserDataRequestComment.getPKFieldListAsString(), UserDataRequestComment.FieldAttributes);
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == DataConsent.class)
            return getDataConsentDataSet();

        if (clazz == DataConsentUser.class)
            return getDataConsentUserDataSet();

        if (clazz == DataConsentReview.class)
            return getDataConsentReviewDataSet();

        if (clazz == DataConsentTrans.class)
            return getDataConsentTransDataSet();

        if (clazz == UserDataConsent.class)
            return getUserDataConsentDataSet();

        if (clazz == UserDataRequest.class)
            return getUserDataRequestDataSet();

        if (clazz == UserDataRequestComment.class)
            return getUserDataRequestCommentDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(DataConsent.class.getSimpleName()))
            return getDataConsentDataSet();

        if (entityName.equalsIgnoreCase(DataConsentUser.class.getSimpleName()))
            return getDataConsentUserDataSet();

        if (entityName.equalsIgnoreCase(DataConsentReview.class.getSimpleName()))
            return getDataConsentReviewDataSet();

        if (entityName.equalsIgnoreCase(DataConsentTrans.class.getSimpleName()))
            return getDataConsentTransDataSet();

        if (entityName.equalsIgnoreCase(UserDataConsent.class.getSimpleName()))
            return getUserDataConsentDataSet();

        if (entityName.equalsIgnoreCase(UserDataRequest.class.getSimpleName()))
            return getUserDataRequestDataSet();

        if (entityName.equalsIgnoreCase(UserDataRequestComment.class.getSimpleName()))
            return getUserDataRequestCommentDataSet();

        return null;
    }
}