package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSetLegacyNoPK;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.IServersService;
import pt.digitalis.dif.dem.managers.impl.model.data.Server;
import pt.digitalis.dif.dem.managers.impl.model.data.ServerActivityLog;
import pt.digitalis.dif.dem.managers.impl.model.data.ServerMessage;

/**
* NOTE: This file is auto generated and will be overwrite in a future file generation.
*/
public class ServersServiceImpl implements IServersService {

    /**
     * Constant with the session factory ID
     */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /**
     * Obtains a new DataSet for the Server entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<Server> getServerDataSet() {
        return new HibernateDataSet<Server>(Server.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                Server.getPKFieldListAsString(), Server.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the ServerActivityLog entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<ServerActivityLog> getServerActivityLogDataSet() {
        return new HibernateDataSet<ServerActivityLog>(ServerActivityLog.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                ServerActivityLog.getPKFieldListAsString(), ServerActivityLog.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the ServerMessage entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<ServerMessage> getServerMessageDataSet() {
        return new HibernateDataSet<ServerMessage>(ServerMessage.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                ServerMessage.getPKFieldListAsString(), ServerMessage.FieldAttributes);
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == Server.class)
            return getServerDataSet();

        if (clazz == ServerActivityLog.class)
            return getServerActivityLogDataSet();

        if (clazz == ServerMessage.class)
            return getServerMessageDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(Server.class.getSimpleName()))
            return getServerDataSet();

        if (entityName.equalsIgnoreCase(ServerActivityLog.class.getSimpleName()))
            return getServerActivityLogDataSet();

        if (entityName.equalsIgnoreCase(ServerMessage.class.getSimpleName()))
            return getServerMessageDataSet();

        return null;
    }
}