package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSetLegacyNoPK;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.IWorkflowService;
import pt.digitalis.dif.dem.managers.impl.model.data.Workflow;
import pt.digitalis.dif.dem.managers.impl.model.data.WorkflowActionList;
import pt.digitalis.dif.dem.managers.impl.model.data.WorkflowActionListItem;
import pt.digitalis.dif.dem.managers.impl.model.data.WorkflowAliTarget;
import pt.digitalis.dif.dem.managers.impl.model.data.WorkflowCustomForm;
import pt.digitalis.dif.dem.managers.impl.model.data.WorkflowCustomFormConfig;
import pt.digitalis.dif.dem.managers.impl.model.data.WorkflowFileAcl;
import pt.digitalis.dif.dem.managers.impl.model.data.WorkflowInstance;
import pt.digitalis.dif.dem.managers.impl.model.data.WorkflowState;
import pt.digitalis.dif.dem.managers.impl.model.data.WorkflowStateAction;
import pt.digitalis.dif.dem.managers.impl.model.data.WorkflowStateActionAcl;
import pt.digitalis.dif.dem.managers.impl.model.data.WorkflowUserProfile;

/**
* NOTE: This file is auto generated and will be overwrite in a future file generation.
*/
public class WorkflowServiceImpl implements IWorkflowService {

    /**
     * Constant with the session factory ID
     */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /**
     * Obtains a new DataSet for the Workflow entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<Workflow> getWorkflowDataSet() {
        return new HibernateDataSet<Workflow>(Workflow.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                Workflow.getPKFieldListAsString(), Workflow.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the WorkflowActionList entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<WorkflowActionList> getWorkflowActionListDataSet() {
        return new HibernateDataSet<WorkflowActionList>(WorkflowActionList.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                WorkflowActionList.getPKFieldListAsString(), WorkflowActionList.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the WorkflowActionListItem entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<WorkflowActionListItem> getWorkflowActionListItemDataSet() {
        return new HibernateDataSet<WorkflowActionListItem>(WorkflowActionListItem.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                WorkflowActionListItem.getPKFieldListAsString(), WorkflowActionListItem.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the WorkflowAliTarget entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<WorkflowAliTarget> getWorkflowAliTargetDataSet() {
        return new HibernateDataSet<WorkflowAliTarget>(WorkflowAliTarget.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                WorkflowAliTarget.getPKFieldListAsString(), WorkflowAliTarget.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the WorkflowCustomForm entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<WorkflowCustomForm> getWorkflowCustomFormDataSet() {
        return new HibernateDataSet<WorkflowCustomForm>(WorkflowCustomForm.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                WorkflowCustomForm.getPKFieldListAsString(), WorkflowCustomForm.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the WorkflowCustomFormConfig entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<WorkflowCustomFormConfig> getWorkflowCustomFormConfigDataSet() {
        return new HibernateDataSet<WorkflowCustomFormConfig>(WorkflowCustomFormConfig.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                WorkflowCustomFormConfig.getPKFieldListAsString(), WorkflowCustomFormConfig.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the WorkflowFileAcl entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<WorkflowFileAcl> getWorkflowFileAclDataSet() {
        return new HibernateDataSet<WorkflowFileAcl>(WorkflowFileAcl.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                WorkflowFileAcl.getPKFieldListAsString(), WorkflowFileAcl.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the WorkflowInstance entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<WorkflowInstance> getWorkflowInstanceDataSet() {
        return new HibernateDataSet<WorkflowInstance>(WorkflowInstance.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                WorkflowInstance.getPKFieldListAsString(), WorkflowInstance.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the WorkflowState entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<WorkflowState> getWorkflowStateDataSet() {
        return new HibernateDataSet<WorkflowState>(WorkflowState.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                WorkflowState.getPKFieldListAsString(), WorkflowState.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the WorkflowStateAction entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<WorkflowStateAction> getWorkflowStateActionDataSet() {
        return new HibernateDataSet<WorkflowStateAction>(WorkflowStateAction.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                WorkflowStateAction.getPKFieldListAsString(), WorkflowStateAction.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the WorkflowStateActionAcl entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<WorkflowStateActionAcl> getWorkflowStateActionAclDataSet() {
        return new HibernateDataSet<WorkflowStateActionAcl>(WorkflowStateActionAcl.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                WorkflowStateActionAcl.getPKFieldListAsString(), WorkflowStateActionAcl.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the WorkflowUserProfile entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<WorkflowUserProfile> getWorkflowUserProfileDataSet() {
        return new HibernateDataSet<WorkflowUserProfile>(WorkflowUserProfile.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                WorkflowUserProfile.getPKFieldListAsString(), WorkflowUserProfile.FieldAttributes);
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == Workflow.class)
            return getWorkflowDataSet();

        if (clazz == WorkflowActionList.class)
            return getWorkflowActionListDataSet();

        if (clazz == WorkflowActionListItem.class)
            return getWorkflowActionListItemDataSet();

        if (clazz == WorkflowAliTarget.class)
            return getWorkflowAliTargetDataSet();

        if (clazz == WorkflowCustomForm.class)
            return getWorkflowCustomFormDataSet();

        if (clazz == WorkflowCustomFormConfig.class)
            return getWorkflowCustomFormConfigDataSet();

        if (clazz == WorkflowFileAcl.class)
            return getWorkflowFileAclDataSet();

        if (clazz == WorkflowInstance.class)
            return getWorkflowInstanceDataSet();

        if (clazz == WorkflowState.class)
            return getWorkflowStateDataSet();

        if (clazz == WorkflowStateAction.class)
            return getWorkflowStateActionDataSet();

        if (clazz == WorkflowStateActionAcl.class)
            return getWorkflowStateActionAclDataSet();

        if (clazz == WorkflowUserProfile.class)
            return getWorkflowUserProfileDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(Workflow.class.getSimpleName()))
            return getWorkflowDataSet();

        if (entityName.equalsIgnoreCase(WorkflowActionList.class.getSimpleName()))
            return getWorkflowActionListDataSet();

        if (entityName.equalsIgnoreCase(WorkflowActionListItem.class.getSimpleName()))
            return getWorkflowActionListItemDataSet();

        if (entityName.equalsIgnoreCase(WorkflowAliTarget.class.getSimpleName()))
            return getWorkflowAliTargetDataSet();

        if (entityName.equalsIgnoreCase(WorkflowCustomForm.class.getSimpleName()))
            return getWorkflowCustomFormDataSet();

        if (entityName.equalsIgnoreCase(WorkflowCustomFormConfig.class.getSimpleName()))
            return getWorkflowCustomFormConfigDataSet();

        if (entityName.equalsIgnoreCase(WorkflowFileAcl.class.getSimpleName()))
            return getWorkflowFileAclDataSet();

        if (entityName.equalsIgnoreCase(WorkflowInstance.class.getSimpleName()))
            return getWorkflowInstanceDataSet();

        if (entityName.equalsIgnoreCase(WorkflowState.class.getSimpleName()))
            return getWorkflowStateDataSet();

        if (entityName.equalsIgnoreCase(WorkflowStateAction.class.getSimpleName()))
            return getWorkflowStateActionDataSet();

        if (entityName.equalsIgnoreCase(WorkflowStateActionAcl.class.getSimpleName()))
            return getWorkflowStateActionAclDataSet();

        if (entityName.equalsIgnoreCase(WorkflowUserProfile.class.getSimpleName()))
            return getWorkflowUserProfileDataSet();

        return null;
    }
}