/**
 * 2013, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.ecommerce;

import pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 29/11/2013
 */
public abstract class AbstractECommerceBusinessImpl implements IECommerceBusiness
{

    /** full identifier cache */
    private static String fullIdentifier = null;

    /** short identifier cache */
    private static String shortIdentifier = null;

    /**
     * Binds the implementation in the IoC with the correct ID
     *
     * @param binder            the IoC binder
     * @param businessImplClass the implementation class implementing the {@link AbstractECommerceBusinessImpl} and
     *                          annotated with
     *                          {@link ECommerceBusinessDefinition}
     */
    public static void bindIoC(IoCBinder binder, Class<? extends AbstractECommerceBusinessImpl> businessImplClass)
    {
        binder.bind(IECommerceBusiness.class, businessImplClass)
                .withId(businessImplClass.getAnnotation(ECommerceBusinessDefinition.class).fullId());
    }

    /**
     * creates an instance of the requested class thought IoC
     *
     * @param <T>
     * @param clazz the class to create an instance
     *
     * @return the instance
     */
    public static <T extends AbstractECommerceBusinessImpl> T getInstance(Class<T> clazz)
    {
        return (T) DIFIoCRegistry.getRegistry().getImplementation(IECommerceBusiness.class,
                clazz.getAnnotation(ECommerceBusinessDefinition.class).fullId());
    }

    /**
     * @see pt.digitalis.dif.ecommerce.IECommerceBusiness#decode(pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments)
     */
    @Override
    public String decode(EcommercePayments paymentRecord)
    {
        return paymentRecord.getBusinessId().split(AbstractECommerce.UNIQUE_ID_SEPARATOR)[1];
    }

    /**
     * @see pt.digitalis.dif.ecommerce.IECommerceBusiness#encodeBusinessId(java.lang.String,
     *         pt.digitalis.dif.ecommerce.IECommerce)
     */
    @Override
    public String encodeBusinessId(String businessID, IECommerce<?> eCommerceImplementation)
    {
        return this.encodeBusinessId(businessID, eCommerceImplementation.getShortIdentifier());
    }

    /**
     * @see pt.digitalis.dif.ecommerce.IECommerceBusiness#encodeBusinessId(java.lang.String, java.lang.String)
     */
    @Override
    public String encodeBusinessId(String businessID, String eCommerceImplementationID)
    {
        return eCommerceImplementationID + ":" + this.getShortIdentifier() + "-" + businessID;
    }

    /**
     * @see pt.digitalis.dif.ecommerce.IECommerceBusiness#getFullIdentifier()
     */
    @Override
    public String getFullIdentifier()
    {
        if (fullIdentifier == null)
        {
            this.initializeIdentifiersFromAnnotation();
        }

        return fullIdentifier;
    }

    /**
     * @see pt.digitalis.dif.ecommerce.IECommerceBusiness#getShortIdentifier()
     */
    @Override
    public String getShortIdentifier()
    {
        if (shortIdentifier == null)
        {
            this.initializeIdentifiersFromAnnotation();
        }

        return shortIdentifier;
    }

    /**
     * Rads the annotation and initializes the cache fields
     */
    private void initializeIdentifiersFromAnnotation()
    {
        ECommerceBusinessDefinition def = this.getClass().getAnnotation(ECommerceBusinessDefinition.class);
        shortIdentifier = def.shortId();
        fullIdentifier = def.fullId();
    }

    /**
     * @see pt.digitalis.dif.ecommerce.IECommerceBusiness#newPaymentRequest(pt.digitalis.dif.controller.interfaces.IDIFContext)
     */
    public PaymentRequest newPaymentRequest()
    {
        PaymentRequest paymentRequest = new PaymentRequest();
        paymentRequest.setCreator(this.getFullIdentifier());

        return paymentRequest;
    }
}
