package pt.digitalis.dif.utils.logging;

import pt.digitalis.dif.dem.managers.impl.model.IErrorLoggingService;
import pt.digitalis.dif.dem.managers.impl.model.data.ErrorLog;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.utils.mail.MailSender;
import pt.digitalis.dif.utils.mail.MailType;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.common.StringUtils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Date;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created 16/04/2014
 */
public class ErrorLogManagerDBImpl implements IErrorLogManager
{

    /**
     * @see pt.digitalis.dif.utils.logging.IErrorLogManager#logError(java.lang.String, java.lang.String,
     *         java.lang.Exception)
     */
    @Override
    public void logError(String applicationName, String processName, Exception e)
    {

        String errorMessage = "";
        StringWriter errors = new StringWriter();
        e.printStackTrace(new PrintWriter(errors));
        errorMessage += "Exception: " + errors.toString() + "\n";

        this.logError(applicationName, processName, errorMessage);
    }

    /**
     * @see pt.digitalis.dif.utils.logging.IErrorLogManager#logError(java.lang.String, java.lang.String,
     *         java.lang.String)
     */
    @Override
    public void logError(String applicationName, String processName, String errorDescription)
    {
        ErrorLog errorLog = new ErrorLog();
        errorLog.setProcessName(processName);
        errorLog.setErrorDescription(errorDescription);
        errorLog.setErroDate(new Timestamp(new Date().getTime()));
        errorLog.setAppName(applicationName);

        IErrorLoggingService errorLoggingService =
                DIFIoCRegistry.getRegistry().getImplementation(IErrorLoggingService.class);

        try
        {
            errorLoggingService.getErrorLogDataSet().insert(errorLog);

            if (!StringUtils.isBlank(LoggingConfiguration.getInstance().getErrorLogEmailAddress()) &&
                !StringUtils.isBlank(LoggingConfiguration.getInstance().getErrorLogEmailBody()) &&
                !StringUtils.isBlank(LoggingConfiguration.getInstance().getErrorLogEmailSubject()))
            {
                try
                {
                    MailSender.getInstance().sendEmail(MailType.PLAIN_TEXT,
                            MailSender.getInstance().getConfiguration().getDefaultFromAddress(),
                            LoggingConfiguration.getInstance().getErrorLogEmailAddress(), null, null,
                            LoggingConfiguration.getInstance().getErrorLogEmailSubject(),
                            LoggingConfiguration.getInstance().getErrorLogEmailBody()
                                                .replace("${applicationName}", errorLog.getAppName()), null, null, null,
                            true, false, null);
                }
                catch (Exception e)
                {
                    DIFLogger.getLogger().log(LogLevel.INFO, "Error sending Email in ErrorLogManager" + e);
                }
            }
        }
        catch (DataSetException e)
        {
            DIFLogger.getLogger().debug(e);
        }
    }
}
