DELIMITER $$
-------------------------------------------------------------
-- REPORT Documents Table
-------------------------------------------------------------

CREATE TABLE IF NOT EXISTS DIF.REPORT_INSTANCE_DOCUMENT
(
    ID                     INT(10)      NOT NULL AUTO_INCREMENT COMMENT 'Unique identifier for PK',
    REPORT_INSTANCE_ID     INT(10)      NOT NULL COMMENT 'The parent report ID',
    DESCRIPTION            VARCHAR(500) NOT NULL COMMENT 'Document description',
    DOCUMENT_REPOSITORY_ID BIGINT       NOT NULL COMMENT 'Identifier in the Document repository table',
    PUBLIC_VISIBILITY      VARCHAR(500) NOT NULL COMMENT 'Defines visibility for the document',
    PRIMARY KEY (`ID`),
    CONSTRAINT `REPORT_INST_DOC_FK`
        FOREIGN KEY (`REPORT_INSTANCE_ID`)
            REFERENCES DIF.REPORT_INSTANCE (`ID`)
            ON DELETE CASCADE
            ON UPDATE NO ACTION
) ENGINE = INNODB
  DEFAULT CHARSET = UTF8
  COLLATE = UTF8_BIN$$



DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
    DECLARE TOTAL INT;
    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'EVENT'
      AND COLUMN_NAME = 'PAY_LOAD';
    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`EVENT`
            ADD COLUMN `PAY_LOAD` LONGTEXT;
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$



DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
    DECLARE TOTAL INT;
    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'EVENT'
      AND COLUMN_NAME = 'ATTEMPTS_TO_GIVE_UP';
    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`EVENT`
            ADD COLUMN `ATTEMPTS_TO_GIVE_UP` INT(3);
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$