/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.configurations;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import pt.digitalis.dif.controller.interfaces.IModelManager;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.IConfigurationsService;
import pt.digitalis.dif.dem.managers.impl.model.IServersService;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigNode;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigServerSet;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigSet;
import pt.digitalis.dif.dem.managers.impl.model.data.Configuration;
import pt.digitalis.dif.dem.managers.impl.model.data.Server;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.model.dataset.SortMode;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.startup.DIFGeneralConfigurationParameters;
import pt.digitalis.dif.startup.DIFInitializer;
import pt.digitalis.dif.startup.DIFStartupConfiguration;
import pt.digitalis.dif.utils.logging.AuditContext;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.utils.logging.LoggingConfiguration;
import pt.digitalis.dif.utils.logging.performance.PerformanceLoggerConfiguration;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.AbstractConfigurationsImpl;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.ConfigurationsPreferencesImpl;
import pt.digitalis.utils.config.IConfigurations;

public class ConfigurationsDatabaseImpl
extends AbstractConfigurationsImpl {
    private static String serverUID = null;
    private IConfigurationsService configurationsService = null;

    public ConfigurationsDatabaseImpl() {
        this(true);
    }

    public ConfigurationsDatabaseImpl(boolean ignoreTestConfigurations) {
        super(ignoreTestConfigurations);
    }

    private Properties convertRecordToProperties(List<Configuration> configProps) throws ConfigurationException {
        Properties props = new Properties();
        for (Configuration config : configProps) {
            String value = config.getValue();
            if (value == null) {
                value = config.getValueXL();
            }
            if (!props.containsKey(config.getKey())) {
                props.setProperty(config.getKey(), StringUtils.nvl((String)value, (String)""));
                continue;
            }
            throw new ConfigurationException("Convertion from database to properties detected duplicate key '" + config.getKey() + "'. Please rectify so that there is only one key in node id " + config.getConfigNode().getId().shortValue());
        }
        return props;
    }

    private Properties convertRecordToProperties(Set<Configuration> configurations) throws ConfigurationException {
        return this.convertRecordToProperties(new ArrayList<Configuration>(configurations));
    }

    protected IConfigurationsService getDB() {
        this.initializeDBAuditContext();
        if (this.configurationsService == null) {
            this.configurationsService = (IConfigurationsService)DIFIoCRegistry.getRegistry().getImplementation(IConfigurationsService.class);
        }
        return this.configurationsService;
    }

    private synchronized ConfigNode getOrCreateNode(String nodePath) throws DataSetException {
        this.initializeDBAuditContext();
        boolean wasActive = DIFRepositoryFactory.openTransaction();
        ConfigNode node = (ConfigNode)this.getDB().getConfigNodeDataSet().query().equals(ConfigNode.FK().configSet().configServerSets().SERVERUID(), this.getServerUID()).sortBy("id", SortMode.ASCENDING).equals("nodePath", nodePath).singleValue();
        if (node != null) {
            if (!wasActive) {
                DIFRepositoryFactory.getSession().getTransaction().commit();
            }
            return node;
        }
        List serverSets = this.getDB().getConfigServerSetDataSet().query().equals("serverUid", this.getServerUID()).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)ConfigServerSet.FK().configSet(), JoinType.NORMAL).sortBy("id", SortMode.ASCENDING).asList();
        ConfigServerSet serverSet = null;
        if (serverSets == null || serverSets.isEmpty()) {
            ConfigSet newConfigSet = new ConfigSet();
            newConfigSet.setName(this.getServerUID());
            newConfigSet.setDescription("Auto generated Configurations Set for: " + this.getServerUID());
            newConfigSet = (ConfigSet)this.getDB().getConfigSetDataSet().insert((IBeanAttributes)newConfigSet);
            serverSet = new ConfigServerSet();
            serverSet.setConfigSet(newConfigSet);
            serverSet.setServerUid(this.getServerUID());
            serverSet = (ConfigServerSet)this.getDB().getConfigServerSetDataSet().insert((IBeanAttributes)serverSet);
        } else if (serverSets.size() > 1) {
            for (ConfigServerSet currentServerSet : serverSets) {
                if (!currentServerSet.getConfigSet().getName().equals(this.getServerUID())) continue;
                serverSet = currentServerSet;
                break;
            }
            if (serverSet == null) {
                serverSet = (ConfigServerSet)serverSets.get(0);
            }
        } else {
            serverSet = (ConfigServerSet)serverSets.get(0);
        }
        ConfigNode newNode = new ConfigNode();
        newNode.setConfigSet(serverSet.getConfigSet());
        newNode.setNodePath(nodePath);
        newNode = (ConfigNode)this.getDB().getConfigNodeDataSet().insert((IBeanAttributes)newNode);
        if (!wasActive) {
            DIFRepositoryFactory.getSession().getTransaction().commit();
        }
        return newNode;
    }

    public String getServerUID() {
        return serverUID;
    }

    /*
     * Unable to fully structure code
     */
    public void initialize(boolean upgradeModelManager) throws ConfigurationException {
        block13: {
            this.initializeDBAuditContext();
            currentConfigurationModule = IConfigurations.class.getCanonicalName();
            oldConfigurationsImpl = null;
            migrateConfigs = false;
            if (upgradeModelManager && StringUtils.isBlank((String)DIFStartupConfiguration.getModulesProps().getProperty(currentConfigurationModule))) {
                oldConfigurationsImpl = new ConfigurationsPreferencesImpl();
                prefsDBConfig = oldConfigurationsImpl.readConfiguration("dif2", "Model/" + DIFRepositoryFactory.SESSION_FACTORY_NAME);
                DIFStartupConfiguration.setDbProps((Properties)prefsDBConfig);
                migrateConfigs = true;
            }
            difModelManager = (IModelManager)DIFIoCRegistry.getRegistry().getImplementation(IModelManager.class, "DIF");
            try {
                if (upgradeModelManager) {
                    DIFInitializer.processModelManager((IModelManager)difModelManager);
                }
                HibernateUtil.getSessionFactory((String)DIFRepositoryFactory.SESSION_FACTORY_NAME, null, (Properties)DIFStartupConfiguration.getDbProps());
            }
            catch (InternalFrameworkException e) {
                throw new ConfigurationException((Throwable)e);
            }
            serverUIDtemp = DIFStartupConfiguration.getMachineIDForConfigurations() + "|" + AbstractConfigurationsImpl.generalConfigurationPrefix;
            if (DIFStartupConfiguration.getReplicaMode().booleanValue()) {
                serverReplicaUIDCalc = DIFStartupConfiguration.getReplicaModeAlternateMachineIDForConfigurations();
                if (StringUtils.isBlank((String)serverReplicaUIDCalc) || "<none>".equals(serverReplicaUIDCalc)) {
                    try {
                        configsService = (IConfigurationsService)DIFIoCRegistry.getRegistry().getImplementation(IConfigurationsService.class);
                        v0 = hasConfigurationsForReplicaInDB = configsService.getConfigServerSetDataSet().query().equals("serverUid", serverUIDtemp).count() > 0L;
                        if (hasConfigurationsForReplicaInDB) ** GOTO lbl40
                        DIFLogger.getLogger().info((Object)"ReplicaMode: No parameters found in DB");
                        productionServer = (Server)((IServersService)DIFIoCRegistry.getRegistry().getImplementation(IServersService.class)).getServerDataSet().query().like("contextRoot", AbstractConfigurationsImpl.generalConfigurationPrefix).notEquals("machineServerUid", DIFStartupConfiguration.getMachineIDForConfigurations()).singleValue();
                        if (productionServer == null) ** GOTO lbl40
                        DIFLogger.getLogger().info((Object)("ReplicaMode: Found an alternative server for \"" + AbstractConfigurationsImpl.generalConfigurationPrefix + "\""));
                        serverUIDtemp = productionServer.getMachineServerUid() + "|" + AbstractConfigurationsImpl.generalConfigurationPrefix;
                        DIFStartupConfiguration.setReplicaModeAlternateMachineIDForConfigurations((String)productionServer.getMachineServerUid());
                        DIFStartupConfiguration.updateConfig();
                        DIFLogger.getLogger().info((Object)("ReplicaMode: Using alternative (production?) server for configurations \"" + productionServer.getMachineServerUid() + "\""));
                    }
                    catch (DataSetException e) {
                        throw new ConfigurationException((Throwable)e);
                    }
                } else {
                    serverUIDtemp = serverReplicaUIDCalc + "|" + AbstractConfigurationsImpl.generalConfigurationPrefix;
                }
            }
lbl40:
            // 6 sources

            ConfigurationsDatabaseImpl.serverUID = serverUIDtemp;
            if (!upgradeModelManager) break block13;
            if (!migrateConfigs || oldConfigurationsImpl == null) ** GOTO lbl76
            configurationsMigrated = this.migrateFromOtherImplementation((IConfigurations)oldConfigurationsImpl, true);
            if (configurationsMigrated) {
                DIFLogger.getLogger().info((Object)"Activating Database Configurations module...");
                DIFStartupConfiguration.getModulesProps().setProperty(currentConfigurationModule, "Database");
                DIFStartupConfiguration.updateConfig();
            } else {
                buffer = new StringBuffer();
                buffer.append("\n\n");
                buffer.append("Database Configurations module was not definitely activated.\n");
                buffer.append("Migration was not successful!\n");
                buffer.append("Check the configurations database content for the migration process to run.");
                buffer.append("\n\n");
                buffer.append("Possible solutions:\n");
                buffer.append("1) Create a new server from scratch => Change machine configuration prefix in the startup file \"dif2.properties\", property \"machineIDForConfigurations\" to a non-existing one;\n");
                buffer.append("2) Reset database configurations => Delete previous entries from the configurations database for prefix \"" + this.getServerUID() + "\";\n");
                buffer.append("3) Use existing database configurations, do not migrate => In the startup file \"dif2.properties, set property '" + AbstractConfigurationsImpl.generalConfigurationPrefix + ".module." + IConfigurations.class.getCanonicalName() + "=Database';\n");
                buffer.append("4) Keep using previous legacy PreferencesAPI, do not migrate => In the startup file \"dif2.properties, set property '" + AbstractConfigurationsImpl.generalConfigurationPrefix + ".module." + IConfigurations.class.getCanonicalName() + "=preferences'.\n");
                buffer.append("\n\nFatal error! DIF will terminate. Please choose the solution from the options above!\n\n.");
                DIFLogger.getLogger().fatal((Object)buffer.toString());
                throw new ConfigurationException("Database Configurations module was not definetly activated. Migration was not successful!");
lbl76:
                // 1 sources

                try {
                    this.processServerUIDPendingNameChange();
                }
                catch (DataSetException e) {
                    throw new ConfigurationException((Throwable)e);
                }
            }
        }
        LoggingConfiguration.getInstance();
        PerformanceLoggerConfiguration.getInstance();
    }

    private void initializeDBAuditContext() {
        if (!AuditContext.hasContextDefined()) {
            AuditContext.setProcessNameForCurrentThread((String)"DBConfigurations");
            AuditContext.setUserForCurrentThread((String)"\u00abDIF\u00bb");
        }
    }

    public boolean isPersistentRepositoryEmpty() throws ConfigurationException {
        this.initializeDBAuditContext();
        try {
            return this.getDB().getConfigurationDataSet().query().equals(Configuration.FK().configNode().configSet().configServerSets().SERVERUID(), this.getServerUID()).count() == 0L;
        }
        catch (DataSetException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private void processServerUIDPendingNameChange() throws DataSetException {
        if (DIFStartupConfiguration.hasMachineIDNameChangePending()) {
            String oldID = DIFStartupConfiguration.getMachineIDForConfigurations() + "|" + AbstractConfigurationsImpl.generalConfigurationPrefix;
            String newID = DIFStartupConfiguration.getNewMachineIDForConfigurationsToApply() + "|" + AbstractConfigurationsImpl.generalConfigurationPrefix;
            boolean wasActive = DIFRepositoryFactory.openTransaction();
            boolean newServerUIDExists = ((IConfigurationsService)DIFIoCRegistry.getRegistry().getImplementation(IConfigurationsService.class)).getConfigServerSetDataSet().query().equals("serverUid", newID).count() > 0L;
            DIFLogger.getLogger().info((Object)("Changing machineServerUID for existing configurations on database from \"" + oldID + "\" to \"" + newID + "\"..."));
            if (newServerUIDExists) {
                DIFLogger.getLogger().warn((Object)("Configurations for \"" + newID + "\" already exist!"));
                DIFLogger.getLogger().warn((Object)("Associated the current server to the existing configurations under \"" + newID + "\"."));
                DIFLogger.getLogger().warn((Object)("Kept the old configurations for recovery purposes (or another server might be using them) under \"" + oldID + "\"."));
            } else {
                StringBuffer hqlBuffer = new StringBuffer();
                hqlBuffer.append("update " + ConfigServerSet.class.getSimpleName());
                hqlBuffer.append("   set serverUid = '" + newID + "'");
                hqlBuffer.append(" where serverUid = '" + oldID + "'");
                DIFRepositoryFactory.getSession().createQuery(hqlBuffer.toString()).executeUpdate();
                DIFLogger.getLogger().info((Object)("Configurations changed to \"" + newID + "\"..."));
            }
            if (!wasActive) {
                DIFRepositoryFactory.getSession().getTransaction().commit();
            }
            serverUID = newID;
        }
    }

    public Map<String, Properties> readAllConfigurations(String configID, String sectionID) throws ConfigurationException {
        this.initializeDBAuditContext();
        String nodePath = configID;
        if (StringUtils.isNotBlank((String)sectionID)) {
            nodePath = nodePath + "/" + sectionID;
        }
        LinkedHashMap<String, Properties> configs = new LinkedHashMap<String, Properties>();
        try {
            Query nodesQuery = this.getDB().getConfigNodeDataSet().query().equals(ConfigNode.FK().configSet().configServerSets().SERVERUID(), this.getServerUID()).like("nodePath", nodePath + "%").addJoin((AbstractBeanRelationsAttributes.AbstractRelations)ConfigNode.FK().configurations(), JoinType.LEFT_OUTER_JOIN).sortBy("nodePath", SortMode.ASCENDING);
            nodesQuery.setDistinctEntities(true);
            List nodes = nodesQuery.asList();
            for (ConfigNode node : nodes) {
                String path = node.getNodePath();
                if (!node.getNodePath().equals(nodePath)) {
                    path = node.getNodePath().substring(nodePath.length() + 1);
                }
                configs.put(path, this.convertRecordToProperties(node.getConfigurations()));
            }
            return configs;
        }
        catch (DataSetException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public <T> Map<String, T> readAllConfigurations(String configID, String sectionID, Class<T> clazz) throws ConfigurationException {
        this.initializeDBAuditContext();
        String nodePath = configID;
        if (StringUtils.isNotBlank((String)sectionID)) {
            nodePath = nodePath + "/" + sectionID;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Query nodesQuery = this.getDB().getConfigNodeDataSet().query().equals(ConfigNode.FK().configSet().configServerSets().SERVERUID(), this.getServerUID()).like("nodePath", nodePath + "%").sortBy("nodePath", SortMode.ASCENDING);
            List nodes = nodesQuery.asList();
            for (ConfigNode node : nodes) {
                String path = node.getNodePath();
                if (!node.getNodePath().equals(nodePath)) {
                    path = node.getNodePath().substring(nodePath.length() + 1);
                }
                result.put(path, this.readConfiguration(node.getNodePath(), null, clazz));
            }
            return result;
        }
        catch (DataSetException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public Properties readConfiguration(String configID, String sectionID) throws ConfigurationException {
        this.initializeDBAuditContext();
        String nodePath = configID + (StringUtils.isBlank((String)sectionID) ? "" : "/" + sectionID);
        DIFLogger.getLogger().debug((Object)("Reading configuration point: " + nodePath + "..."));
        try {
            List configProps = this.getDB().getConfigurationDataSet().query().equals(Configuration.FK().configNode().configSet().configServerSets().SERVERUID(), this.getServerUID()).equals(Configuration.FK().configNode().NODEPATH(), nodePath).sortBy("id", SortMode.ASCENDING).asList();
            return this.convertRecordToProperties(configProps);
        }
        catch (DataSetException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public boolean removeConfiguration(String configID, String sectionID) throws ConfigurationException {
        String nodePath = configID + (StringUtils.isBlank((String)sectionID) ? "" : "/" + sectionID);
        DIFLogger.getLogger().debug((Object)("Removing configuration point: " + nodePath + "..."));
        this.initializeDBAuditContext();
        boolean wasActive = DIFRepositoryFactory.openTransaction();
        try {
            List listSets = this.getDB().getConfigSetDataSet().query().equals(ConfigSet.FK().configServerSets().SERVERUID(), this.getServerUID()).asList();
            if (listSets != null && !listSets.isEmpty()) {
                StringBuffer hqlBuffer = new StringBuffer();
                hqlBuffer.append("delete from " + Configuration.class.getSimpleName());
                hqlBuffer.append(" where " + Configuration.FK().configNode().ID() + " in (select " + "id" + " from " + ConfigNode.class.getSimpleName() + " where " + ConfigNode.FK().configSet().ID() + " in (" + CollectionUtils.listToCommaSeparatedString((List)listSets, (String)"id") + ") and " + "nodePath" + " = '" + nodePath + "' )");
                DIFRepositoryFactory.getSession().createQuery(hqlBuffer.toString()).executeUpdate();
            }
            if (!wasActive) {
                DIFRepositoryFactory.getSession().getTransaction().commit();
            }
            return true;
        }
        catch (DataSetException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public boolean removeConfigurationParameter(String configID, String sectionID, String paramName) throws ConfigurationException {
        String nodePath = configID + (StringUtils.isBlank((String)sectionID) ? "" : "/" + sectionID);
        DIFLogger.getLogger().debug((Object)("Removing configuration point: " + nodePath + "..."));
        this.initializeDBAuditContext();
        boolean wasActive = DIFRepositoryFactory.openTransaction();
        try {
            List listSets = this.getDB().getConfigSetDataSet().query().equals(ConfigSet.FK().configServerSets().SERVERUID(), this.getServerUID()).asList();
            if (listSets != null && !listSets.isEmpty()) {
                StringBuffer hqlBuffer = new StringBuffer();
                hqlBuffer.append("delete from " + Configuration.class.getSimpleName());
                hqlBuffer.append(" where " + Configuration.FK().configNode().ID() + " in (select " + "id" + " from " + ConfigNode.class.getSimpleName() + " where " + ConfigNode.FK().configSet().ID() + " in (" + CollectionUtils.listToCommaSeparatedString((List)listSets, (String)"id") + ") and " + "nodePath" + " = '" + nodePath + "' and " + "key" + " = '" + paramName + "' )");
                DIFRepositoryFactory.getSession().createQuery(hqlBuffer.toString()).executeUpdate();
            }
            if (!wasActive) {
                DIFRepositoryFactory.getSession().getTransaction().commit();
            }
            return true;
        }
        catch (DataSetException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public synchronized boolean writeConfiguration(String configID, String sectionID, Properties values) throws ConfigurationException {
        this.initializeDBAuditContext();
        if (values != null && !values.isEmpty()) {
            Properties originalValues = new Properties();
            originalValues.putAll((Map<?, ?>)values);
            String nodePath = configID + (StringUtils.isBlank((String)sectionID) ? "" : "/" + sectionID);
            DIFLogger.getLogger().debug((Object)("Writing configuration point: " + nodePath + "..."));
            boolean wasactive = DIFRepositoryFactory.openTransaction();
            HibernateDataSet<Configuration> configDS = this.getDB().getConfigurationDataSet();
            try {
                List configProps = configDS.query().equals(Configuration.FK().configNode().configSet().configServerSets().SERVERUID(), this.getServerUID()).equals(Configuration.FK().configNode().NODEPATH(), nodePath).sortBy("id", SortMode.ASCENDING).asList();
                for (Configuration configurationInDB : configProps) {
                    if (!values.containsKey(configurationInDB.getKey())) continue;
                    String propertyValue = values.getProperty(configurationInDB.getKey());
                    String value = null;
                    String valueXL = null;
                    if (propertyValue != null && propertyValue.length() > 4000) {
                        valueXL = propertyValue;
                    } else {
                        value = propertyValue;
                    }
                    configurationInDB.setValue(value);
                    configurationInDB.setValueXL(valueXL);
                    configDS.update((IBeanAttributes)configurationInDB);
                    values.remove(configurationInDB.getKey());
                }
                if (!values.isEmpty()) {
                    ConfigNode node = this.getOrCreateNode(nodePath);
                    for (Object propertyKey : values.keySet()) {
                        String propertyValue = values.getProperty(propertyKey.toString());
                        String value = null;
                        String valueXL = null;
                        if (propertyValue != null && propertyValue.length() > 4000) {
                            valueXL = propertyValue;
                        } else {
                            value = propertyValue;
                        }
                        Configuration newConfigurationDB = new Configuration();
                        newConfigurationDB.setConfigNode(node);
                        newConfigurationDB.setKey(propertyKey.toString());
                        newConfigurationDB.setValue(value);
                        newConfigurationDB.setValueXL(valueXL);
                        newConfigurationDB = (Configuration)configDS.insert((IBeanAttributes)newConfigurationDB);
                    }
                }
                if (!wasactive) {
                    DIFRepositoryFactory.getSession().getTransaction().commit();
                }
                if (DIFStartupConfiguration.getReplicaMode().booleanValue() && DIFGeneralConfigurationParameters.getInstance().getKeepPrefsFileWhenInReplicaMode().booleanValue()) {
                    Properties replicaProps = new Properties();
                    InputStream replicaConfigsFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("replica.prefs");
                    try {
                        if (replicaConfigsFile != null) {
                            replicaProps.load(replicaConfigsFile);
                        }
                        for (Object key : originalValues.keySet()) {
                            replicaProps.put(nodePath + "." + key.toString(), originalValues.get(key));
                        }
                        String difPropertiesFilePath = DIFStartupConfiguration.getFileInConfigPath((String)"replica.prefs");
                        DIFLogger.getLogger().debug((Object)("Saving configuration node \"" + nodePath + "\" in replica preferences file \"" + "replica.prefs" + "\"..."));
                        FileOutputStream outStream = new FileOutputStream(difPropertiesFilePath);
                        replicaProps.store(outStream, "DIF2 Replica configurations override file");
                    }
                    catch (IOException e) {
                        new BusinessException("Error saving changed preferences to \"replica.prefs\"", (Exception)e).addToExceptionContext("node", (Object)nodePath).addToExceptionContext("prefs", (Object)values).log(LogLevel.ERROR);
                        e.printStackTrace();
                    }
                }
            }
            catch (DataSetException e) {
                new BusinessException("Errors saving configurations", (Exception)((Object)e)).addToExceptionContext("NodePath", (Object)nodePath).addToExceptionContext("Properties", (Object)values).log(LogLevel.ERROR);
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

