/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonBeanProcessor;
import pt.digitalis.dif.controller.interfaces.IModelManager;
import pt.digitalis.dif.dem.interfaces.ICustomFormDefinition;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.managers.IDEMManager;
import pt.digitalis.dif.dem.managers.impl.CustomFormManagerDummyImpl;
import pt.digitalis.dif.dem.managers.impl.DIFRepositoryDBModelManager;
import pt.digitalis.dif.dem.managers.impl.model.IPersistentFormsService;
import pt.digitalis.dif.dem.managers.impl.model.data.PersistentForm;
import pt.digitalis.dif.dem.objects.CustomFormDefinition;
import pt.digitalis.dif.dem.objects.FeatureState;
import pt.digitalis.dif.dem.objects.FormFieldCustomization;
import pt.digitalis.dif.dem.objects.messages.Message;
import pt.digitalis.dif.dem.objects.messages.MessageList;
import pt.digitalis.dif.dem.objects.parameters.IParameter;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.exception.objects.ParameterException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.common.collections.CaseInsentiveArrayList;
import pt.digitalis.utils.config.ConfigurationException;

public class CustomFormManagerDBImpl
extends CustomFormManagerDummyImpl {
    static ConcurrentHashMap<String, Long> persistentIDForFormConfig = new ConcurrentHashMap();
    private boolean databasePersistent = false;

    public CustomFormManagerDBImpl() throws ConfigurationException {
        IModelManager difDatabaseRepositoryImpl = (IModelManager)DIFIoCRegistry.getRegistry().getImplementation(IModelManager.class, DIFRepositoryDBModelManager.MODEL_ID);
        try {
            this.databasePersistent = difDatabaseRepositoryImpl.isEnabled();
        }
        catch (InternalFrameworkException e) {
            this.databasePersistent = false;
        }
    }

    public CustomFormDefinition getConfiguration(String stageID, String formName, String businessConfigurationID) {
        CustomFormDefinition customFormDef;
        block25: {
            stageID = stageID.toLowerCase();
            formName = formName.toLowerCase();
            if (StringUtils.isBlank((String)businessConfigurationID)) {
                businessConfigurationID = null;
            }
            customFormDef = (CustomFormDefinition)super.getConfiguration(stageID, formName, businessConfigurationID);
            if (this.databasePersistent) {
                String persistentConfigID = stageID + ":" + formName + (businessConfigurationID == null ? "" : ":" + businessConfigurationID);
                try {
                    PersistentForm persistentForm = null;
                    IPersistentFormsService dbService = (IPersistentFormsService)DIFIoCRegistry.getRegistry().getImplementation(IPersistentFormsService.class);
                    if (persistentIDForFormConfig.containsKey(persistentConfigID)) {
                        persistentForm = (PersistentForm)dbService.getPersistentFormDataSet().get((Serializable)persistentIDForFormConfig.get(persistentConfigID));
                    }
                    if (persistentForm == null && (persistentForm = (PersistentForm)dbService.getPersistentFormDataSet().query().equals("formId", persistentConfigID).singleValue()) != null) {
                        persistentIDForFormConfig.put(persistentConfigID, persistentForm.getId());
                    }
                    if (persistentForm == null) break block25;
                    if (StringUtils.isNotBlank((String)persistentForm.getDisabledFields())) {
                        customFormDef.setExcludedParameters(new CaseInsentiveArrayList(Arrays.asList(persistentForm.getDisabledFields().split(","))));
                    }
                    HashMap<String, FormFieldCustomization> customizations = new HashMap<String, FormFieldCustomization>();
                    if (StringUtils.isNotBlank((String)persistentForm.getFieldDefs())) {
                        JSONObject fieldCustomizationsJSONObj = (JSONObject)JSONSerializer.toJSON((Object)persistentForm.getFieldDefs());
                        for (Object fieldIDObj : fieldCustomizationsJSONObj.keySet()) {
                            String fieldID = fieldIDObj.toString();
                            FormFieldCustomization customization = new FormFieldCustomization(fieldID);
                            JSONObject customizationJSONObj = fieldCustomizationsJSONObj.getJSONObject(fieldID);
                            if (customizationJSONObj.containsKey((Object)"mandatory")) {
                                FeatureState mandatory = FeatureState.valueOf((String)customizationJSONObj.getString("mandatory"));
                                customization.setMandatory(mandatory);
                            }
                            if (customizationJSONObj.containsKey((Object)"readonly")) {
                                FeatureState readonly = FeatureState.valueOf((String)customizationJSONObj.getString("readonly"));
                                customization.setReadOnly(readonly);
                            }
                            if (customizationJSONObj.containsKey((Object)"messages")) {
                                JSONObject messagesJSONObj = customizationJSONObj.getJSONObject("messages");
                                MessageList messages = new MessageList();
                                for (Object languageIDObj : messagesJSONObj.keySet()) {
                                    String languageID = languageIDObj.toString();
                                    Map messagesMap = (Map)JSONObject.toBean((JSONObject)messagesJSONObj.getJSONObject(languageID), Map.class);
                                    for (Map.Entry message : messagesMap.entrySet()) {
                                        Class<?> messageValueClass;
                                        if (message.getValue() == null || (messageValueClass = message.getValue().getClass()) == JSONNull.class || !StringUtils.isNotBlank((String)message.getValue().toString())) continue;
                                        messages.addMessageTranslation((String)message.getKey(), languageID, new Message(message.getValue().toString()));
                                    }
                                }
                                customization.setMessages(messages);
                            }
                            customizations.put(fieldID, customization);
                        }
                    }
                    customFormDef.setCustomizedParameters(customizations);
                    IDEMManager demManager = (IDEMManager)DIFIoCRegistry.getRegistry().getImplementation(IDEMManager.class);
                    IStage stage = demManager.getStage(stageID);
                    try {
                        if (stage != null) {
                            for (IParameter parameter : stage.getParameters().getStageParameters().getParameters().values()) {
                                if (parameter.isFormConfigurable()) {
                                    FormFieldCustomization fieldCustomization = (FormFieldCustomization)customFormDef.getCustomizedParameters().get(parameter.getId());
                                    if (fieldCustomization == null) {
                                        fieldCustomization = new FormFieldCustomization(parameter.getId());
                                    }
                                    if (!parameter.getFormConfigurableDefinition().isCanEditMandatory()) {
                                        fieldCustomization.setMandatory(parameter.isRequired() ? FeatureState.ON : FeatureState.OFF);
                                        if (customFormDef.getExcludedParameters() != null) {
                                            customFormDef.getExcludedParameters().removeAll(Collections.singleton(parameter.getId()));
                                        }
                                    }
                                    if (!parameter.getFormConfigurableDefinition().isCanEditReadOnly()) {
                                        fieldCustomization.setReadOnly(FeatureState.OFF);
                                        if (customFormDef.getExcludedParameters() != null) {
                                            customFormDef.getExcludedParameters().removeAll(Collections.singleton(parameter.getId()));
                                        }
                                    }
                                    fieldCustomization.setCanEditText(parameter.getFormConfigurableDefinition().isCanEditText());
                                    if (!fieldCustomization.isCanEditText()) {
                                        fieldCustomization.setMessages(null);
                                    }
                                    customFormDef.getCustomizedParameters().put(parameter.getId(), fieldCustomization);
                                    continue;
                                }
                                customFormDef.getCustomizedParameters().remove(parameter.getId());
                            }
                        }
                    }
                    catch (ParameterException e) {
                        e.printStackTrace();
                    }
                }
                catch (DataSetException e) {
                    e.printStackTrace();
                }
            }
        }
        return customFormDef;
    }

    private JsonConfig getJSONConfigForFormFieldCustomizationSupport() {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerJsonBeanProcessor(FormFieldCustomization.class, new JsonBeanProcessor(){

            public JSONObject processBean(Object bean, JsonConfig jsonConfig) {
                if (!(bean instanceof FormFieldCustomization)) {
                    return new JSONObject(true);
                }
                FormFieldCustomization custom = (FormFieldCustomization)bean;
                JSONObject result = new JSONObject();
                if (custom.getMandatory() != FeatureState.DEFAULT) {
                    result.element("mandatory", (Object)custom.getMandatory());
                }
                if (custom.getReadOnly() != FeatureState.DEFAULT) {
                    result.element("readonly", (Object)custom.getReadOnly());
                }
                if (custom.getMessages() != null && !custom.getMessages().getMessageIDs().isEmpty()) {
                    HashMap messagesByLanguage = new HashMap();
                    for (String messageID : custom.getMessages().getMessageIDs()) {
                        for (String languageID : custom.getMessages().getMessageTranslations(messageID).getTranslations().keySet()) {
                            Message message = (Message)custom.getMessages().getMessageTranslations(messageID).getTranslations().get(languageID);
                            if (message == null || !StringUtils.isNotBlank((String)message.getMessage())) continue;
                            if (!messagesByLanguage.containsKey(languageID)) {
                                messagesByLanguage.put(languageID, new HashMap());
                            }
                            ((Map)messagesByLanguage.get(languageID)).put(messageID, message.getMessage());
                        }
                    }
                    result.element("messages", messagesByLanguage);
                }
                return result;
            }
        });
        return jsonConfig;
    }

    public void updateConfiguration(ICustomFormDefinition definition) {
        block7: {
            persistentIDForFormConfig.clear();
            if (this.databasePersistent) {
                String persistentConfigID = definition.getStageID() + ":" + definition.getFormName() + (definition.getBusinessConfigurationID() == null ? "" : ":" + definition.getBusinessConfigurationID());
                IPersistentFormsService dbService = (IPersistentFormsService)DIFIoCRegistry.getRegistry().getImplementation(IPersistentFormsService.class);
                try {
                    PersistentForm persistentForm = (PersistentForm)dbService.getPersistentFormDataSet().query().equals("formId", persistentConfigID).singleValue();
                    if (persistentForm == null) {
                        persistentForm = new PersistentForm();
                        persistentForm.setFormId(persistentConfigID);
                    }
                    persistentForm.setDisabledFields(CollectionUtils.listToCommaSeparatedString((List)definition.getExcludedParameters()));
                    if (!definition.getCustomizedParameters().isEmpty()) {
                        String fieldDefs = JSONObject.fromObject((Object)definition.getCustomizedParameters(), (JsonConfig)this.getJSONConfigForFormFieldCustomizationSupport()).toString();
                        persistentForm.setFieldDefs(fieldDefs);
                    }
                    if (persistentForm.getId() == null) {
                        dbService.getPersistentFormDataSet().insert((IBeanAttributes)persistentForm);
                        break block7;
                    }
                    dbService.getPersistentFormDataSet().update((IBeanAttributes)persistentForm);
                }
                catch (DataSetException e) {
                    e.printStackTrace();
                }
            } else {
                super.updateConfiguration(definition);
            }
        }
    }
}

