/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.users.preferences;

import java.util.List;
import pt.digitalis.dif.controller.security.managers.IUserPreferencesManager;
import pt.digitalis.dif.dem.managers.impl.model.IUserPreferencesService;
import pt.digitalis.dif.dem.managers.impl.model.data.UserPreferences;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;
import pt.digitalis.utils.config.IConfigurations;

public class UserPreferencesManagerDBImpl
implements IUserPreferencesManager {
    static IUserPreferencesService userPreferencesService = (IUserPreferencesService)DIFIoCRegistry.getRegistry().getImplementation(IUserPreferencesService.class);
    private static String configID = null;

    public static String getConfigID() {
        if (configID == null) {
            IConfigurations configs = (IConfigurations)DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class);
            configID = configs.getGeneralPrefix();
        }
        return configID;
    }

    public CaseInsensitiveHashMap<Object> getUserPreferences(String userID) throws InternalFrameworkException {
        CaseInsensitiveHashMap result = new CaseInsensitiveHashMap();
        try {
            Query query = userPreferencesService.getUserPreferencesDataSet().query();
            query.equals(UserPreferences.FK().CONFIGID(), UserPreferencesManagerDBImpl.getConfigID());
            query.equals(UserPreferences.FK().USERID(), userID);
            List list = query.asList();
            for (UserPreferences userPref : list) {
                result.put(userPref.getAttributeKey(), (Object)userPref.getAttributeValue());
            }
        }
        catch (DataSetException e) {
            throw new InternalFrameworkException((Exception)((Object)e), null);
        }
        return result;
    }

    public void setUserPreferences(String userID, String key, Object parameterValue) throws InternalFrameworkException {
        try {
            Query query = userPreferencesService.getUserPreferencesDataSet().query();
            query.equals(UserPreferences.FK().CONFIGID(), UserPreferencesManagerDBImpl.getConfigID());
            query.equals(UserPreferences.FK().USERID(), userID);
            query.equals(UserPreferences.FK().ATTRIBUTEKEY(), key);
            UserPreferences userPref = (UserPreferences)query.singleValue();
            if (userPref == null) {
                userPref = new UserPreferences();
                userPref.setConfigId(UserPreferencesManagerDBImpl.getConfigID());
                userPref.setUserId(userID);
                userPref.setAttributeKey(key);
                userPref.setAttributeValue(StringUtils.toStringOrNull((Object)parameterValue));
                userPreferencesService.getUserPreferencesDataSet().insert((IBeanAttributes)userPref);
            } else {
                userPref.setAttributeValue(StringUtils.toStringOrNull((Object)parameterValue));
                userPreferencesService.getUserPreferencesDataSet().update((IBeanAttributes)userPref);
            }
        }
        catch (DataSetException e) {
            throw new InternalFrameworkException((Exception)((Object)e), null);
        }
    }
}

