/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.utils.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Date;
import pt.digitalis.dif.dem.managers.impl.model.IErrorLoggingService;
import pt.digitalis.dif.dem.managers.impl.model.data.ErrorLog;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.utils.logging.IErrorLogManager;
import pt.digitalis.dif.utils.logging.LoggingConfiguration;
import pt.digitalis.dif.utils.mail.MailSender;
import pt.digitalis.dif.utils.mail.MailType;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;

public class ErrorLogManagerDBImpl
implements IErrorLogManager {
    public void logError(String applicationName, String processName, Exception e) {
        String errorMessage = "";
        StringWriter errors = new StringWriter();
        e.printStackTrace(new PrintWriter(errors));
        errorMessage = errorMessage + "Exception: " + errors.toString() + "\n";
        this.logError(applicationName, processName, errorMessage);
    }

    public void logError(String applicationName, String processName, String errorDescription) {
        ErrorLog errorLog = new ErrorLog();
        errorLog.setProcessName(processName);
        errorLog.setErrorDescription(errorDescription);
        errorLog.setErroDate(new Timestamp(new Date().getTime()));
        errorLog.setAppName(applicationName);
        IErrorLoggingService errorLoggingService = (IErrorLoggingService)DIFIoCRegistry.getRegistry().getImplementation(IErrorLoggingService.class);
        try {
            errorLoggingService.getErrorLogDataSet().insert((IBeanAttributes)errorLog);
            if (!(StringUtils.isBlank((String)LoggingConfiguration.getInstance().getErrorLogEmailAddress()) || StringUtils.isBlank((String)LoggingConfiguration.getInstance().getErrorLogEmailBody()) || StringUtils.isBlank((String)LoggingConfiguration.getInstance().getErrorLogEmailSubject()))) {
                try {
                    MailSender.getInstance().sendEmail(MailType.PLAIN_TEXT, MailSender.getInstance().getConfiguration().getDefaultFromAddress(), LoggingConfiguration.getInstance().getErrorLogEmailAddress(), null, null, LoggingConfiguration.getInstance().getErrorLogEmailSubject(), LoggingConfiguration.getInstance().getErrorLogEmailBody().replace("${applicationName}", errorLog.getAppName()), null, null, null, true, false, null);
                }
                catch (Exception e) {
                    DIFLogger.getLogger().log(LogLevel.INFO, (Object)("Error sending Email in ErrorLogManager" + e));
                }
            }
        }
        catch (DataSetException e) {
            DIFLogger.getLogger().debug((Object)e);
        }
    }
}

