DELIMITER $$
set sql_mode = CONCAT('PIPES_AS_CONCAT,', @@sql_mode)$$

UPDATE DIF.INDICATOR I
    INNER JOIN DIF.REPORT_TEMPLATE RT
    INNER JOIN DIF.REPORT_TEMPLATE_AREA R
    INNER JOIN DIF.AREA A
    INNER JOIN DIF.MANAGER M
SET I.UNIQUE_ID = 'reportTemplate' || I.unique_id
WHERE R.INDICATOR_ID = I.ID
  AND RT.ID = R.REPORT_TEMPLATE_ID
  AND I.AREA_ID = A.ID
  AND M.ID = A.MANAGER_ID
  AND M.UNIQUE_ID LIKE 'reportTemplateIndicadors%'
  AND I.UNIQUE_ID NOT LIKE 'reportTemplate%';
$$

UPDATE DIF.INDICATOR I
    INNER JOIN DIF.REPORT_TEMPLATE RT
    INNER JOIN DIF.REPORT_INSTANCE RI
    INNER JOIN DIF.REPORT_INSTANCE_AREA R
    INNER JOIN DIF.AREA A
    INNER JOIN DIF.MANAGER M
SET I.UNIQUE_ID = 'reportInstance' || I.unique_id
WHERE R.INDICATOR_ID = I.ID
  AND RI.ID = R.REPORT_INSTANCE_ID
  AND RT.ID = RI.REPORT_TEMPLATE_ID
  AND I.AREA_ID = A.ID
  AND M.ID = A.MANAGER_ID
  AND M.UNIQUE_ID LIKE 'reportInstanceIndicadors%'
  AND I.UNIQUE_ID NOT LIKE 'reportInstance%';
$$