DELIMITER $$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
	DECLARE TOTAL INT;

	SELECT COUNT(*)
	INTO TOTAL
	FROM information_schema.COLUMNS c
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'T_ECOMMERCE_PAYMENTS' 
	AND COLUMN_NAME = 'ERROR_FRIENDLY_USER_MESSAGE'
    AND CHARACTER_MAXIMUM_LENGTH = 4000;

	IF TOTAL = 0 THEN
		ALTER TABLE `DIF`.`T_ECOMMERCE_PAYMENTS` MODIFY COLUMN `ERROR_FRIENDLY_USER_MESSAGE` VARCHAR(4000);
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

