DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS 
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'DATA_CONSENT'
  AND    COLUMN_NAME = 'BUSINESS_ID'
  AND    NULLABLE    = 'N';
      
  IF TOTAL > 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DATA_CONSENT MODIFY BUSINESS_ID NULL';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS 
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'DATA_CONSENT'
  AND    COLUMN_NAME = 'USER_ID'
  AND    NULLABLE    = 'N';
      
  IF TOTAL > 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DATA_CONSENT MODIFY USER_ID NULL';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'DATA_CONSENT'
  AND    CONSTRAINT_NAME = 'DATA_CONSENT_UID_UK';

  IF TOTAL > 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DATA_CONSENT DROP CONSTRAINT DATA_CONSENT_UID_UK';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS 
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_DATA_REQUEST'
  AND    COLUMN_NAME = 'USER_ID';
      
  IF TOTAL > 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_DATA_REQUEST RENAME COLUMN USER_ID TO DATA_CONSENT_USER_ID';
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_DATA_REQUEST MODIFY DATA_CONSENT_USER_ID NUMBER(10)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS 
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_DATA_REQUEST'
  AND    CONSTRAINT_NAME = 'FK_UDR_USER_DATA_CONSENT_USER';
      
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_DATA_REQUEST ADD CONSTRAINT FK_UDR_USER_DATA_CONSENT_USER FOREIGN KEY (DATA_CONSENT_USER_ID) REFERENCES DIF.DATA_CONSENT_USER (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM ALL_INDEXES
  WHERE OWNER = 'DIF'
  AND    TABLE_NAME = 'USER_DATA_REQUEST'
  AND INDEX_NAME = 'USER_DATA_REQUEST_USER_ID_IDX';
  
  IF TOTAL > 0 THEN
    EXECUTE IMMEDIATE 'DROP INDEX DIF.USER_DATA_REQUEST_USER_ID_IDX';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS 
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_DATA_REQUEST'
  AND    COLUMN_NAME = 'TITLE';
      
  IF TOTAL > 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_DATA_REQUEST DROP COLUMN TITLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS 
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_DATA_REQUEST'
  AND    COLUMN_NAME = 'BODY';
      
  IF TOTAL > 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_DATA_REQUEST DROP COLUMN BODY';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_USER_DATA_REQUEST_COM';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_USER_DATA_REQUEST_COM MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/