----DIF.CONVERSATION
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'CONVERSATION';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.CONVERSATION (' ||
                '  ID                           number  NOT NULL, ' ||
                '  DESCRIPTION                  varchar2(1000)  , ' ||
                '  BUSINESS_PROCESS_TYPE_ID     varchar2(300)  NOT NULL, ' ||
                '  BUSINESS_PROCESS_INSTANCE_ID varchar2(100)  NOT NULL, ' ||
                '  CREATION_DATE                date DEFAULT sysdate NOT NULL, ' ||
                '  CLOSE_DATE                   date  , ' ||
                '  IS_OPEN                      number(1) DEFAULT 0 NOT NULL ' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'CONVERSATION'
      AND CONSTRAINT_NAME = 'CONVERSATION_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONVERSATION
            ADD CONSTRAINT CONVERSATION_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_CONVERSATION';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_CONVERSATION MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

----DIF.CONVERSATION_MESSAGE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'CONVERSATION_MESSAGE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.CONVERSATION_MESSAGE ( ' ||
                '  ID                   number  NOT NULL, ' ||
                '  CONVERSATION_ID      number  NOT NULL, ' ||
                '  CREATION_DATE        date DEFAULT sysdate , ' ||
                '  MESSAGE              varchar2(500)  NOT NULL, ' ||
                '  DETAILS              clob  , ' ||
                '  FILE_TYPE            char(1)  , ' ||
                '  IS_PRIVATE           number(1) DEFAULT 0 NOT NULL, ' ||
                '  USER_ID              varchar2(300)  , ' ||
                '  USER_DESCRIPTION     varchar2(500)  , ' ||
                '  USER_BUSINESS_ID     varchar2(300)  , ' ||
                '  DOCUMENT_ID          number ' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'CONVERSATION_MESSAGE'
      AND CONSTRAINT_NAME = 'CONVERSATION_MESSAGE_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONVERSATION_MESSAGE
            ADD CONSTRAINT CONVERSATION_MESSAGE_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_CONVERSATION_MESSAGE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_CONVERSATION_MESSAGE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'CONVERSATION_MESSAGE'
      AND CONSTRAINT_NAME = 'CONVERSATION_MESSAGE_TYPE_CK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'ALTER TABLE DIF.CONVERSATION_MESSAGE ' ||
                'ADD CONSTRAINT CONVERSATION_MESSAGE_TYPE_CK ' ||
                'CHECK ( FILE_TYPE is null or FILE_TYPE in (''W'', ''E'', ''S'', ''A''))';
    END IF;
END;
/


DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'CONVERSATION_MESSAGE'
      AND CONSTRAINT_NAME = 'CONVERSATION_ID_FK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONVERSATION_MESSAGE ' ||
                          'ADD CONSTRAINT CONVERSATION_ID_FK FOREIGN KEY ( CONVERSATION_ID ) ' ||
                          'REFERENCES DIF.CONVERSATION( ID ) ON DELETE CASCADE';
    END IF;
END;
/


----DIF.FILE_TYPE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_TYPE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.FILE_TYPE (' ||
                '  ID                       number  NOT NULL, ' ||
                '  NAME                     varchar2(200)  NOT NULL, ' ||
                '  DESCRIPTION              varchar2(500)  , ' ||
                '  BUSINESS_PROCESS_TYPE_ID varchar2(300)  , ' ||
                '  MIME_TYPES               varchar2(200)  , ' ||
                '  MAX_FILE_SIZE            number ' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_TYPE'
      AND CONSTRAINT_NAME = 'FILE_TYPE_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_TYPE
            ADD CONSTRAINT FILE_TYPE_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_FILE_TYPE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_FILE_TYPE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/


----DIF.FILE_BUNDLE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.FILE_BUNDLE ( ' ||
                '  ID                           number  NOT NULL, ' ||
                '  DESCRIPTION                  varchar2(500)  , ' ||
                '  BUSINESS_PROCESS_TYPE_ID     varchar2(300)  NOT NULL, ' ||
                '  BUSINESS_PROCESS_INSTANCE_ID varchar2(100)  NOT NULL, ' ||
                '  CREATION_DATE                date DEFAULT sysdate NOT NULL, ' ||
                '  IS_OPEN                      number(1) DEFAULT 1 NOT NULL, ' ||
                '  CLOSE_DATE                   date ' ||
                ') ';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND CONSTRAINT_NAME = 'FILE_BUNDLE_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE
            ADD CONSTRAINT FILE_BUNDLE_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_FILE_BUNDLE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_FILE_BUNDLE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/


----DIF.FILE_BUNDLE_FILE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.FILE_BUNDLE_FILE (' ||
                '  ID                        number  NOT NULL, ' ||
                '  FILE_BUNDLE_ID            number  NOT NULL, ' ||
                '  TITLE                     varchar2(1000)  NOT NULL, ' ||
                '  DESCRIPTION               varchar2(4000)  , ' ||
                '  TYPE_ID                   number  , ' ||
                '  DOCUMENT_ID               number  NOT NULL, ' ||
                '  IS_PRIVATE                number(1) DEFAULT 0 NOT NULL, ' ||
                '  IS_VALID                  number(1) DEFAULT 0 NOT NULL, ' ||
                '  UPLOAD_USER_ID            varchar2(300)  , ' ||
                '  UPLOAD_DATE               date DEFAULT sysdate NOT NULL, ' ||
                '  UPLOAD_USER_BUSINESS_ID   varchar2(300)  , ' ||
                '  VALIDATE_USER_ID          varchar2(300)  , ' ||
                '  VALIDATE_DATE             date  , ' ||
                '  VALIDATE_USER_BUSINESS_ID varchar2(300) ' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND CONSTRAINT_NAME = 'FILE_BUNDLE_FILE_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE
            ADD CONSTRAINT FILE_BUNDLE_FILE_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_FILE_BUNDLE_FILE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_FILE_BUNDLE_FILE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/


DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND CONSTRAINT_NAME = 'FILE_BUNDLE_ID_FK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE ' ||
                          'ADD CONSTRAINT FILE_BUNDLE_ID_FK FOREIGN KEY ( FILE_BUNDLE_ID ) ' ||
                          'REFERENCES DIF.FILE_BUNDLE( ID ) ON DELETE CASCADE';
    END IF;
END;
/


DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND CONSTRAINT_NAME = 'FILE_TYPE_ID_FK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE ' ||
                          'ADD CONSTRAINT FILE_TYPE_ID_FK FOREIGN KEY ( TYPE_ID ) ' ||
                          'REFERENCES DIF.FILE_TYPE( ID )';
    END IF;
END;
/
