DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'DATA_INTEGRATION_SET';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE TABLE DIF.DATA_INTEGRATION_SET ' ||
                          '(' ||
                          'ID             NUMBER(10)              NOT NULL,' ||
                          'CONFIG_ID      VARCHAR2(255)           NOT NULL,' ||
                          'CREATION_DATE  DATE  DEFAULT SYSDATE   NOT NULL,' ||
                          'PROCESS_ID     VARCHAR2(255)           NOT NULL,' ||
                          'PRIMARY KEY (ID)' ||
                          ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'DATA_INTEGRATION_SET_SEQ';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.DATA_INTEGRATION_SET_SEQ START WITH 1 INCREMENT BY 1';
    END IF;
END;
/

CREATE OR
    REPLACE TRIGGER DIF.DATA_INTEGRATION_SET_SEQ_TR
    BEFORE
        INSERT
    ON DIF.DATA_INTEGRATION_SET
    FOR EACH ROW
    WHEN (NEW.ID IS NULL)
BEGIN
    SELECT DIF.DATA_INTEGRATION_SET_SEQ.NEXTVAL
    INTO :NEW.ID
    FROM DUAL;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'DATA_INTEGRATION_RECORD';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE TABLE DIF.DATA_INTEGRATION_RECORD ' ||
                          '( ' ||
                          'ID                      NUMBER(10)          NOT NULL,' ||
                          'DATA_INTEGRATION_SET_ID NUMBER(10)          NOT NULL,' ||
                          'ENTITY_TYPE             VARCHAR2(255)       NOT NULL,' ||
                          'ENTITY_ID               VARCHAR2(255)       NOT NULL,' ||
                          'OPERATION_ID            VARCHAR2(1)         NOT NULL,' ||
                          'ROOT                    NUMBER(1) DEFAULT 0 NOT NULL,' ||
                          'PRIMARY KEY (ID), ' ||
                          'CONSTRAINT FK_DATA_INTEGRATION_SET FOREIGN KEY (DATA_INTEGRATION_SET_ID) REFERENCES DIF.DATA_INTEGRATION_SET (ID), ' ||
                          'CONSTRAINT CK_DI_RECORD_OPERATION CHECK (OPERATION_ID IN (''I'', ''U'',''D'')) ' ||
                          ') ';
    END IF;
END;
/



DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'DATA_INTEGRATION_RECORD_SEQ';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.DATA_INTEGRATION_RECORD_SEQ START WITH 1 INCREMENT BY 1';
    END IF;
END;
/

CREATE OR
    REPLACE TRIGGER DIF.DATA_INTEGRATION_RECORD_SEQ_TR
    BEFORE
        INSERT
    ON DIF.DATA_INTEGRATION_RECORD
    FOR EACH ROW
    WHEN (NEW.ID IS NULL)
BEGIN
    SELECT DIF.DATA_INTEGRATION_RECORD_SEQ.NEXTVAL
    INTO :NEW.ID
    FROM DUAL;
END;
/


DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'DATA_INTEGRATION_FIELD';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE TABLE DIF.DATA_INTEGRATION_FIELD ' ||
                          '( ' ||
                          'ID                         NUMBER(10)            NOT NULL, ' ||
                          'DATA_INTEGRATION_RECORD_ID NUMBER(10)            NOT NULL, ' ||
                          'FIELD_ID                   VARCHAR2(255)         NOT NULL, ' ||
                          'RELATION_RECORD_ID         NUMBER(10)                    , ' ||
                          'VALUE                      CLOB, ' ||
                          'INTEGRATED                 NUMBER(1,0) DEFAULT 0 NOT NULL, ' ||
                          'PRIMARY KEY (ID), ' ||
                          'CONSTRAINT FK_DINTEGRATION_RELATION_REC FOREIGN KEY (RELATION_RECORD_ID) REFERENCES DIF.DATA_INTEGRATION_RECORD (ID), ' ||
                          'CONSTRAINT FK_DINTEGRATION_RECORD FOREIGN KEY (DATA_INTEGRATION_RECORD_ID) REFERENCES DIF.DATA_INTEGRATION_RECORD (ID) ' ||
                          ') ';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'DATA_INTEGRATION_FIELD_SEQ';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.DATA_INTEGRATION_FIELD_SEQ START WITH 1 INCREMENT BY 1';
    END IF;
END;
/

CREATE OR
    REPLACE TRIGGER DIF.DATA_INTEGRATION_FIELD_SEQ_TR
    BEFORE
        INSERT
    ON DIF.DATA_INTEGRATION_FIELD
    FOR EACH ROW
    WHEN (NEW.ID IS NULL)
BEGIN
    SELECT DIF.DATA_INTEGRATION_FIELD_SEQ.NEXTVAL
    INTO :NEW.ID
    FROM DUAL;
END;
/