-- DIF.FILE_BUNDLE_INSTANCE_FILE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_INSTANCE_FILE'
      AND COLUMN_NAME = 'DOCUMENT_ID'
      AND NULLABLE = 'N';

    IF TOTAL = 1 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_INSTANCE_FILE MODIFY ( DOCUMENT_ID NULL )';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_INSTANCE_FILE'
      AND COLUMN_NAME = 'UPLOAD_DATE'
      AND NULLABLE = 'N';

    IF TOTAL = 1 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_INSTANCE_FILE MODIFY ( UPLOAD_DATE NULL )';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_INSTANCE_FILE'
      AND COLUMN_NAME = 'VERSION'
      AND NULLABLE = 'N';

    IF TOTAL = 1 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_INSTANCE_FILE MODIFY ( VERSION NULL )';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_INSTANCE_FILE'
      AND COLUMN_NAME = 'IS_INVALID';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_INSTANCE_FILE ADD IS_INVALID number(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_INSTANCE_FILE'
      AND CONSTRAINT_NAME = 'FK_FILE_BUNDLE_INST_FILE_FBI'
      AND DELETE_RULE = 'NO ACTION';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_INSTANCE_FILE
            DROP CONSTRAINT FK_FILE_BUNDLE_INST_FILE_FBI';
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_INSTANCE_FILE ' ||
                          'ADD CONSTRAINT FK_FILE_BUNDLE_INST_FILE_FBI FOREIGN KEY ( FILE_BUNDLE_INSTANCE_ID ) ' ||
                          'REFERENCES DIF.FILE_BUNDLE_INSTANCE( ID ) ON DELETE CASCADE';
    END IF;
END;
/
