-- DIF.CONVERSATION_MESSAGE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'CONVERSATION'
      AND COLUMN_NAME = 'BUSINESS_PROCESS_TYPE_ID'
      AND NULLABLE = 'N';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONVERSATION MODIFY BUSINESS_PROCESS_TYPE_ID NULL';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'CONVERSATION'
      AND COLUMN_NAME = 'BUSINESS_PROCESS_INSTANCE_ID'
      AND NULLABLE = 'N';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONVERSATION MODIFY BUSINESS_PROCESS_INSTANCE_ID NULL';
    END IF;
END;
/

-- DIF.CONVERSATION_MESSAGE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'CONVERSATION_MESSAGE'
      AND COLUMN_NAME = 'FILE_TYPE';

    IF TOTAL = 1 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONVERSATION_MESSAGE DROP COLUMN FILE_TYPE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'CONVERSATION_MESSAGE'
      AND COLUMN_NAME = 'MESSAGE_TYPE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONVERSATION_MESSAGE ADD MESSAGE_TYPE CHAR(1)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'CONVERSATION_MESSAGE'
      AND COLUMN_NAME = 'IS_SYSTEM_MESSAGE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONVERSATION_MESSAGE ADD IS_SYSTEM_MESSAGE number(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

-- DIF.FILE_TYPE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_TYPE'
      AND COLUMN_NAME = 'TEMPLATE_DOCUMENT_ID';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_TYPE ADD TEMPLATE_DOCUMENT_ID number';
    END IF;
END;
/

-- DIF.FILE_TYPE_GEN_PARAMETERS
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_TYPE_GEN_PARAMETERS';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.FILE_TYPE_GEN_PARAMETERS (' ||
                '  ID                   number  NOT NULL,' ||
                '  FILE_TYPE_ID         number  NOT NULL,' ||
                '  NAME                 varchar2(500)  NOT NULL,' ||
                '  TYPE                 varchar2(30)  NOT NULL,' ||
                '  OPTIONS              varchar2(4000),' ||
                '  OPTIONS_AJAX_EVENT   varchar2(500),' ||
                '  IS_MANDATORY         number(1) DEFAULT 1,' ||
                '  HINT                 varchar2(1000),' ||
                '  HELP                 varchar2(4000)' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_TYPE_GEN_PARAMETERS'
      AND CONSTRAINT_NAME = 'FILE_TYPE_GENERATION_PARAM_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_TYPE_GEN_PARAMETERS
            ADD CONSTRAINT FILE_TYPE_GENERATION_PARAM_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_FILE_TYPE_GEN_PARAM';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_FILE_TYPE_GEN_PARAM MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_TYPE_GEN_PARAMETERS'
      AND CONSTRAINT_NAME = 'FK_FTYPE_GEN_PARAM_FTYPE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_TYPE_GEN_PARAMETERS ' ||
                          'ADD CONSTRAINT FK_FTYPE_GEN_PARAM_FTYPE FOREIGN KEY ( FILE_TYPE_ID ) ' ||
                          'REFERENCES DIF.FILE_TYPE( ID ) ON DELETE CASCADE';
    END IF;
END;
/

-- DIF.WORKFLOW
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.WORKFLOW (' ||
                '  ID                   number  NOT NULL,' ||
                '  APPLICATION_ID       varchar2(50)  NOT NULL,' ||
                '  NAME                 varchar2(500)  NOT NULL,' ||
                '  DESCRIPTION          varchar2(4000),' ||
                '  BUSINESS_CLASS_ID    varchar2(500),' ||
                '  VERSION              number(5),' ||
                '  BUSINESS_VERSION     number(5),' ||
                '  FILE_BUNDLE_ID       number,' ||
                '  IS_CUSTOMIZED        number(1) DEFAULT 0,' ||
                '  IS_ACTIVE            number(1) DEFAULT 0' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW'
      AND CONSTRAINT_NAME = 'WORKFLOW_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW
            ADD CONSTRAINT WORKFLOW_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_WORKFLOW';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_WORKFLOW MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW'
      AND CONSTRAINT_NAME = 'FK_WORKFLOW_FILE_BUNDLE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW ' ||
                          'ADD CONSTRAINT FK_WORKFLOW_FILE_BUNDLE FOREIGN KEY ( FILE_BUNDLE_ID ) ' ||
                          'REFERENCES DIF.FILE_BUNDLE( ID ) ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW'
      AND CONSTRAINT_NAME = 'IDX_WORKFLOW_BUSINESS_CLASS_ID';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW ADD CONSTRAINT IDX_WORKFLOW_BUSINESS_CLASS_ID UNIQUE (BUSINESS_CLASS_ID)';
    END IF;
END;
/

-- DIF.WORKFLOW_ACTION_LIST
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ACTION_LIST';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.WORKFLOW_ACTION_LIST (' ||
                '  ID          number        NOT NULL,' ||
                '  WORKFLOW_ID number        NOT NULL,' ||
                '  NAME        varchar2(200) NOT NULL' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ACTION_LIST'
      AND CONSTRAINT_NAME = 'WORKFLOW_ACTION_LIST_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_ACTION_LIST
            ADD CONSTRAINT WORKFLOW_ACTION_LIST_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_WORKFLOW_ACTION_LIST';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_WORKFLOW_ACTION_LIST MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ACTION_LIST'
      AND CONSTRAINT_NAME = 'FK_WF_ACTION_LIST_WF';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_ACTION_LIST ' ||
                          'ADD CONSTRAINT FK_WF_ACTION_LIST_WF FOREIGN KEY ( WORKFLOW_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW( ID ) ON DELETE CASCADE';
    END IF;
END;
/

-- DIF.WORKFLOW_CUSTOM_FORM
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_CUSTOM_FORM';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.WORKFLOW_CUSTOM_FORM (' ||
                '  ID          number        NOT NULL,' ||
                '  STAGE_ID    varchar2(500) NOT NULL,' ||
                '  FORM_NAME   varchar2(500) NOT NULL,' ||
                '  NAME        varchar2(500) NOT NULL,' ||
                '  WORKFLOW_ID number        NOT NULL' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_CUSTOM_FORM'
      AND CONSTRAINT_NAME = 'WORKFLOW_CUST_FORM_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_CUSTOM_FORM
            ADD CONSTRAINT WORKFLOW_CUST_FORM_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_WORKFLOW_CUSTOM_FORM';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_WORKFLOW_CUSTOM_FORM MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_CUSTOM_FORM'
      AND CONSTRAINT_NAME = 'FK_WF_CUSTOM_FORMS_WF';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_CUSTOM_FORM ' ||
                          'ADD CONSTRAINT FK_WF_CUSTOM_FORMS_WF FOREIGN KEY ( WORKFLOW_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW( ID ) ON DELETE CASCADE';
    END IF;
END;
/

-- DIF.WORKFLOW_STATE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.WORKFLOW_STATE (' ||
                '  ID                      number              NOT NULL,' ||
                '  WORKFLOW_ID             number              NOT NULL,' ||
                '  NAME                    varchar2(200)       NOT NULL,' ||
                '  KEYWORD                 varchar2(10)        NOT NULL,' ||
                '  ICON_IMAGE_PATH         varchar2(1000),' ||
                '  DESCRIPTION             varchar2(4000),' ||
                '  STATE_BUSINESS_ID       varchar2(500),' ||
                '  IS_INITIAL              number(1) DEFAULT 0 NOT NULL,' ||
                '  IS_FINAL                number(1) DEFAULT 0,' ||
                '  ON_ENTER_ACTION_LIST_ID number,' ||
                '  ON_EXIT_ACTION_LIST_ID  number' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE'
      AND CONSTRAINT_NAME = 'WORKFLOW_STATE_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_STATE
            ADD CONSTRAINT WORKFLOW_STATE_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_WORKFLOW_STATE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_WORKFLOW_STATE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE'
      AND CONSTRAINT_NAME = 'FK_WORKFLOW_STATE_WORKFLOW';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_STATE ' ||
                          'ADD CONSTRAINT FK_WORKFLOW_STATE_WORKFLOW FOREIGN KEY ( WORKFLOW_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW( ID ) ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE'
      AND CONSTRAINT_NAME = 'FK_WF_STATE_ENTER_AL';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_STATE ' ||
                          'ADD CONSTRAINT FK_WF_STATE_ENTER_AL FOREIGN KEY ( ON_ENTER_ACTION_LIST_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_ACTION_LIST( ID ) ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE'
      AND CONSTRAINT_NAME = 'FK_WF_STATE_EXIT_AL';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_STATE ' ||
                          'ADD CONSTRAINT FK_WF_STATE_EXIT_AL FOREIGN KEY ( ON_EXIT_ACTION_LIST_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_ACTION_LIST( ID ) ON DELETE CASCADE';
    END IF;
END;
/

-- DIF.WORKFLOW_STATE_ACTION
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE_ACTION';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.WORKFLOW_STATE_ACTION (' ||
                '  ID                               number              NOT NULL,' ||
                '  WORKFLOW_STATE_ID                number              NOT NULL,' ||
                '  NAME                             varchar2(500)       NOT NULL,' ||
                '  DESCRIPTION                      varchar2(4000),' ||
                '  ICON_IMAGE_PATH                  varchar2(1000),' ||
                '  ACTION_BUSINESS_ID               varchar2(500),' ||
                '  ACTION_LIST_ID                   number              NOT NULL,' ||
                '  BUSINESS_RULE_CONDITION_ID       varchar2(1000),' ||
                '  MUST_COMMENT                     number(1) DEFAULT 0 NOT NULL,' ||
                '  SHOW_IF_CONDITION_FAILS number(1) DEFAULT 0' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE_ACTION'
      AND CONSTRAINT_NAME = 'WORKFLOW_STATE_ACTION_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_STATE_ACTION
            ADD CONSTRAINT WORKFLOW_STATE_ACTION_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_WORKFLOW_STATE_ACTION';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_WORKFLOW_STATE_ACTION MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE_ACTION'
      AND CONSTRAINT_NAME = 'FK_WK_STATE_ACTION_WF_STATE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_STATE_ACTION ' ||
                          'ADD CONSTRAINT FK_WK_STATE_ACTION_WF_STATE FOREIGN KEY ( WORKFLOW_STATE_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_STATE( ID ) ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE_ACTION'
      AND CONSTRAINT_NAME = 'FK_WF_STATE_ACTION_WAL';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_STATE_ACTION ' ||
                          'ADD CONSTRAINT FK_WF_STATE_ACTION_WAL FOREIGN KEY ( ACTION_LIST_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_ACTION_LIST( ID ) ON DELETE CASCADE';
    END IF;
END;
/

-- DIF.WORKFLOW_USER_PROFILE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_USER_PROFILE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.WORKFLOW_USER_PROFILE (' ||
                '  ID                         number        NOT NULL,' ||
                '  WORKFLOW_ID                number        NOT NULL,' ||
                '  NAME                       varchar2(200) NOT NULL,' ||
                '  GROUP_ID                   varchar2(500),' ||
                '  PROFILE_BUSINESS_ID        varchar2(200),' ||
                '  PROFILE_BUSINESS_ID_PARAMS varchar2(1000)' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_USER_PROFILE'
      AND CONSTRAINT_NAME = 'WORKFLOW_USER_PROFILE_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_USER_PROFILE
            ADD CONSTRAINT WORKFLOW_USER_PROFILE_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_WORKFLOW_USER_PROFILE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_WORKFLOW_USER_PROFILE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_USER_PROFILE'
      AND CONSTRAINT_NAME = 'FK_WF_USER_PROFILE_WF';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_USER_PROFILE ' ||
                          'ADD CONSTRAINT FK_WF_USER_PROFILE_WF FOREIGN KEY ( WORKFLOW_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW( ID ) ON DELETE CASCADE';
    END IF;
END;
/

-- DIF.WORKFLOW_ACTION_LIST_ITEM
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ACTION_LIST_ITEM';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.WORKFLOW_ACTION_LIST_ITEM (' ||
                '  ID                         number NOT NULL,' ||
                '  ACTION_LIST_ID             number NOT NULL,' ||
                '  ACTION_TYPE                varchar2(100),' ||
                '  ACTION_ITEM_BUSINESS_ID    varchar2(500),' ||
                '  PARAMETERS                 varchar2(1000),' ||
                '  BUSINESS_FLOW_ACTION_ID    varchar2(1000),' ||
                '  BUSINESS_RULE_EXECUTION_ID varchar2(1000),' ||
                '  NEW_STATE_ID               number,' ||
                '  EXECUTION_ORDER            number NOT NULL,' ||
                '  FAIL_ACTION_LIST_ON_ERROR  number(1) DEFAULT 1' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ACTION_LIST_ITEM'
      AND CONSTRAINT_NAME = 'WORKFLOW_ACT_LST_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_ACTION_LIST_ITEM
            ADD CONSTRAINT WORKFLOW_ACT_LST_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_WF_ACTION_LIST_ITEM';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_WF_ACTION_LIST_ITEM MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ACTION_LIST_ITEM'
      AND CONSTRAINT_NAME = 'FK_WF_ACTION_LIST_ITEM_AL';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_ACTION_LIST_ITEM ' ||
                          'ADD CONSTRAINT FK_WF_ACTION_LIST_ITEM_AL FOREIGN KEY ( ACTION_LIST_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_ACTION_LIST( ID ) ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ACTION_LIST_ITEM'
      AND CONSTRAINT_NAME = 'FK_WF_ACTION_LIST_ITEM_WS';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_ACTION_LIST_ITEM ' ||
                          'ADD CONSTRAINT FK_WF_ACTION_LIST_ITEM_WS FOREIGN KEY ( NEW_STATE_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_STATE( ID )';
    END IF;
END;
/

-- DIF.WORKFLOW_ALI_TARGET
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ALI_TARGET';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.WORKFLOW_ALI_TARGET (' ||
                '  ID                  number NOT NULL,' ||
                '  ACTION_LIST_ITEM_ID number NOT NULL,' ||
                '  USER_ID             varchar2(1000),' ||
                '  USER_PROFILE_ID     number' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ALI_TARGET'
      AND CONSTRAINT_NAME = 'WORKFLOW_ACT_LST_TRG_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_ALI_TARGET
            ADD CONSTRAINT WORKFLOW_ACT_LST_TRG_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_WORKFLOW_ALI_TARGET';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_WORKFLOW_ALI_TARGET MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ALI_TARGET'
      AND CONSTRAINT_NAME = 'FK_WF_ALI_TARGET_ALI';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_ALI_TARGET ' ||
                          'ADD CONSTRAINT FK_WF_ALI_TARGET_ALI FOREIGN KEY ( ACTION_LIST_ITEM_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_ACTION_LIST_ITEM( ID ) ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ALI_TARGET'
      AND CONSTRAINT_NAME = 'FK_WORKFLOW_ALI_TARGET';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_ALI_TARGET ' ||
                          'ADD CONSTRAINT FK_WORKFLOW_ALI_TARGET FOREIGN KEY ( USER_PROFILE_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_USER_PROFILE( ID ) ON DELETE CASCADE';
    END IF;
END;
/

-- DIF.WORKFLOW_CUSTOM_FORM_CONFIG
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_CUSTOM_FORM_CONFIG';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.WORKFLOW_CUSTOM_FORM_CONFIG (' ||
                '  ID                      number NOT NULL,' ||
                '  WORKFLOW_CUSTOM_FORM_ID number NOT NULL,' ||
                '  STATE_ID                number,' ||
                '  USER_PROFILE_ID         number' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_CUSTOM_FORM_CONFIG'
      AND CONSTRAINT_NAME = 'WORKFLOW_CUST_FORM_CFG_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_CUSTOM_FORM_CONFIG
            ADD CONSTRAINT WORKFLOW_CUST_FORM_CFG_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_WORKFLOW_CUST_FRM_CFG';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_WORKFLOW_CUST_FRM_CFG MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_CUSTOM_FORM_CONFIG'
      AND CONSTRAINT_NAME = 'FK_WF_CUSTOM_FORM_CONFIG_WCF';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_CUSTOM_FORM_CONFIG ' ||
                          'ADD CONSTRAINT FK_WF_CUSTOM_FORM_CONFIG_WCF FOREIGN KEY ( WORKFLOW_CUSTOM_FORM_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_CUSTOM_FORM( ID ) ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_CUSTOM_FORM_CONFIG'
      AND CONSTRAINT_NAME = 'FK_WF_CUSTOM_FORM_CONFIG_WS';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_CUSTOM_FORM_CONFIG ' ||
                          'ADD CONSTRAINT FK_WF_CUSTOM_FORM_CONFIG_WS FOREIGN KEY ( STATE_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_STATE( ID ) ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_CUSTOM_FORM_CONFIG'
      AND CONSTRAINT_NAME = 'FK_WF_CUSTOM_FORM_CONFIG_WUP';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_CUSTOM_FORM_CONFIG ' ||
                          'ADD CONSTRAINT FK_WF_CUSTOM_FORM_CONFIG_WUP FOREIGN KEY ( USER_PROFILE_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_USER_PROFILE( ID ) ON DELETE CASCADE';
    END IF;
END;
/

-- DIF.WORKFLOW_FILE_ACL
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_FILE_ACL';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.WORKFLOW_FILE_ACL (' ||
                '  ID                  number              NOT NULL,' ||
                '  WORKFLOW_ID         number              NOT NULL,' ||
                '  FILE_BUNDLE_FILE_ID number              NOT NULL,' ||
                '  STATE_ID            number,' ||
                '  USER_ID             varchar2(1000),' ||
                '  USER_PROFILE_ID     number,' ||
                '  CAN_UPLOAD          number(1) DEFAULT 1 NOT NULL,' ||
                '  CAN_VALIDATE        number(1) DEFAULT 1 NOT NULL,' ||
                '  CAN_INVALIDATE      number(1) DEFAULT 1 NOT NULL,' ||
                '  CAN_VIEW_VALID      number(1) DEFAULT 1 NOT NULL,' ||
                '  CAN_VIEW_NOT_VALID  number(1) DEFAULT 1 NOT NULL' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_FILE_ACL'
      AND CONSTRAINT_NAME = 'WORKFLOW_FILE_ACL_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_FILE_ACL
            ADD CONSTRAINT WORKFLOW_FILE_ACL_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_WORKFLOW_FILE_ACL';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_WORKFLOW_FILE_ACL MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_FILE_ACL'
      AND CONSTRAINT_NAME = 'FK_WORKFLOW_FILE_WORKFLOW';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_FILE_ACL ' ||
                          'ADD CONSTRAINT FK_WORKFLOW_FILE_WORKFLOW FOREIGN KEY ( WORKFLOW_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW( ID ) ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_FILE_ACL'
      AND CONSTRAINT_NAME = 'FK_WORKFLOW_FILE_ACL_FILE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_FILE_ACL ' ||
                          'ADD CONSTRAINT FK_WORKFLOW_FILE_ACL_FILE FOREIGN KEY ( FILE_BUNDLE_FILE_ID ) ' ||
                          'REFERENCES DIF.FILE_BUNDLE_FILE( ID )';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_FILE_ACL'
      AND CONSTRAINT_NAME = 'FK_WORKFLOW_FILE_ACL_STATE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_FILE_ACL ' ||
                          'ADD CONSTRAINT FK_WORKFLOW_FILE_ACL_STATE FOREIGN KEY ( STATE_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_STATE( ID ) ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_FILE_ACL'
      AND CONSTRAINT_NAME = 'FK_WORKFLOW_FILE_ACL_PROFILE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_FILE_ACL ' ||
                          'ADD CONSTRAINT FK_WORKFLOW_FILE_ACL_PROFILE FOREIGN KEY ( USER_PROFILE_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_USER_PROFILE( ID ) ON DELETE CASCADE';
    END IF;
END;
/

-- DIF.WORKFLOW_INSTANCE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_INSTANCE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.WORKFLOW_INSTANCE (' ||
                '  ID                    number         NOT NULL,' ||
                '  WORKFLOW_ID           number         NOT NULL,' ||
                '  STATE_ID              number         NOT NULL,' ||
                '  BUSINESS_ID           varchar2(1000) NOT NULL,' ||
                '  CREATOR_USER_ID       varchar2(1000),' ||
                '  CURRENT_OWNER_USER_ID varchar2(1000),' ||
                '  CONVERSATION_ID       number         NOT NULL' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_INSTANCE'
      AND CONSTRAINT_NAME = 'WORKFLOW_INSTANCE_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_INSTANCE
            ADD CONSTRAINT WORKFLOW_INSTANCE_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_WORKFLOW_INSTANCE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_WORKFLOW_INSTANCE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_INSTANCE'
      AND CONSTRAINT_NAME = 'IDX_WORKFLOW_BUSINESS_ID';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_INSTANCE ADD CONSTRAINT IDX_WORKFLOW_BUSINESS_ID UNIQUE (WORKFLOW_ID, BUSINESS_ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_INSTANCE'
      AND CONSTRAINT_NAME = 'FK_WORKFLOW_INSTANCE_WORKFLOW';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_INSTANCE ' ||
                          'ADD CONSTRAINT FK_WORKFLOW_INSTANCE_WORKFLOW FOREIGN KEY ( WORKFLOW_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW( ID )';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_INSTANCE'
      AND CONSTRAINT_NAME = 'FK_WORKFLOW_INSTANCE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_INSTANCE ' ||
                          'ADD CONSTRAINT FK_WORKFLOW_INSTANCE FOREIGN KEY ( STATE_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_STATE( ID )';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_INSTANCE'
      AND CONSTRAINT_NAME = 'FK_WORKFLOW_INST_CONVERS';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_INSTANCE ' ||
                          'ADD CONSTRAINT FK_WORKFLOW_INST_CONVERS FOREIGN KEY ( CONVERSATION_ID ) ' ||
                          'REFERENCES DIF.CONVERSATION( ID ) ON DELETE CASCADE';
    END IF;
END;
/

-- DIF.WORKFLOW_STATE_ACTION_ACL
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE_ACTION_ACL';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.WORKFLOW_STATE_ACTION_ACL (' ||
                '  ID              number NOT NULL,' ||
                '  STATE_ACTION_ID number NOT NULL,' ||
                '  USER_ID         varchar2(1000),' ||
                '  USER_PROFILE_ID number' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE_ACTION_ACL'
      AND CONSTRAINT_NAME = 'WORKFLOW_STATE_ACT_ACL_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_STATE_ACTION_ACL
            ADD CONSTRAINT WORKFLOW_STATE_ACT_ACL_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_WORKFLOW_STATE_ACT_ACL';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_WORKFLOW_STATE_ACT_ACL MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE_ACTION_ACL'
      AND CONSTRAINT_NAME = 'FK_WF_STATE_ACTION_ACL_SA';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_STATE_ACTION_ACL ' ||
                          'ADD CONSTRAINT FK_WF_STATE_ACTION_ACL_SA FOREIGN KEY ( STATE_ACTION_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_STATE_ACTION( ID ) ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE_ACTION_ACL'
      AND CONSTRAINT_NAME = 'FK_WF_STATE_ACTION_ACL_WUP';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_STATE_ACTION_ACL ' ||
                          'ADD CONSTRAINT FK_WF_STATE_ACTION_ACL_WUP FOREIGN KEY ( USER_PROFILE_ID ) ' ||
                          'REFERENCES DIF.WORKFLOW_USER_PROFILE( ID ) ON DELETE CASCADE';
    END IF;
END;
/

-- DIF.FILE_BUNDLE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'BUSINESS_PROCESS_INSTANCE_ID';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE DROP COLUMN BUSINESS_PROCESS_INSTANCE_ID';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'CREATION_DATE';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE DROP COLUMN CREATION_DATE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'IS_OPEN';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE DROP COLUMN IS_OPEN';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'CLOSE_DATE';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE DROP COLUMN CLOSE_DATE';
    END IF;
END;
/

-- DIF.FILE_BUNDLE_FILE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'DOCUMENT_ID';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE DROP COLUMN DOCUMENT_ID';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'IS_PRIVATE';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE DROP COLUMN IS_PRIVATE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'IS_VALID';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE DROP COLUMN IS_VALID';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'UPLOAD_USER_ID';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE DROP COLUMN UPLOAD_USER_ID';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'UPLOAD_DATE';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE DROP COLUMN UPLOAD_DATE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'UPLOAD_USER_BUSINESS_ID';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE DROP COLUMN UPLOAD_USER_BUSINESS_ID';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'VALIDATE_USER_ID';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE DROP COLUMN VALIDATE_USER_ID';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'VALIDATE_DATE';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE DROP COLUMN VALIDATE_DATE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'VALIDATE_USER_BUSINESS_ID';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE DROP COLUMN VALIDATE_USER_BUSINESS_ID';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'IS_MANDATORY';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE ADD IS_MANDATORY number(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'IS_VERSIONED';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE ADD IS_VERSIONED number(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'IS_VERSIONED';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE ADD IS_VERSIONED number(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'HAS_VALIDATION';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_FILE ADD HAS_VALIDATION number(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

-- DIF.WORKFLOW_FILE_ACL
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_FILE_ACL'
      AND COLUMN_NAME = 'CAN_VIEW_PRIVATE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_FILE_ACL ADD CAN_VIEW_PRIVATE number(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

-- DIF.FILE_BUNDLE_INSTANCE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_INSTANCE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.FILE_BUNDLE_INSTANCE (' ||
                '  ID                           number                    NOT NULL,' ||
                '  FILE_BUNDLE_ID               number                    NOT NULL,' ||
                '  BUSINESS_PROCESS_INSTANCE_ID varchar2(200),' ||
                '  CREATION_DATE                date      DEFAULT sysdate NOT NULL,' ||
                '  IS_OPEN                      number(1) DEFAULT 1       NOT NULL,' ||
                '  CLOSE_DATE                   date' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_INSTANCE'
      AND CONSTRAINT_NAME = 'PK_FILE_BUNDLE_INSTANCE_ID';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_INSTANCE
            ADD CONSTRAINT PK_FILE_BUNDLE_INSTANCE_ID PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_FILE_BUNDLE_INSTANCE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_FILE_BUNDLE_INSTANCE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_INSTANCE'
      AND CONSTRAINT_NAME = 'FK_FILE_BUNDLE_INSTANCE_FB';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_INSTANCE ' ||
                          'ADD CONSTRAINT FK_FILE_BUNDLE_INSTANCE_FB FOREIGN KEY ( FILE_BUNDLE_ID ) ' ||
                          'REFERENCES DIF.FILE_BUNDLE( ID )';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_INDEXES
    WHERE OWNER = 'DIF'
      AND INDEX_NAME = 'IDX_FILE_BUNDLE_INST_FB';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_FILE_BUNDLE_INST_FB ON DIF.FILE_BUNDLE_INSTANCE (FILE_BUNDLE_ID)';
    END IF;
END;
/

-- DIF.FILE_BUNDLE_INSTANCE_FILE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_INSTANCE_FILE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.FILE_BUNDLE_INSTANCE_FILE (' ||
                '  ID                        number                    NOT NULL,' ||
                '  FILE_BUNDLE_INSTANCE_ID   number                    NOT NULL,' ||
                '  FILE_BUNDLE_FILE_ID       number                    NOT NULL,' ||
                '  DOCUMENT_ID               number                    NOT NULL,' ||
                '  IS_PRIVATE                number(1) DEFAULT 0       NOT NULL,' ||
                '  IS_VALID                  number(1) DEFAULT 0       NOT NULL,' ||
                '  UPLOAD_USER_ID            varchar2(300),' ||
                '  UPLOAD_DATE               date      DEFAULT sysdate NOT NULL,' ||
                '  UPLOAD_USER_BUSINESS_ID   varchar2(300),' ||
                '  VALIDATE_USER_ID          varchar2(300),' ||
                '  VALIDATE_DATE             date,' ||
                '  VALIDATE_USER_BUSINESS_ID varchar2(300),' ||
                '  VERSION                   number(5) DEFAULT 1       NOT NULL' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_INSTANCE_FILE'
      AND CONSTRAINT_NAME = 'FILE_BUNDLE_INSTANCE_FILE_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_INSTANCE_FILE
            ADD CONSTRAINT FILE_BUNDLE_INSTANCE_FILE_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_FILE_BUNDLE_INSTANCE_FILE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_FILE_BUNDLE_INSTANCE_FILE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_INSTANCE_FILE'
      AND CONSTRAINT_NAME = 'FK_FILE_BUNDLE_INST_FILE_FBI';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_INSTANCE_FILE ' ||
                          'ADD CONSTRAINT FK_FILE_BUNDLE_INST_FILE_FBI FOREIGN KEY ( FILE_BUNDLE_INSTANCE_ID ) ' ||
                          'REFERENCES DIF.FILE_BUNDLE_INSTANCE( ID ) ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_INSTANCE_FILE'
      AND CONSTRAINT_NAME = 'FK_FILE_BUNDLE_INST_FILE_FBF';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_INSTANCE_FILE ' ||
                          'ADD CONSTRAINT FK_FILE_BUNDLE_INST_FILE_FBF FOREIGN KEY ( FILE_BUNDLE_FILE_ID ) ' ||
                          'REFERENCES DIF.FILE_BUNDLE_FILE( ID )';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_INDEXES
    WHERE OWNER = 'DIF'
      AND INDEX_NAME = 'IDX_FILE_BUNDLE_INST_FB';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_FILE_BUNDLE_INST_FB ON DIF.FILE_BUNDLE_INSTANCE_FILE (FILE_BUNDLE_INSTANCE_ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_INDEXES
    WHERE OWNER = 'DIF'
      AND INDEX_NAME = 'IDX_FILE_BUNDLE_INST_FILE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_FILE_BUNDLE_INST_FILE ON DIF.FILE_BUNDLE_INSTANCE_FILE (FILE_BUNDLE_FILE_ID)';
    END IF;
END;
/

-- DIF.FILE_BUNDLE_HISTORY
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_HISTORY';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.FILE_BUNDLE_HISTORY (' ||
                '  ID               number        NOT NULL,' ||
                '  INSTANCE_FILE_ID number        NOT NULL,' ||
                '  DOCUMENT_ID      number        NOT NULL,' ||
                '  VERSION          number(5)     NOT NULL,' ||
                '  UPLOAD_DATE      date          NOT NULL,' ||
                '  DEPRECATION_DATE date          NOT NULL,' ||
                '  UPLOAD_USER_ID   varchar2(300) NOT NULL' ||
                ')';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_HISTORY'
      AND CONSTRAINT_NAME = 'PK_FILE_BUNDLE_HISTORY_ID';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_HISTORY
            ADD CONSTRAINT PK_FILE_BUNDLE_HISTORY_ID PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_FILE_BUNDLE_IFILE_VERSION';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_FILE_BUNDLE_IFILE_VERSION MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_HISTORY'
      AND CONSTRAINT_NAME = 'FK_FILE_BUNDLE_IF_VERSION_FBIF';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE_HISTORY ' ||
                          'ADD CONSTRAINT FK_FILE_BUNDLE_IF_VERSION_FBIF FOREIGN KEY ( INSTANCE_FILE_ID ) ' ||
                          'REFERENCES DIF.FILE_BUNDLE_INSTANCE_FILE( ID )  ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_INDEXES
    WHERE OWNER = 'DIF'
      AND INDEX_NAME = 'IDX_FILE_BUNDLE_HIST_INST_FIL';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_FILE_BUNDLE_HIST_INST_FIL ON DIF.FILE_BUNDLE_HISTORY (INSTANCE_FILE_ID)';
    END IF;
END;
/

-- DIF.FILE_BUNDLE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'DESCRIPTION';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE RENAME COLUMN DESCRIPTION TO NAME';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'NAME'
      AND DATA_LENGTH = 300;

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE MODIFY (NAME varchar2(300))';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'BUSINESS_PROCESS_TYPE_ID'
      AND NULLABLE = 'N';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILE_BUNDLE MODIFY (BUSINESS_PROCESS_TYPE_ID NULL)';
    END IF;
END;
/

-- DIF.WORKFLOW_INSTANCE
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_INSTANCE'
      AND COLUMN_NAME = 'FILE_BUNDLE_INSTANCE_ID';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_INSTANCE ADD FILE_BUNDLE_INSTANCE_ID number';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_INSTANCE'
      AND CONSTRAINT_NAME = 'FK_WORKFLOW_INSTANCE_FBI';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_INSTANCE
            ADD CONSTRAINT FK_WORKFLOW_INSTANCE_FBI FOREIGN KEY (FILE_BUNDLE_INSTANCE_ID) REFERENCES DIF.FILE_BUNDLE_INSTANCE (ID) ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_INDEXES
    WHERE OWNER = 'DIF'
      AND INDEX_NAME = 'IDX_WORKFLOW_INS_FILE_BUNDLE';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_WORKFLOW_INS_FILE_BUNDLE ON DIF.WORKFLOW_INSTANCE (FILE_BUNDLE_INSTANCE_ID)';
    END IF;
END;
/

-- DIF.WORKFLOW_ALI_TARGET
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ALI_TARGET'
      AND CONSTRAINT_NAME = 'WORKFLOW_ACT_LST_TRG_PK';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_ALI_TARGET RENAME CONSTRAINT WORKFLOW_ACT_LST_TRG_PK TO WORKFLOW_ALI_TARGET_PK';
    END IF;
END;
/
