/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.utils.logging;

import java.util.ArrayList;
import java.util.Date;
import org.hibernate.Query;
import org.hibernate.Session;
import pt.digitalis.dif.dem.managers.impl.audit.model.DIFDBAuditFactory;
import pt.digitalis.dif.dem.managers.impl.audit.model.data.AuditLog;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.data.AccessLog;
import pt.digitalis.dif.dem.managers.impl.model.data.ErrorLog;
import pt.digitalis.dif.startup.DIFErrorHandingConfiguration;
import pt.digitalis.dif.utils.jobs.RecurrentJob;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.utils.logging.LoggingConfiguration;
import pt.digitalis.dif.utils.logging.performance.PerformanceLoggerConfiguration;
import pt.digitalis.utils.common.Chronometer;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.DateUtils;

public class LoggerPurgeJob
extends RecurrentJob {
    private static final long DELETE_CHUNK = 1000L;

    public LoggerPurgeJob() {
        super("System (DIF)", "Logs: Purge logs");
        this.setDescription("Will purge logs from the database when they are too large or too old");
    }

    protected boolean executeEachTime() {
        DIFLogger.getLogger().info((Object)"Purging DIF logs from database...");
        if (LoggingConfiguration.getInstance().getAuditDatabase().booleanValue()) {
            this.purgeOldEntries(DIFDBAuditFactory.getSession(), "operationDate", AuditLog.class.getSimpleName(), LoggingConfiguration.getInstance().getAuditDatabasePurgeMaxEntries(), LoggingConfiguration.getInstance().getAuditDatabasePurgeMaxDays());
        }
        if (PerformanceLoggerConfiguration.getInstance().getAuditRequests().booleanValue()) {
            this.purgeOldEntries(DIFRepositoryFactory.getSession(), "accessDate", AccessLog.class.getSimpleName(), PerformanceLoggerConfiguration.getInstance().getAuditRequestsPurgeMaxEntries(), PerformanceLoggerConfiguration.getInstance().getAuditRequestsPurgeMaxDays());
        }
        this.purgeOldEntries(DIFRepositoryFactory.getSession(), "erroDate", ErrorLog.class.getSimpleName(), DIFErrorHandingConfiguration.getInstance().getErrorLogTablePurgeMaxEntries(), DIFErrorHandingConfiguration.getInstance().getErrorLogTablePurgeMaxDays());
        return true;
    }

    protected Long getDefaultRunIntervalInSeconds() {
        return LoggingConfiguration.getInstance().getPurgeJobInterval();
    }

    private void purgeOldEntries(Session session, String dateField, String tableName, Long maxEntriesAllowed, Long maxDaysAllowed) {
        if (maxEntriesAllowed > 0L || maxDaysAllowed > 0L) {
            boolean purgeRecordsEntriesTooOld;
            Chronometer totalTime = new Chronometer();
            Chronometer commandTime = new Chronometer();
            totalTime.start();
            boolean wasActive = session.getTransaction().isActive();
            if (!wasActive) {
                session.beginTransaction();
            }
            DIFLogger.getLogger().info((Object)("   => Analyzing " + tableName + " logs from database [maxDays:" + maxDaysAllowed + " | maxEntries:" + maxEntriesAllowed + "]..."));
            Object[] queryResult = (Object[])session.createQuery("select count(*), max(id), min(" + dateField + ") from " + tableName).list().get(0);
            Long totalEntries = (Long)queryResult[0];
            Long maxID = (Long)queryResult[1];
            Date minDate = (Date)queryResult[2];
            Date now = new Date();
            DIFLogger.getLogger().debug((Object)("       => Oldest log found: " + DateUtils.simpleDateTimeToString((Date)minDate)));
            DIFLogger.getLogger().debug((Object)("       => Total logs found: " + totalEntries));
            boolean purgeRecordsTooManyEntries = maxEntriesAllowed > 0L && totalEntries > maxEntriesAllowed;
            boolean bl = purgeRecordsEntriesTooOld = maxDaysAllowed > 0L && DateUtils.getDateDiffInDays((Date)minDate, (Date)now) > maxDaysAllowed;
            if (purgeRecordsEntriesTooOld || purgeRecordsTooManyEntries) {
                Date oldestDateToKeep = null;
                ArrayList<String> filters = new ArrayList<String>();
                if (purgeRecordsTooManyEntries) {
                    filters.add("id < " + (maxID - maxEntriesAllowed));
                }
                if (purgeRecordsEntriesTooOld) {
                    oldestDateToKeep = DateUtils.addDays((Date)now, (int)(-maxDaysAllowed.intValue()));
                    filters.add(dateField + " < :oldestDateToKeep");
                }
                String hql = "select min(id), max(id) from " + tableName + " where " + CollectionUtils.listToSeparatedString(filters, (String)" and ");
                Query query = session.createQuery(hql);
                if (oldestDateToKeep != null) {
                    query.setParameter("oldestDateToKeep", (Object)oldestDateToKeep);
                }
                queryResult = (Object[])query.uniqueResult();
                Long minID = (Long)queryResult[0];
                maxID = (Long)queryResult[1];
                long totalEntriesPurged = 0L;
                while (minID < maxID) {
                    long maxIDToDelete = minID + 1000L;
                    if (maxIDToDelete > maxID) {
                        maxIDToDelete = maxID;
                    }
                    commandTime.start();
                    long entriesPurged = session.createQuery("delete from " + tableName + " where id < " + maxIDToDelete).executeUpdate();
                    session.getTransaction().commit();
                    session = session.getSessionFactory().getCurrentSession();
                    session.beginTransaction();
                    totalEntriesPurged += entriesPurged;
                    minID = minID + 1000L;
                    DIFLogger.getLogger().info((Object)("  => Log PURGE (" + tableName + "): total records purged: " + entriesPurged + " in " + commandTime.getTimePassedAsFormattedString()));
                }
                if (totalEntriesPurged > 0L) {
                    DIFLogger.getLogger().info((Object)("   => Log " + tableName + " purged. " + totalEntriesPurged + " deleted in " + totalTime.getTimePassedAsFormattedString() + "."));
                }
            }
            if (wasActive) {
                session.getTransaction().commit();
            }
        }
    }
}

