DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.DATA_INTEGRATION_SET
(
    ID            INT(10)                             NOT NULL AUTO_INCREMENT,
    CONFIG_ID     VARCHAR(255)                        NOT NULL,
    CREATION_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PROCESS_ID    VARCHAR(255)                        NOT NULL,
    PRIMARY KEY (`ID`)
) ENGINE = INNODB
  DEFAULT CHARSET = UTF8
  COLLATE = UTF8_BIN$$

CREATE TABLE IF NOT EXISTS DIF.DATA_INTEGRATION_RECORD
(
    ID                      INT(10)            NOT NULL AUTO_INCREMENT,
    DATA_INTEGRATION_SET_ID INT(10)            NOT NULL,
    ENTITY_TYPE             VARCHAR(255)       NOT NULL,
    ENTITY_ID               VARCHAR(255)       NOT NULL,
    OPERATION_ID            ENUM ('I','U','D') NOT NULL,
    ROOT                    TINYINT(1)         NOT NULL DEFAULT 0,
    PRIMARY KEY (`ID`),
    CONSTRAINT `FK_DATA_INTEGRATION` FOREIGN KEY (`DATA_INTEGRATION_SET_ID`) REFERENCES DATA_INTEGRATION_SET (`ID`)
) ENGINE = INNODB
  DEFAULT CHARSET = UTF8
  COLLATE = UTF8_BIN$$

CREATE TABLE IF NOT EXISTS DIF.DATA_INTEGRATION_FIELD
(
    ID                         INT(10)      NOT NULL AUTO_INCREMENT,
    DATA_INTEGRATION_RECORD_ID INT(10)      NOT NULL,
    FIELD_ID                   VARCHAR(255) NOT NULL,
    RELATION_RECORD_ID         INT(10),
    VALUE                      TEXT,
    INTEGRATED                 TINYINT(1)   NOT NULL DEFAULT 0,
    PRIMARY KEY (`ID`),
    CONSTRAINT `FK_DINTEGRATION_RELATION_REC` FOREIGN KEY (`DATA_INTEGRATION_RECORD_ID`) REFERENCES DATA_INTEGRATION_RECORD (`ID`),
    CONSTRAINT `FK_DINTEGRATION_RECORD` FOREIGN KEY (`DATA_INTEGRATION_RECORD_ID`) REFERENCES DATA_INTEGRATION_RECORD (`ID`)
) ENGINE = INNODB
  DEFAULT CHARSET = UTF8
  COLLATE = UTF8_BIN$$

-- ----------------------------------------------------------------------
-- Change column EVENT_DATE to TIMESTAMP from table `DIF`.`EVENT`
-- ----------------------------------------------------------------------
DROP PROCEDURE IF EXISTS changeColumn;
$$
CREATE PROCEDURE changeColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'EVENT'
      AND COLUMN_NAME = 'EVENT_DATE'
      AND DATA_TYPE = 'DATE';

    IF TOTAL > 0 THEN
        ALTER TABLE DIF.EVENT
            MODIFY COLUMN EVENT_DATE TIMESTAMP NULL;
    END IF;
END
$$
CALL changeColumn();
$$


-- ----------------------------------------------------------------------
-- Change column DATE_EVENT_PROCESS to TIMESTAMP from table `DIF`.`EVENT_LOG_PROCESS`
-- ----------------------------------------------------------------------
DROP PROCEDURE IF EXISTS changeColumn;
$$
CREATE PROCEDURE changeColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'EVENT_LOG_PROCESS'
      AND COLUMN_NAME = 'DATE_EVENT_PROCESS'
      AND DATA_TYPE = 'DATE';

    IF TOTAL > 0 THEN
        ALTER TABLE DIF.EVENT_LOG_PROCESS
            MODIFY COLUMN DATE_EVENT_PROCESS TIMESTAMP NULL;
    END IF;
END
$$
CALL changeColumn();
$$


-- ----------------------------------------------------------------------
-- Change column CONFIGURATION to NULLABLE from table `DIF`.`EVENT_SUBSCRIPTION`
-- ----------------------------------------------------------------------
DROP PROCEDURE IF EXISTS changeColumn;
$$
CREATE PROCEDURE changeColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'EVENT_SUBSCRIPTION'
      AND COLUMN_NAME = 'CONFIGURATION'
      AND IS_NULLABLE = 'NO';

    IF TOTAL > 0 THEN
        ALTER TABLE DIF.EVENT_SUBSCRIPTION
            MODIFY COLUMN CONFIGURATION VARCHAR(4000);
    END IF;
END
$$
CALL changeColumn();
$$