/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.utils.logging;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import pt.digitalis.dif.dem.managers.impl.audit.model.DIFDBAuditFactory;
import pt.digitalis.dif.dem.managers.impl.audit.model.IAuditService;
import pt.digitalis.dif.dem.managers.impl.audit.model.data.AuditLog;
import pt.digitalis.dif.dem.managers.impl.audit.model.data.AuditLogDetail;
import pt.digitalis.dif.dem.managers.impl.model.data.Acl;
import pt.digitalis.dif.dem.managers.impl.model.data.CustomMessages;
import pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments;
import pt.digitalis.dif.dem.managers.impl.model.data.ErrorLog;
import pt.digitalis.dif.dem.managers.impl.model.data.Groups;
import pt.digitalis.dif.dem.managers.impl.model.data.PersistentAction;
import pt.digitalis.dif.dem.managers.impl.model.data.PersistentForm;
import pt.digitalis.dif.dem.managers.impl.model.data.Server;
import pt.digitalis.dif.dem.managers.impl.model.data.ServerActivityLog;
import pt.digitalis.dif.dem.managers.impl.model.data.ServerMessage;
import pt.digitalis.dif.dem.managers.impl.model.data.UserAttributes;
import pt.digitalis.dif.dem.managers.impl.model.data.UserGroups;
import pt.digitalis.dif.dem.managers.impl.model.data.Users;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.hibernate.AuditDetail;
import pt.digitalis.dif.model.hibernate.IAuditingLogger;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;

public class AuditingLoggerDBImplementation
implements IAuditingLogger {
    private boolean isInitialized = false;
    private List<String> tablesNotToLOG = new ArrayList<String>();

    public void initialize(List<String> additionalTableNotToLog) {
        if (!this.isInitialized()) {
            this.tablesNotToLOG.add(AuditLog.class.getSimpleName());
            this.tablesNotToLOG.add(AuditLogDetail.class.getSimpleName());
            this.tablesNotToLOG.add(PersistentAction.class.getSimpleName());
            this.tablesNotToLOG.add(PersistentForm.class.getSimpleName());
            this.tablesNotToLOG.add(ErrorLog.class.getSimpleName());
            this.tablesNotToLOG.add(Acl.class.getSimpleName());
            this.tablesNotToLOG.add(CustomMessages.class.getSimpleName());
            this.tablesNotToLOG.add(Groups.class.getSimpleName());
            this.tablesNotToLOG.add(EcommercePayments.class.getSimpleName());
            this.tablesNotToLOG.add(UserAttributes.class.getSimpleName());
            this.tablesNotToLOG.add(UserGroups.class.getSimpleName());
            this.tablesNotToLOG.add(Users.class.getSimpleName());
            this.tablesNotToLOG.add(Server.class.getSimpleName());
            this.tablesNotToLOG.add(ServerActivityLog.class.getSimpleName());
            this.tablesNotToLOG.add(ServerMessage.class.getSimpleName());
            if (additionalTableNotToLog != null) {
                this.tablesNotToLOG.addAll(additionalTableNotToLog);
            }
            this.isInitialized = true;
        }
    }

    public boolean isAuditableEntity(String entityName) {
        if (!this.isInitialized()) {
            this.initialize(null);
        }
        return !this.tablesNotToLOG.contains(entityName);
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    public void logDelete(String entityName, String entityID, List<AuditDetail> details, String userName, String appName, String processName) throws Exception {
        this.logEntry(Character.valueOf('D'), entityName, entityID, details, userName, appName, processName);
    }

    protected void logEntry(Character operation, String entityName, String entityID, List<AuditDetail> details, String userName, String appName, String processName) throws DataSetException {
        if (this.isAuditableEntity(entityName)) {
            userName = StringUtils.nvl((String)userName, (String)"\u00abNo user logged\u00bb");
            appName = StringUtils.nvl((String)appName, (String)"\u00abUndetermined\u00bb");
            DIFLogger.getLogger().trace((Object)("Delete record of " + entityName + " issued by: " + userName + " (using \"" + appName + "\")"));
            boolean wasActive = DIFDBAuditFactory.openTransaction();
            IAuditService auditDB = (IAuditService)DIFIoCRegistry.getRegistry().getImplementation(IAuditService.class);
            AuditLog log = new AuditLog();
            log.setApp(appName);
            log.setProcess(processName);
            log.setEntityName(entityName);
            log.setInstanceId(entityID);
            log.setOperation(operation);
            log.setOperationDate(new Timestamp(new Date().getTime()));
            log.setUserid(userName);
            log = (AuditLog)auditDB.getAuditLogDataSet().insert((IBeanAttributes)log);
            for (AuditDetail detail : details) {
                AuditLogDetail logdetail = new AuditLogDetail();
                logdetail.setAuditLog(log);
                logdetail.setColumnName(detail.getFieldName());
                logdetail.setPreviousValue(this.truncTo4000(detail.getPreviousValue()));
                logdetail.setNewValue(this.truncTo4000(detail.getNewValue()));
                auditDB.getAuditLogDetailDataSet().insert((IBeanAttributes)logdetail);
            }
            if (!wasActive) {
                DIFDBAuditFactory.getSession().getTransaction().commit();
            }
        }
    }

    public void logInsert(String entityName, String entityID, List<AuditDetail> details, String userName, String appName, String processName) throws Exception {
        this.logEntry(Character.valueOf('C'), entityName, entityID, details, userName, appName, processName);
    }

    public void logUpdate(String entityName, String entityID, List<AuditDetail> details, String userName, String appName, String processName) throws Exception {
        this.logEntry(Character.valueOf('U'), entityName, entityID, details, userName, appName, processName);
    }

    private String truncTo4000(String value) {
        if (value == null) {
            return null;
        }
        return value.substring(0, Math.min(value.length(), 3999));
    }
}

