DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.CONVERSATION
(
    ID                           INT(10)      NOT NULL AUTO_INCREMENT,
    DESCRIPTION                  VARCHAR(1000),
    BUSINESS_PROCESS_TYPE_ID     VARCHAR(300) NOT NULL,
    BUSINESS_PROCESS_INSTANCE_ID VARCHAR(100) NOT NULL,
    CREATION_DATE                DATE,
    CLOSE_DATE                   DATE,
    IS_OPEN                      TINYINT(1)   NOT NULL DEFAULT 0,
    PRIMARY KEY (`ID`)
) ENGINE = INNODB
  DEFAULT CHARSET = UTF8
  COLLATE = UTF8_BIN$$

CREATE TABLE IF NOT EXISTS DIF.CONVERSATION_MESSAGE
(
    ID               INT(10)      NOT NULL AUTO_INCREMENT,
    CONVERSATION_ID  INT(10)      NOT NULL,
    CREATION_DATE    DATE         NOT NULL,
    MESSAGE          VARCHAR(500) NOT NULL,
    DETAILS          LONGTEXT,
    FILE_TYPE        ENUM ('W','E','S','A'),
    IS_PRIVATE       TINYINT(1)   NOT NULL DEFAULT 0,
    USER_ID          VARCHAR(300),
    USER_DESCRIPTION VARCHAR(500),
    USER_BUSINESS_ID VARCHAR(300),
    DOCUMENT_ID      INT(10),
    PRIMARY KEY (`ID`),
    CONSTRAINT `CONVERSATION_ID_FK` FOREIGN KEY (`CONVERSATION_ID`) REFERENCES CONVERSATION (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE = INNODB
  DEFAULT CHARSET = UTF8
  COLLATE = UTF8_BIN$$

CREATE TABLE IF NOT EXISTS DIF.FILE_TYPE
(
    ID                       INT(10)      NOT NULL AUTO_INCREMENT,
    NAME                     VARCHAR(200) NOT NULL,
    DESCRIPTION              VARCHAR(500),
    BUSINESS_PROCESS_TYPE_ID VARCHAR(300),
    MIME_TYPES               VARCHAR(200),
    MAX_FILE_SIZE            INT(10),
    PRIMARY KEY (`ID`)
) ENGINE = INNODB
  DEFAULT CHARSET = UTF8
  COLLATE = UTF8_BIN$$

CREATE TABLE IF NOT EXISTS DIF.FILE_BUNDLE
(
    ID                           INT(10)    NOT NULL AUTO_INCREMENT,
    DESCRIPTION                  VARCHAR(500),
    BUSINESS_PROCESS_TYPE_ID     VARCHAR(300),
    BUSINESS_PROCESS_INSTANCE_ID VARCHAR(100),
    CREATION_DATE                DATE,
    IS_OPEN                      TINYINT(1) NOT NULL DEFAULT 1,
    CLOSE_DATE                   DATE,
    PRIMARY KEY (`ID`)
) ENGINE = INNODB
  DEFAULT CHARSET = UTF8
  COLLATE = UTF8_BIN$$

CREATE TABLE IF NOT EXISTS DIF.FILE_BUNDLE_FILE
(
    ID                        INT(10)       NOT NULL AUTO_INCREMENT,
    FILE_BUNDLE_ID            INT(10)       NOT NULL,
    TITLE                     VARCHAR(1000) NOT NULL,
    DESCRIPTION               VARCHAR(4000),
    TYPE_ID                   INT(10),
    DOCUMENT_ID               INT(10)       NOT NULL,
    IS_PRIVATE                TINYINT(1)    NOT NULL DEFAULT 0,
    IS_VALID                  TINYINT(1)    NOT NULL DEFAULT 0,
    UPLOAD_USER_ID            VARCHAR(300),
    UPLOAD_DATE               DATE,
    UPLOAD_USER_BUSINESS_ID   VARCHAR(300),
    VALIDATE_USER_ID          VARCHAR(300),
    VALIDATE_DATE             DATE,
    VALIDATE_USER_BUSINESS_ID VARCHAR(300),
    PRIMARY KEY (`ID`),
    CONSTRAINT `FILE_BUNDLE_ID_FK` FOREIGN KEY (`FILE_BUNDLE_ID`) REFERENCES FILE_BUNDLE (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION,
    CONSTRAINT `FILE_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES FILE_TYPE (`ID`)
) ENGINE = INNODB
  DEFAULT CHARSET = UTF8
  COLLATE = UTF8_BIN
$$
