DECLARE
    TOTAL NUMBER;
BEGIN

    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'REPORT_INSTANCE_AREA'
      AND COLUMN_NAME = 'GENERATED_CONTENT';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE_AREA ADD GENERATED_CONTENT CLOB';
    END IF;
END;
/

comment on column DIF.REPORT_INSTANCE_AREA.generated_content is 'The content generated for a dynamic area';