package pt.digitalis.dif.documents.model.impl;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.documents.model.IDocumentsService;
import pt.digitalis.dif.documents.model.dao.IDocumentsDAO;
import pt.digitalis.dif.documents.model.dao.impl.DocumentsDAOImpl;
import pt.digitalis.dif.documents.model.data.Documents;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public class DocumentsServiceImpl implements IDocumentsService {

    /**
     * Obtains a new Documents DAO
     *
     * @return A new IDocumentsDAO
     */
    public IDocumentsDAO getDocumentsDAO()
    {
        return new DocumentsDAOImpl();
    }

    /**
     * Obtains a new DataSet for the Documents entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Documents> getDocumentsDataSet()
    {
        return new HibernateDataSet<Documents>(Documents.class, new DocumentsDAOImpl(),
                Documents.getPKFieldListAsString());
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz)
    {

        if (clazz == Documents.class)
            return getDocumentsDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName)
    {

        if (entityName.equalsIgnoreCase(Documents.class.getSimpleName()))
            return getDocumentsDataSet();

        return null;
    }
}