package pt.digitalis.dif.documents.model.dao.auto.impl;

import static org.hibernate.criterion.Example.create;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;

import pt.digitalis.dif.documents.model.DocumentsFactory;
import pt.digitalis.dif.documents.model.dao.auto.IAutoDocumentsDAO;
import pt.digitalis.dif.documents.model.data.Documents;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/**
 * Home object for domain model class Documents. Generated by ORM Generator DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.documents.model.data.Documents
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoDocumentsDAOImpl implements IAutoDocumentsDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Constructor
     */
    public AutoDocumentsDAOImpl()
    {
        this.logger = DIFLogger.getLogger();
    }

    /**
     * Attach an unmodified Documents instance in the persistence layer
     *
     * @param instance
     *            to attach
     */
    public void attachClean(Documents instance)
    {
        logger.debug("attaching clean Documents instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

    /**
     * Updates a modified Documents in the persistence layer and reattaches them together
     *
     * @param instance
     *            to update/attach
     */
    public void attachDirty(Documents instance)
    {
        logger.debug("attaching dirty Documents instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

    /**
     * Removes a Documents instance from the persistence layer
     *
     * @param persistentInstance
     *            to remove/deletes
     */
    public void delete(Documents persistentInstance)
    {
        logger.debug("deleting Documents instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

    /**
     * Gets a {@link List} of all Documents instances in the persistence layer
     *
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    public List<Documents> findAll()
    {

        List<Documents> instances = new ArrayList<Documents>();
        logger.debug("getting all Documents instances");
        instances = getSession().createCriteria(Documents.class).list();
        if (instances.size() > 0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Documents>) instances;
    }

    /**
     * Gets a {@link List} of all Documents instances in the persistence layer than match the creationDate attribute
     * with the given value
     *
     * @param creationDate
     *            to match
     * @return the {@link List} of instances
     */
    public List<Documents> findByCreationDate(Date creationDate)
    {
        Documents instance = new Documents();

        instance.setCreationDate(creationDate);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all Documents instances in the persistence layer than match the creator attribute with the
     * given value
     *
     * @param creator
     *            to match
     * @return the {@link List} of instances
     */
    public List<Documents> findByCreator(String creator)
    {
        Documents instance = new Documents();

        instance.setCreator(creator);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all Documents instances in the persistence layer than match the description attribute with
     * the given value
     *
     * @param description
     *            to match
     * @return the {@link List} of instances
     */
    public List<Documents> findByDescription(String description)
    {
        Documents instance = new Documents();

        instance.setDescription(description);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all Documents instances in the persistence layer than match the document attribute with
     * the given value
     *
     * @param document
     *            to match
     * @return the {@link List} of instances
     */
    public List<Documents> findByDocument(Blob document)
    {
        Documents instance = new Documents();

        instance.setDocument(document);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all Documents instances in the persistence layer than match the example of the given
     * instance
     *
     * @param instance
     *            to use as an example to the search
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    protected List<Documents> findByExample(Documents instance)
    {
        logger.debug("finding Documents instance by example");
        List<Documents> results = (List<Documents>) getSession().createCriteria(Documents.class).add(create(instance))
                .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

    /**
     * Gets a {@link List} of all Documents instances in the persistence layer than partially match the given field with
     * the given value
     *
     * @param field
     *            to match against
     * @param value
     *            to match
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    public List<Documents> findByFieldParcial(Documents.Fields field, String value)
    {
        logger.debug("finding Documents instance by parcial value: " + field + " like " + value);
        List<Documents> results = (List<Documents>) getSession().createCriteria(Documents.class)
                .add(Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase()).list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

    /**
     * Gets a {@link List} of all Documents instances in the persistence layer than match the filename attribute with
     * the given value
     *
     * @param filename
     *            to match
     * @return the {@link List} of instances
     */
    public List<Documents> findByFilename(String filename)
    {
        Documents instance = new Documents();

        instance.setFilename(filename);

        return findByExample(instance);
    }

    /**
     * Finds a Documents instance in the persistence layer with the given id
     *
     * @param id
     *            to search
     * @return the found instance
     */
    public Documents findById(java.lang.Long id)
    {
        logger.debug("getting Documents instance with id: " + id);
        Documents instance = (Documents) getSession().get(Documents.class, id);
        if (instance == null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }

    /**
     * Gets a {@link List} of all Documents instances in the persistence layer than match the mimeType attribute with
     * the given value
     *
     * @param mimeType
     *            to match
     * @return the {@link List} of instances
     */
    public List<Documents> findByMimeType(String mimeType)
    {
        Documents instance = new Documents();

        instance.setMimeType(mimeType);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all Documents instances in the persistence layer than match the name attribute with the
     * given value
     *
     * @param name
     *            to match
     * @return the {@link List} of instances
     */
    public List<Documents> findByName(String name)
    {
        Documents instance = new Documents();

        instance.setName(name);

        return findByExample(instance);
    }

    /**
     * Obtains a new DataSet for the Documents entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Documents> getDocumentsDataSet()
    {
        return new HibernateDataSet<Documents>(Documents.class, this, Documents.getPKFieldListAsString());
    }

    /**
     * Retrieves the injected {@link Session} object
     *
     * @return the session
     */
    public Session getSession()
    {
        return DocumentsFactory.getSession();
    }

    /**
     * Merge a Documents instance back to the persistence layer updating it with the given instance data
     *
     * @param detachedInstance
     *            to update/merge
     * @return the merged instance
     */
    public Documents merge(Documents detachedInstance)
    {
        logger.debug("merging Documents instance");
        Documents result = (Documents) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

    /**
     * Persist a Documents object to the persistence layer
     *
     * @param transientInstance
     *            to persist
     */
    public void persist(Documents transientInstance)
    {
        logger.debug("persisting Documents instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

}
