/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.documents.model.dao.auto.impl;

import java.io.Serializable;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.documents.model.DocumentsFactory;
import pt.digitalis.dif.documents.model.dao.auto.IAutoDocumentsDAO;
import pt.digitalis.dif.documents.model.data.Documents;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoDocumentsDAOImpl
implements IAutoDocumentsDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public void attachClean(Documents instance) {
        this.logger.debug((Object)"attaching clean Documents instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachDirty(Documents instance) {
        this.logger.debug((Object)"attaching dirty Documents instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Documents persistentInstance) {
        this.logger.debug((Object)"deleting Documents instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public List<Documents> findAll() {
        List<Documents> instances = new ArrayList();
        this.logger.debug((Object)"getting all Documents instances");
        instances = this.getSession().createCriteria(Documents.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    @Override
    public List<Documents> findByCreationDate(Date creationDate) {
        Documents instance = new Documents();
        instance.setCreationDate(creationDate);
        return this.findByExample(instance);
    }

    @Override
    public List<Documents> findByCreator(String creator) {
        Documents instance = new Documents();
        instance.setCreator(creator);
        return this.findByExample(instance);
    }

    @Override
    public List<Documents> findByDescription(String description) {
        Documents instance = new Documents();
        instance.setDescription(description);
        return this.findByExample(instance);
    }

    @Override
    public List<Documents> findByDocument(Blob document) {
        Documents instance = new Documents();
        instance.setDocument(document);
        return this.findByExample(instance);
    }

    protected List<Documents> findByExample(Documents instance) {
        this.logger.debug((Object)"finding Documents instance by example");
        List results = this.getSession().createCriteria(Documents.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Documents> findByFieldParcial(Documents.Fields field, String value) {
        this.logger.debug((Object)("finding Documents instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Documents.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Documents> findByFilename(String filename) {
        Documents instance = new Documents();
        instance.setFilename(filename);
        return this.findByExample(instance);
    }

    @Override
    public Documents findById(Long id) {
        this.logger.debug((Object)("getting Documents instance with id: " + id));
        Documents instance = (Documents)this.getSession().get(Documents.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Documents> findByMimeType(String mimeType) {
        Documents instance = new Documents();
        instance.setMimeType(mimeType);
        return this.findByExample(instance);
    }

    @Override
    public List<Documents> findByName(String name) {
        Documents instance = new Documents();
        instance.setName(name);
        return this.findByExample(instance);
    }

    @Override
    public IDataSet<Documents> getDocumentsDataSet() {
        return new HibernateDataSet(Documents.class, (IHibernateDAO)this, Documents.getPKFieldListAsString());
    }

    public Session getSession() {
        return DocumentsFactory.getSession();
    }

    @Override
    public Documents merge(Documents detachedInstance) {
        this.logger.debug((Object)"merging Documents instance");
        Documents result = (Documents)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public void persist(Documents transientInstance) {
        this.logger.debug((Object)"persisting Documents instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }
}

