/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.documents.repository;

import java.io.IOException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicMatch;
import org.hibernate.Session;
import pt.digitalis.dif.documents.model.DocumentsFactory;
import pt.digitalis.dif.documents.model.IDocumentsService;
import pt.digitalis.dif.documents.model.data.Documents;
import pt.digitalis.dif.documents.repository.DocumentRepositoryConfiguration;
import pt.digitalis.dif.documents.repository.DocumentRepositoryEntryDB;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.utils.extensions.document.AbstractDocumentRepository;
import pt.digitalis.dif.utils.extensions.document.DocumentRepositoryEntry;
import pt.digitalis.dif.utils.extensions.document.DocumentRepositoryException;
import pt.digitalis.dif.utils.extensions.document.MaximumDocumentSizeException;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentRepositoryDBImpl
extends AbstractDocumentRepository {
    private final Integer maxDocumentSize;

    private static synchronized Documents convertToDocument(DocumentRepositoryEntry document) {
        Documents entry = new Documents();
        entry.setDocument(DocumentsFactory.getLobHelper().createBlob(document.getBytes()));
        entry.setCreationDate(document.getCreationDate());
        entry.setCreator(document.getCreatorID());
        entry.setDescription(document.getDescription());
        entry.setFilename(document.getFileName());
        entry.setId(document.getId());
        entry.setMimeType(document.getMimeType());
        entry.setName(document.getName());
        return entry;
    }

    private static synchronized DocumentRepositoryEntry convertToDocumentRepositoryEntry(Documents document) throws SQLException, IOException {
        return DocumentRepositoryDBImpl.convertToDocumentRepositoryEntry(document, false);
    }

    private static synchronized DocumentRepositoryEntry convertToDocumentRepositoryEntry(Documents document, boolean lazyLoadFile) throws SQLException, IOException {
        DocumentRepositoryEntryDB entry = new DocumentRepositoryEntryDB();
        if (!lazyLoadFile) {
            Blob aBlob = document.getDocument();
            byte[] bytes = new byte[new Long(aBlob.length()).intValue()];
            aBlob.getBinaryStream().read(bytes);
            entry.setBytes(bytes);
            if (StringUtils.isNotBlank((String)document.getMimeType())) {
                entry.setMimeType(document.getMimeType());
            } else {
                try {
                    MagicMatch match = Magic.getMagicMatch((byte[])entry.getBytes());
                    entry.setMimeType(match.getMimeType());
                }
                catch (Exception e) {
                    return null;
                }
            }
        } else {
            entry.setaBlob(document.getDocument());
            entry.setMimeType(document.getMimeType());
        }
        entry.setCreationDate(document.getCreationDate());
        entry.setCreatorID(document.getCreator());
        entry.setDescription(document.getDescription());
        entry.setFileName(document.getFilename());
        entry.setId(document.getId());
        entry.setName(document.getName());
        return entry;
    }

    public DocumentRepositoryDBImpl() {
        this(DocumentRepositoryConfiguration.getInstance().getMaxDocumentSize());
    }

    public DocumentRepositoryDBImpl(Integer maxDocumentSize) {
        this.maxDocumentSize = maxDocumentSize;
    }

    public synchronized DocumentRepositoryEntry addDocument(DocumentRepositoryEntry arg0) throws DocumentRepositoryException {
        return this.addDocument(arg0, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized DocumentRepositoryEntry addDocument(DocumentRepositoryEntry documentEntry, Boolean ignoreSizeLimit) throws DocumentRepositoryException {
        if (!ignoreSizeLimit.booleanValue() && this.maxDocumentSize != null && documentEntry.getBytes().length / 1024 > this.maxDocumentSize) throw new MaximumDocumentSizeException("The Document exceeds the maximum size of " + this.maxDocumentSize + "Kb", this.maxDocumentSize);
        Documents document = DocumentRepositoryDBImpl.convertToDocument(documentEntry);
        IDocumentsService documentsService = (IDocumentsService)DIFIoCRegistry.getRegistry().getImplementation(IDocumentsService.class);
        boolean isActive = documentsService.getDocumentsDAO().getSession().getTransaction().isActive();
        try {
            if (!isActive) {
                documentsService.getDocumentsDAO().getSession().beginTransaction();
            }
            documentsService.getDocumentsDAO().persist(document);
            documentEntry = DocumentRepositoryDBImpl.convertToDocumentRepositoryEntry(document);
            if (isActive) return documentEntry;
            documentsService.getDocumentsDAO().getSession().getTransaction().commit();
            return documentEntry;
        }
        catch (Exception e) {
            if (isActive) throw new DocumentRepositoryException("There was a problem inserting document on database " + e);
            documentsService.getDocumentsDAO().getSession().getTransaction().rollback();
            throw new DocumentRepositoryException("There was a problem inserting document on database " + e);
        }
    }

    public synchronized void deleteDocument(Long documentID) throws DocumentRepositoryException {
        IDocumentsService documentsService = (IDocumentsService)DIFIoCRegistry.getRegistry().getImplementation(IDocumentsService.class);
        try {
            documentsService.getDocumentsDataSet().delete(documentID.toString());
        }
        catch (DataSetException e) {
            throw new DocumentRepositoryException((Exception)((Object)e));
        }
    }

    public synchronized DocumentRepositoryEntry getDocument(Long documentID) throws DocumentRepositoryException {
        return this.getDocument(documentID, true);
    }

    public DocumentRepositoryEntry getDocument(Long documentID, boolean lazyLoadFile) throws DocumentRepositoryException {
        if (documentID == null) {
            return null;
        }
        IDocumentsService documentsService = (IDocumentsService)DIFIoCRegistry.getRegistry().getImplementation(IDocumentsService.class);
        Session session = documentsService.getDocumentsDAO().getSession();
        Boolean wasActive = session.getTransaction().isActive();
        try {
            if (!wasActive.booleanValue()) {
                documentsService.getDocumentsDAO().getSession().beginTransaction();
            }
            Documents document = (Documents)documentsService.getDocumentsDataSet().get(documentID.toString());
            DocumentRepositoryEntry entry = null;
            if (document != null) {
                entry = DocumentRepositoryDBImpl.convertToDocumentRepositoryEntry(document, lazyLoadFile);
            }
            if (!wasActive.booleanValue()) {
                documentsService.getDocumentsDAO().getSession().getTransaction().commit();
            }
            return entry;
        }
        catch (SQLException e) {
            if (!wasActive.booleanValue()) {
                documentsService.getDocumentsDAO().getSession().getTransaction().rollback();
            }
            throw new DocumentRepositoryException((Exception)e);
        }
        catch (IOException e) {
            if (!wasActive.booleanValue()) {
                documentsService.getDocumentsDAO().getSession().getTransaction().rollback();
            }
            throw new DocumentRepositoryException((Exception)e);
        }
        catch (DataSetException e) {
            if (!wasActive.booleanValue()) {
                documentsService.getDocumentsDAO().getSession().getTransaction().rollback();
            }
            throw new DocumentRepositoryException((Exception)((Object)e));
        }
    }

    public synchronized List<DocumentRepositoryEntry> getDocumentByOriginalFileName(String fileName) throws DocumentRepositoryException {
        IDocumentsService documentsService = (IDocumentsService)DIFIoCRegistry.getRegistry().getImplementation(IDocumentsService.class);
        try {
            Query query = documentsService.getDocumentsDataSet().query();
            query.addFilter(new Filter("filename".toString(), FilterType.EQUALS, fileName));
            ArrayList<DocumentRepositoryEntry> result = new ArrayList<DocumentRepositoryEntry>();
            for (Documents document : query.asList()) {
                result.add(DocumentRepositoryDBImpl.convertToDocumentRepositoryEntry(document));
            }
            return result;
        }
        catch (SQLException e) {
            throw new DocumentRepositoryException((Exception)e);
        }
        catch (IOException e) {
            throw new DocumentRepositoryException((Exception)e);
        }
        catch (DataSetException e) {
            throw new DocumentRepositoryException((Exception)((Object)e));
        }
    }

    public synchronized List<DocumentRepositoryEntry> getDocumentsByCreator(String creatorID) throws DocumentRepositoryException {
        IDocumentsService documentsService = (IDocumentsService)DIFIoCRegistry.getRegistry().getImplementation(IDocumentsService.class);
        try {
            Query query = documentsService.getDocumentsDataSet().query();
            query.addFilter(new Filter("creator".toString(), FilterType.EQUALS, creatorID));
            ArrayList<DocumentRepositoryEntry> result = new ArrayList<DocumentRepositoryEntry>();
            for (Documents document : query.asList()) {
                result.add(DocumentRepositoryDBImpl.convertToDocumentRepositoryEntry(document));
            }
            return result;
        }
        catch (SQLException e) {
            throw new DocumentRepositoryException((Exception)e);
        }
        catch (IOException e) {
            throw new DocumentRepositoryException((Exception)e);
        }
        catch (DataSetException e) {
            throw new DocumentRepositoryException((Exception)((Object)e));
        }
    }

    public synchronized List<DocumentRepositoryEntry> getDocumentsByIds(List<Long> documentIds) throws DocumentRepositoryException {
        IDocumentsService documentsService = (IDocumentsService)DIFIoCRegistry.getRegistry().getImplementation(IDocumentsService.class);
        ArrayList<DocumentRepositoryEntry> documents = new ArrayList<DocumentRepositoryEntry>();
        try {
            Query query = documentsService.getDocumentsDataSet().query();
            query.addFilter(new Filter("id".toString(), FilterType.IN, CollectionUtils.listToCommaSeparatedString(documentIds)));
            for (Documents document : query.asList()) {
                DocumentRepositoryEntry entry = DocumentRepositoryDBImpl.convertToDocumentRepositoryEntry(document);
                documents.add(entry);
            }
        }
        catch (SQLException e) {
            throw new DocumentRepositoryException((Exception)e);
        }
        catch (IOException e) {
            throw new DocumentRepositoryException((Exception)e);
        }
        catch (DataSetException e) {
            throw new DocumentRepositoryException((Exception)((Object)e));
        }
        return documents;
    }

    public synchronized DocumentRepositoryEntry updateDocument(DocumentRepositoryEntry documentEntry) {
        IDocumentsService documentsService = (IDocumentsService)DIFIoCRegistry.getRegistry().getImplementation(IDocumentsService.class);
        Documents document = DocumentRepositoryDBImpl.convertToDocument(documentEntry);
        boolean isActive = documentsService.getDocumentsDAO().getSession().getTransaction().isActive();
        if (!isActive) {
            documentsService.getDocumentsDAO().getSession().beginTransaction();
        }
        documentsService.getDocumentsDAO().merge(document);
        document.setDocument(DocumentsFactory.getLobHelper().createBlob(documentEntry.getBytes()));
        if (!isActive) {
            documentsService.getDocumentsDAO().getSession().getTransaction().commit();
        }
        try {
            documentEntry = this.getDocument(documentEntry.getId());
        }
        catch (DocumentRepositoryException e) {
            e.printStackTrace();
        }
        return documentEntry;
    }
}

