package pt.digitalis.dif.documents.model.data;


import java.sql.Blob;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.utils.common.DateUtils;

/**
 * Documents
 * Generated on ORM Generator
 * DIF build process for the Model layer
 *
 */
@SuppressWarnings("serial")
public class Documents extends AbstractBeanRelationsAttributes implements java.io.Serializable {

    /** Documents attributes enumeration */
    public static class Fields {
        /** id column */
        public static final String ID = "id";
        /** document column */
        public static final String DOCUMENT = "document";
        /** creator column */
        public static final String CREATOR = "creator";
        /** name column */
        public static final String NAME = "name";
        /** description column */
        public static final String DESCRIPTION = "description";
        /** filename column */
        public static final String FILENAME = "filename";
        /** creationDate column */
        public static final String CREATIONDATE = "creationDate";
        /** mimeType column */
        public static final String MIMETYPE = "mimeType";
        /** expireOn column */
        public static final String EXPIREON = "expireOn";

	    /**
          * List of existing fields
	     *
	     * @return list of field names
	     */
        public static List<String> values() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("document");
            list.add("creator");
            list.add("name");
            list.add("description");
            list.add("filename");
            list.add("creationDate");
            list.add("mimeType");
            list.add("expireOn");

            return list;
        }
    }

	/**
 	 * The Class Relations.
 	 */
	 public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations {

        /**
         * Instantiates a new relations.
         *
         * @param currentPath
         *            the current path
         */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
		/**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
		/**
         * the DOCUMENT path.
         *
         * @return the path
         */
        public String DOCUMENT()
        {
            return buildPath(Fields.DOCUMENT);
        }
		/**
         * the CREATOR path.
         *
         * @return the path
         */
        public String CREATOR()
        {
            return buildPath(Fields.CREATOR);
        }
		/**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
		/**
         * the DESCRIPTION path.
         *
         * @return the path
         */
        public String DESCRIPTION()
        {
            return buildPath(Fields.DESCRIPTION);
        }
		/**
         * the FILENAME path.
         *
         * @return the path
         */
        public String FILENAME()
        {
            return buildPath(Fields.FILENAME);
        }
		/**
         * the CREATIONDATE path.
         *
         * @return the path
         */
        public String CREATIONDATE()
        {
            return buildPath(Fields.CREATIONDATE);
        }
		/**
         * the MIMETYPE path.
         *
         * @return the path
         */
        public String MIMETYPE()
        {
            return buildPath(Fields.MIMETYPE);
        }
		/**
         * the EXPIREON path.
         *
         * @return the path
         */
        public String EXPIREON()
        {
            return buildPath(Fields.EXPIREON);
        }
    }
	
	/** The dummy obj. */
    private static Documents dummyObj = new Documents();

	/**
     * Get Documents Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    @Override
    protected Object getAttributeNoGraphNavigation(String attributeName) {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("document".equalsIgnoreCase(attributeName))
            return document;
        if ("creator".equalsIgnoreCase(attributeName))
            return creator;
        if ("name".equalsIgnoreCase(attributeName))
            return name;
        if ("description".equalsIgnoreCase(attributeName))
            return description;
        if ("filename".equalsIgnoreCase(attributeName))
            return filename;
        if ("creationDate".equalsIgnoreCase(attributeName))
            return creationDate;
        if ("mimeType".equalsIgnoreCase(attributeName))
            return mimeType;
        if ("expireOn".equalsIgnoreCase(attributeName))
            return expireOn;

        return null;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    @SuppressWarnings("all")
    public void setAttribute(String attributeName, Object attributeValue) {

        if ("id".equalsIgnoreCase(attributeName))
            id = (Long)attributeValue;
        if ("document".equalsIgnoreCase(attributeName))
            document = (Blob)attributeValue;
        if ("creator".equalsIgnoreCase(attributeName))
            creator = (String)attributeValue;
        if ("name".equalsIgnoreCase(attributeName))
            name = (String)attributeValue;
        if ("description".equalsIgnoreCase(attributeName))
            description = (String)attributeValue;
        if ("filename".equalsIgnoreCase(attributeName))
            filename = (String)attributeValue;
        if ("creationDate".equalsIgnoreCase(attributeName))
            creationDate = (Date)attributeValue;
        if ("mimeType".equalsIgnoreCase(attributeName))
            mimeType = (String)attributeValue;
        if ("expireOn".equalsIgnoreCase(attributeName))
            expireOn = (Date)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** document private attribute */
    private Blob document;

    /** creator private attribute */
    private String creator;

    /** name private attribute */
    private String name;

    /** description private attribute */
    private String description;

    /** filename private attribute */
    private String filename;

    /** creationDate private attribute */
    private Date creationDate;

    /** mimeType private attribute */
    private String mimeType;

    /** expireOn private attribute */
    private Date expireOn;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            if ("creationDate".equalsIgnoreCase(attributeName))
        	    return DateUtils.simpleDateToString((Date)value);
            if ("expireOn".equalsIgnoreCase(attributeName))
        	    return DateUtils.simpleDateToString((Date)value);
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public Documents() {
    }

	/** 
	 * minimal constructor
	 *
     * @param document
     * @param creationDate
    }
	 */
    public Documents(Blob document, Date creationDate) {
        this.document = document;
        this.creationDate = creationDate;
    }

    /**
     * full constructor
	 *
     * @param document
     * @param creator
     * @param name
     * @param description
     * @param filename
     * @param creationDate
     * @param mimeType
     * @param expireOn
     */
    public Documents(Blob document, String creator, String name, String description, String filename, Date creationDate, String mimeType, Date expireOn) {
        this.document = document;
        this.creator = creator;
        this.name = name;
        this.description = description;
        this.filename = filename;
        this.creationDate = creationDate;
        this.mimeType = mimeType;
        this.expireOn = expireOn;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id
     *
     * @return Documents modified instance
     */
    public Documents setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * document getter method
     *
     * @return document method
     */
    public Blob getDocument() {
        return this.document;
    }
    
    /**       
     * document setter method
     *
     * @param document
     *
     * @return Documents modified instance
     */
    public Documents setDocument(Blob document) {
        this.document = document;
        
        return this;
    }
    /**       
     * creator getter method
     *
     * @return creator method
     */
    public String getCreator() {
        return this.creator;
    }
    
    /**       
     * creator setter method
     *
     * @param creator
     *
     * @return Documents modified instance
     */
    public Documents setCreator(String creator) {
        this.creator = creator;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name
     *
     * @return Documents modified instance
     */
    public Documents setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * description getter method
     *
     * @return description method
     */
    public String getDescription() {
        return this.description;
    }
    
    /**       
     * description setter method
     *
     * @param description
     *
     * @return Documents modified instance
     */
    public Documents setDescription(String description) {
        this.description = description;
        
        return this;
    }
    /**       
     * filename getter method
     *
     * @return filename method
     */
    public String getFilename() {
        return this.filename;
    }
    
    /**       
     * filename setter method
     *
     * @param filename
     *
     * @return Documents modified instance
     */
    public Documents setFilename(String filename) {
        this.filename = filename;
        
        return this;
    }
    /**       
     * creationDate getter method
     *
     * @return creationDate method
     */
    public Date getCreationDate() {
        return this.creationDate;
    }
    
    /**       
     * creationDate setter method
     *
     * @param creationDate
     *
     * @return Documents modified instance
     */
    public Documents setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        
        return this;
    }
    /**       
     * mimeType getter method
     *
     * @return mimeType method
     */
    public String getMimeType() {
        return this.mimeType;
    }
    
    /**       
     * mimeType setter method
     *
     * @param mimeType
     *
     * @return Documents modified instance
     */
    public Documents setMimeType(String mimeType) {
        this.mimeType = mimeType;
        
        return this;
    }
    /**       
     * expireOn getter method
     *
     * @return expireOn method
     */
    public Date getExpireOn() {
        return this.expireOn;
    }
    
    /**       
     * expireOn setter method
     *
     * @param expireOn
     *
     * @return Documents modified instance
     */
    public Documents setExpireOn(Date expireOn) {
        this.expireOn = expireOn;
        
        return this;
    }

    /**
     * Creates a String representation of the Documents object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("document").append("='").append(getDocument()).append("' ");			
        buffer.append("creator").append("='").append(getCreator()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("description").append("='").append(getDescription()).append("' ");			
        buffer.append("filename").append("='").append(getFilename()).append("' ");			
        buffer.append("creationDate").append("='").append(getCreationDate()).append("' ");			
        buffer.append("mimeType").append("='").append(getMimeType()).append("' ");			
        buffer.append("expireOn").append("='").append(getExpireOn()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the Documents object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(Documents other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("creator".equalsIgnoreCase(attributeName))
        	this.creator = attributeValue;

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("description".equalsIgnoreCase(attributeName))
        	this.description = attributeValue;

        if ("filename".equalsIgnoreCase(attributeName))
        	this.filename = attributeValue;

        if ("creationDate".equalsIgnoreCase(attributeName))
	        try {
        	    this.creationDate = DateUtils.stringToSimpleDate(attributeValue);
	        } catch (ParseException e) {
	            // Do nothing. The value will not be set!
	        }

        if ("mimeType".equalsIgnoreCase(attributeName))
        	this.mimeType = attributeValue;

        if ("expireOn".equalsIgnoreCase(attributeName))
	        try {
        	    this.expireOn = DateUtils.stringToSimpleDate(attributeValue);
	        } catch (ParseException e) {
	            // Do nothing. The value will not be set!
	        }

    }


}
