DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DOCUMENT_REPOSITORY'
  AND    TABLE_NAME = 'DOCUMENTS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
		'CREATE TABLE DOCUMENT_REPOSITORY.DOCUMENTS '||
		'( '||
		' ID            NUMBER NOT NULL, '||
		' DOCUMENT      BLOB NOT NULL, '||
		' CREATOR       VARCHAR2(1000), '||
		' NAME          VARCHAR2(1000), '||
		' DESCRIPTION   VARCHAR2(1000), '||
		' FILENAME      VARCHAR2(1000), '||
		' CREATION_DATE DATE NOT NULL, '||
		' MIME_TYPE     VARCHAR2(100) '||
		' ); ';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
	SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DOCUMENT_REPOSITORY'
  AND    TABLE_NAME      = 'DOCUMENTS'
  AND    CONSTRAINT_NAME = 'ID';

  IF TOTAL = 0 THEN
  	EXECUTE IMMEDIATE 'ALTER TABLE DOCUMENT_REPOSITORY.DOCUMENTS ADD CONSTRAINT ID PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
	SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DOCUMENT_REPOSITORY'
  AND    SEQUENCE_NAME   = 'DOCUMENT_ID';

  IF TOTAL = 0 THEN
  	EXECUTE IMMEDIATE 'CREATE SEQUENCE DOCUMENT_REPOSITORY.DOCUMENT_ID START WITH 1 INCREMENT BY 1 NOMAXVALUE';
  END IF;
END;
/

CREATE OR REPLACE TRIGGER DOCUMENT_REPOSITORY.DOCUMENT_BFR_INS
BEFORE INSERT ON DOCUMENT_REPOSITORY.DOCUMENTS
FOR EACH ROW
BEGIN
  IF :NEW.ID IS NULL THEN
     SELECT DOCUMENT_REPOSITORY.DOCUMENT_ID.NEXTVAL INTO :NEW.ID
     FROM DUAL;
  END IF;
END;
/

COMMENT ON COLUMN DOCUMENT_REPOSITORY.DOCUMENTS.ID IS 'O IDENTIFICADOR DO DOCUMENTO';

COMMENT ON COLUMN DOCUMENT_REPOSITORY.DOCUMENTS.DOCUMENT IS 'O DOCUMENTO.';
