/**
 * 2017, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.documents.repository;

import java.io.IOException;
import java.sql.Blob;
import java.sql.SQLException;

import pt.digitalis.dif.utils.extensions.document.DocumentRepositoryEntry;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created 15/05/2017
 */
public class DocumentRepositoryEntryDB extends DocumentRepositoryEntry {

    /**  */
    private static final long serialVersionUID = 1L;

    /** The a blob. */
    private Blob aBlob = null;

    /**
     * @see pt.digitalis.dif.utils.extensions.document.DocumentRepositoryEntry#getBytes()
     */
    @Override
    public byte[] getBytes()
    {
        if (aBlob != null && super.getBytes() == null)
        {
            byte[] bytes;
            try
            {
                bytes = new byte[new Long(aBlob.length()).intValue()];
                aBlob.getBinaryStream().read(bytes);
                super.setBytes(bytes);
            }
            catch (SQLException e)
            {
                e.printStackTrace();
            }
            catch (IOException e)
            {
                e.printStackTrace();
            }

        }
        return super.getBytes();
    }

    /**
     * Modifier for the 'aBlob' attribute.
     *
     * @param aBlob
     *            the new aBlob value to set
     */
    public void setaBlob(Blob aBlob)
    {
        this.aBlob = aBlob;
    }

}
