DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_TAB_COLUMNS 
    WHERE  OWNER      = 'DOCUMENT_REPOSITORY'
    AND    TABLE_NAME = 'DOCUMENTS'
    AND    COLUMN_NAME = 'EXPIRE_ON'
    AND    DATA_TYPE   = 'DATE';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'ALTER TABLE DOCUMENT_REPOSITORY.DOCUMENTS ADD EXPIRE_ON DATE';
  END IF;
END;
/

comment on column DOCUMENT_REPOSITORY.DOCUMENTS.expire_on is 'Data de expirao do documento';



