package pt.digitalis.dif.documents.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.documents.model.data.Documents;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class Documents.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.documents.model.data.Documents
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IDocumentsDAO extends IHibernateDAO<Documents> {

    /**
     * Obtains a new DataSet for the Documents entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Documents> getDocumentsDataSet();

	/**
	 * Persist a Documents object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Documents transientInstance);

	/**
	 * Updates a modified Documents in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Documents instance);

	/**
	 * Attach an unmodified Documents instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Documents instance);

	/**
	 * Removes a Documents instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Documents persistentInstance);

	/**
	 * Merge a Documents instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Documents merge(Documents detachedInstance);

	/**
	 * Finds a Documents instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Documents findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all Documents instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<Documents> findAll();


	/**
	 * Gets a {@link List} of all Documents instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<Documents> findByFieldParcial(Documents.Fields field, String value);

}
