package pt.digitalis.dif.documents.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.documents.model.DocumentsFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.documents.model.data.Documents;
import pt.digitalis.dif.documents.model.dao.auto.IDocumentsDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Documents.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.documents.model.data.Documents
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class DocumentsDAOImpl implements IDocumentsDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the Documents entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Documents> getDocumentsDataSet()
    {
        return new HibernateDataSet<Documents>(Documents.class, this, Documents.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DocumentsFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public DocumentsDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a Documents object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Documents transientInstance) {
        logger.debug("persisting Documents instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified Documents in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Documents instance) {
        logger.debug("attaching dirty Documents instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified Documents instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Documents instance) {
        logger.debug("attaching clean Documents instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a Documents instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Documents persistentInstance) {
        logger.debug("deleting Documents instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a Documents instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Documents merge(Documents detachedInstance) {
        logger.debug("merging Documents instance");
        Documents result = (Documents) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a Documents instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Documents findById( java.lang.Long id) {
        logger.debug("getting Documents instance with id: " + id);
        Documents instance = (Documents) getSession()
                .get(Documents.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all Documents instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Documents> findAll() {

 		List<Documents> instances = new ArrayList<Documents>();
		logger.debug("getting all Documents instances");
        instances = getSession().createCriteria(Documents.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Documents>) instances;
    }


	/**
	 * Gets a {@link List} of all Documents instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<Documents> findByExample(Documents instance) {
        logger.debug("finding Documents instance by example");
        List<Documents> results = (List<Documents>) getSession()
                .createCriteria(Documents.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all Documents instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Documents> findByFieldParcial(Documents.Fields field, String value) {
        logger.debug("finding Documents instance by parcial value: "+field+" like "+value);
        List<Documents> results = (List<Documents>) getSession()
                .createCriteria(Documents.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

