package pt.digitalis.dif.documents.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link Documents}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class DocumentsFieldAttributes extends AbstractBeanAttributesDefinition{

    /** creationDate (Database column: CREATION_DATE - Data de criao) */
    static public AttributeDefinition creationDate =
        new AttributeDefinition("creationDate")
                .setDescription("Data de criao")
                .setDatabaseSchema("DOCUMENT_REPOSITORY")
                .setDatabaseTable("DOCUMENTS")
                .setDatabaseId("CREATION_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Date.class);

    /** creator (Database column: CREATOR - Username) */
    static public AttributeDefinition creator =
        new AttributeDefinition("creator")
                .setDescription("Username")
                .setDatabaseSchema("DOCUMENT_REPOSITORY")
                .setDatabaseTable("DOCUMENTS")
                .setDatabaseId("CREATOR")
                .setMandatory(false)
                .setMaxSize(1000)
                .setType(String.class);

    /** description (Database column: DESCRIPTION - Descrio) */
    static public AttributeDefinition description =
        new AttributeDefinition("description")
                .setDescription("Descrio")
                .setDatabaseSchema("DOCUMENT_REPOSITORY")
                .setDatabaseTable("DOCUMENTS")
                .setDatabaseId("DESCRIPTION")
                .setMandatory(false)
                .setMaxSize(1000)
                .setType(String.class);

    /** document (Database column: DOCUMENT - O DOCUMENTO.) */
    static public AttributeDefinition document =
        new AttributeDefinition("document")
                .setDescription("O DOCUMENTO.")
                .setDatabaseSchema("DOCUMENT_REPOSITORY")
                .setDatabaseTable("DOCUMENTS")
                .setDatabaseId("DOCUMENT")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(Blob.class);

    /** expireOn (Database column: EXPIRE_ON - Data de expirao do documento) */
    static public AttributeDefinition expireOn =
        new AttributeDefinition("expireOn")
                .setDescription("Data de expirao do documento")
                .setDatabaseSchema("DOCUMENT_REPOSITORY")
                .setDatabaseTable("DOCUMENTS")
                .setDatabaseId("EXPIRE_ON")
                .setMandatory(false)
                .setMaxSize(7)
                .setType(Date.class);

    /** filename (Database column: FILENAME - Nome do ficheiro) */
    static public AttributeDefinition filename =
        new AttributeDefinition("filename")
                .setDescription("Nome do ficheiro")
                .setDatabaseSchema("DOCUMENT_REPOSITORY")
                .setDatabaseTable("DOCUMENTS")
                .setDatabaseId("FILENAME")
                .setMandatory(false)
                .setMaxSize(1000)
                .setType(String.class);

    /** id (Database column: ID - O IDENTIFICADOR DO DOCUMENTO) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("O IDENTIFICADOR DO DOCUMENTO")
                .setDatabaseSchema("DOCUMENT_REPOSITORY")
                .setDatabaseTable("DOCUMENTS")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setType(Long.class);

    /** mimeType (Database column: MIME_TYPE - Tipo de documento (Extenso)) */
    static public AttributeDefinition mimeType =
        new AttributeDefinition("mimeType")
                .setDescription("Tipo de documento (Extenso)")
                .setDatabaseSchema("DOCUMENT_REPOSITORY")
                .setDatabaseTable("DOCUMENTS")
                .setDatabaseId("MIME_TYPE")
                .setMandatory(false)
                .setMaxSize(100)
                .setType(String.class);

    /** name (Database column: NAME - Nome do documento) */
    static public AttributeDefinition name =
        new AttributeDefinition("name")
                .setDescription("Nome do documento")
                .setDatabaseSchema("DOCUMENT_REPOSITORY")
                .setDatabaseTable("DOCUMENTS")
                .setDatabaseId("NAME")
                .setMandatory(false)
                .setMaxSize(1000)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(creationDate.getName(),creationDate);
        map.put(creator.getName(),creator);
        map.put(description.getName(),description);
        map.put(document.getName(),document);
        map.put(expireOn.getName(),expireOn);
        map.put(filename.getName(),filename);
        map.put(id.getName(),id);
        map.put(mimeType.getName(),mimeType);
        map.put(name.getName(),name);

        return map;
    }
}