package pt.digitalis.dif.documents.model.impl;

import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSetLegacyNoPK;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.documents.model.DocumentsFactory;
import pt.digitalis.dif.documents.model.IDocumentsService;
import pt.digitalis.dif.documents.model.data.Documents;

/**
* NOTE: This file is auto generated and will be overwrite in a future file generation.
*/
public class DocumentsServiceImpl implements IDocumentsService {

    /**
     * Constant with the session factory ID
     */
    public static String SESSION_FACTORY_NAME = "Documents";

    /**
     * Obtains a new DataSet for the Documents entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<Documents> getDocumentsDataSet() {
        return new HibernateDataSet<Documents>(Documents.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
                Documents.getPKFieldListAsString(), Documents.FieldAttributes);
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == Documents.class)
            return getDocumentsDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(Documents.class.getSimpleName()))
            return getDocumentsDataSet();

        return null;
    }
}